/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueString;

public class ValueStringIgnoreCase
extends ValueString {
    private static final ValueStringIgnoreCase EMPTY = new ValueStringIgnoreCase("");
    private int hash;

    protected ValueStringIgnoreCase(String value) {
        super(value);
    }

    @Override
    public int getValueType() {
        return 14;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return mode.compareString(this.value, ((ValueStringIgnoreCase)o).value, true);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueString && this.value.equalsIgnoreCase(((ValueString)other).value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("CAST(");
        return StringUtils.quoteStringSQL(builder, this.value).append(" AS VARCHAR_IGNORECASE)");
    }

    public static ValueStringIgnoreCase get(String s) {
        int length = s.length();
        if (length == 0) {
            return EMPTY;
        }
        ValueStringIgnoreCase obj = new ValueStringIgnoreCase(StringUtils.cache(s));
        if (length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        ValueStringIgnoreCase cache = (ValueStringIgnoreCase)Value.cache(obj);
        if (cache.value.equals(s)) {
            return cache;
        }
        return obj;
    }

    @Override
    protected ValueString getNew(String s) {
        return ValueStringIgnoreCase.get(s);
    }
}

