/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.function.LongSupplier;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;

public class SqlMemoryStatisticsHolder {
    public static final String SQL_QUOTAS_REG_NAME = "sql.memory.quotas";
    private final LongAdderMetric quotaRequestedCnt;
    private final LongAdderMetric offloadingWritten;
    private final LongAdderMetric offloadingRead;
    private final LongAdderMetric offloadedQueriesNum;

    public SqlMemoryStatisticsHolder(final QueryMemoryManager memMgr, GridMetricManager metricMgr) {
        MetricRegistry quotasMetrics = metricMgr.registry(SQL_QUOTAS_REG_NAME);
        this.quotaRequestedCnt = quotasMetrics.longAdderMetric("requests", "How many times memory quota have been requested on this node by all the queries in total.");
        this.offloadingWritten = quotasMetrics.longAdderMetric("OffloadingWritten", "Metrics that indicates the number of bytes written to the disk during SQL query offloading.");
        this.offloadingRead = quotasMetrics.longAdderMetric("OffloadingRead", "Metrics that indicates the number of bytes read from the disk during SQL query offloading.");
        this.offloadedQueriesNum = quotasMetrics.longAdderMetric("OffloadedQueriesNumber", "Metrics that indicates the number of queries were offloaded to disk locally.");
        quotasMetrics.register("maxMem", new LongSupplier(){

            @Override
            public long getAsLong() {
                return memMgr.memoryLimit();
            }
        }, "How much memory in bytes it is possible to reserve by all the queries in total on this node. Negative value if sql memory quotas are disabled. Individual queries have additional per query quotas.");
        quotasMetrics.register("freeMem", new LongSupplier(){

            @Override
            public long getAsLong() {
                return memMgr.memoryLimit() - memMgr.reserved();
            }
        }, "How much memory in bytes currently left available for the queries on this node. Negative value if sql memory quotas are disabled.");
    }

    public void trackReserve() {
        this.quotaRequestedCnt.increment();
    }

    public void trackOffloadingWritten(long written) {
        this.offloadingWritten.add(written);
    }

    public void trackOffloadingRead(long read) {
        this.offloadingRead.add(read);
    }

    public void trackQueryOffloaded() {
        this.offloadedQueriesNum.increment();
    }
}

