/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.mxbean.SqlQueryMXBean;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;

public class SqlQueryMXBeanImpl
implements SqlQueryMXBean {
    private final IgniteH2Indexing h2idx;

    public SqlQueryMXBeanImpl(GridKernalContext ctx) {
        this.h2idx = (IgniteH2Indexing)ctx.query().getIndexing();
    }

    @Override
    public long getLongQueryWarningTimeout() {
        return this.h2idx.longRunningQueries().getTimeout();
    }

    @Override
    public void setLongQueryWarningTimeout(long longQryWarningTimeout) {
        this.h2idx.longRunningQueries().setTimeout(longQryWarningTimeout);
    }

    @Override
    public int getLongQueryTimeoutMultiplier() {
        return this.h2idx.longRunningQueries().getTimeoutMultiplier();
    }

    @Override
    public void setLongQueryTimeoutMultiplier(int longQryTimeoutMultiplier) {
        this.h2idx.longRunningQueries().setTimeoutMultiplier(longQryTimeoutMultiplier);
    }

    @Override
    public long getResultSetSizeThreshold() {
        return this.h2idx.longRunningQueries().getResultSetSizeThreshold();
    }

    @Override
    public void setResultSetSizeThreshold(long rsSizeThreshold) {
        this.h2idx.longRunningQueries().setResultSetSizeThreshold(rsSizeThreshold);
    }

    @Override
    public int getResultSetSizeThresholdMultiplier() {
        return this.h2idx.longRunningQueries().getResultSetSizeThresholdMultiplier();
    }

    @Override
    public void setResultSetSizeThresholdMultiplier(int rsSizeThresholdMultiplier) {
        this.h2idx.longRunningQueries().setResultSetSizeThresholdMultiplier(rsSizeThresholdMultiplier);
    }

    @Override
    public String getSqlGlobalMemoryQuota() {
        return this.h2idx.memoryManager().getGlobalQuota();
    }

    @Override
    public void setSqlGlobalMemoryQuota(String size) {
        this.h2idx.memoryManager().setGlobalQuota(size);
    }

    @Override
    public String getSqlQueryMemoryQuota() {
        return this.h2idx.memoryManager().getQueryQuotaString();
    }

    @Override
    public void setSqlQueryMemoryQuota(String size) {
        this.h2idx.memoryManager().setQueryQuota(size);
    }

    @Override
    public boolean isSqlOffloadingEnabled() {
        return this.h2idx.memoryManager().isOffloadingEnabled();
    }

    @Override
    public void setSqlOffloadingEnabled(boolean enabled) {
        this.h2idx.memoryManager().setOffloadingEnabled(enabled);
    }
}

