/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueRow;

public class H2ManagedLocalResult
implements LocalResult {
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private TreeMap<Value, Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit = -1;
    private boolean fetchPercent;
    private SortOrder withTiesSortOrder;
    private boolean limitsWereApplied;
    private boolean distinct;
    private int[] distinctIndexes;
    private boolean closed;
    private boolean containsLobs;
    private Boolean containsNull;
    private ResultExternal external;
    private H2MemoryTracker memTracker;
    private long memReserved;

    public H2ManagedLocalResult() {
    }

    public H2ManagedLocalResult(Session ses, Expression[] expressions, int visibleColCnt) {
        this.session = ses;
        this.rows = Utils.newSmallArrayList();
        this.visibleColumnCount = visibleColCnt;
        this.rowId = -1;
        this.expressions = expressions;
        this.memTracker = this.session.memoryTracker();
    }

    private boolean hasAvailableMemory(ValueRow distinctRowKey, Value[] oldRow, Value[] row) {
        assert (!this.isClosed());
        if (this.memTracker == null) {
            return true;
        }
        long memory = H2Utils.calculateMemoryDelta(distinctRowKey, oldRow, row);
        boolean hasMemory = true;
        if (memory < 0L) {
            this.memTracker.release(-memory);
        } else {
            hasMemory = this.memTracker.reserve(memory);
        }
        this.memReserved += memory;
        return hasMemory;
    }

    public boolean isLazy() {
        return false;
    }

    public void setMaxMemoryRows(int maxValue) {
    }

    public H2ManagedLocalResult createShallowCopy(SessionInterface targetSession) {
        if (this.containsLobs) {
            return null;
        }
        ResultExternal e2 = null;
        if (this.external != null && (e2 = this.external.createShallowCopy()) == null) {
            return null;
        }
        H2ManagedLocalResult cp = new H2ManagedLocalResult();
        cp.session = (Session)targetSession;
        cp.visibleColumnCount = this.visibleColumnCount;
        cp.expressions = this.expressions;
        cp.rowId = -1;
        cp.rowCount = this.rowCount;
        cp.rows = this.rows;
        cp.sort = this.sort;
        cp.distinctRows = this.distinctRows;
        cp.distinct = this.distinct;
        cp.distinctIndexes = this.distinctIndexes;
        cp.currentRow = null;
        cp.offset = 0;
        cp.limit = -1;
        cp.containsNull = this.containsNull;
        cp.external = e2;
        return cp;
    }

    public void setSortOrder(SortOrder sort) {
        this.sort = sort;
    }

    public void setDistinct() {
        assert (this.distinctIndexes == null);
        this.distinct = true;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    public void setDistinct(int[] distinctIndexes) {
        assert (!this.distinct);
        this.distinctIndexes = distinctIndexes;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    private boolean isAnyDistinct() {
        return this.distinct || this.distinctIndexes != null;
    }

    public void removeDistinct(Value[] values) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        assert (values.length == this.visibleColumnCount);
        if (this.distinctRows != null) {
            ValueRow array = ValueRow.get((Value[])values);
            this.distinctRows.remove(array);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.external.removeRow(values);
        }
    }

    public boolean containsDistinct(Value[] values) {
        ValueRow array;
        assert (values.length == this.visibleColumnCount);
        if (this.external != null) {
            return this.external.contains(values);
        }
        if (this.distinctRows == null) {
            this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
            for (Value[] row : this.rows) {
                ValueRow array2 = this.getDistinctRow(row);
                this.distinctRows.put((Value)array2, array2.getList());
            }
        }
        return this.distinctRows.get(array = ValueRow.get((Value[])values)) != null;
    }

    public boolean containsNull() {
        Boolean r = this.containsNull;
        if (r == null) {
            r = false;
            this.reset();
            block0: while (this.next()) {
                Value[] row = this.currentRow;
                for (int i = 0; i < this.visibleColumnCount; ++i) {
                    if (!row[i].containsNull()) continue;
                    r = true;
                    break block0;
                }
            }
            this.reset();
            this.containsNull = r;
        }
        return r;
    }

    public void reset() {
        this.rowId = -1;
        this.currentRow = null;
        if (this.external != null) {
            this.external.reset();
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() {
        if (!this.closed && this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.external != null ? this.external.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public boolean isAfterLast() {
        return this.rowId >= this.rowCount;
    }

    private void cloneLobs(Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            Value v2 = v.copyToResult();
            if (v2 == v) continue;
            this.containsLobs = true;
            this.session.addTemporaryLob(v2);
            values[i] = v2;
        }
    }

    private ValueRow getDistinctRow(Value[] values) {
        if (this.distinctIndexes != null) {
            int cnt = this.distinctIndexes.length;
            Value[] newValues = new Value[cnt];
            for (int i = 0; i < cnt; ++i) {
                newValues[i] = values[this.distinctIndexes[i]];
            }
            values = newValues;
        } else if (values.length > this.visibleColumnCount) {
            values = Arrays.copyOf(values, this.visibleColumnCount);
        }
        return ValueRow.get((Value[])values);
    }

    private void createExternalResult(boolean forcePlainResult) {
        QueryMemoryManager memMgr = (QueryMemoryManager)this.session.groupByDataFactory();
        this.external = forcePlainResult ? memMgr.createPlainExternalResult(this.session) : (this.distinct || this.distinctIndexes != null || this.sort != null ? memMgr.createSortedExternalResult(this.session, this.distinct, this.distinctIndexes, this.visibleColumnCount, this.sort, this.rowCount) : memMgr.createPlainExternalResult(this.session));
    }

    public void addRow(Value[] values) {
        this.cloneLobs(values);
        if (this.isAnyDistinct()) {
            if (this.distinctRows != null) {
                ValueRow array = this.getDistinctRow(values);
                Value[] previous = this.distinctRows.get(array);
                if (previous == null || this.sort != null && this.sort.compare(previous, values) > 0) {
                    this.distinctRows.put((Value)array, values);
                }
                this.rowCount = this.distinctRows.size();
                if (!this.hasAvailableMemory(array, previous, values)) {
                    this.addRowsToDisk(false);
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.external.addRow(values);
            }
        } else {
            ++this.rowCount;
            if (this.external == null) {
                this.rows.add(values);
                if (!this.hasAvailableMemory(null, null, values)) {
                    this.addRowsToDisk(false);
                }
            } else {
                this.external.addRow(values);
            }
        }
    }

    private void addRowsToDisk(boolean forcePlainResult) {
        if (this.external == null) {
            this.createExternalResult(forcePlainResult);
        }
        if (this.distinctRows == null) {
            this.rowCount = this.external.addRows(this.rows);
            this.rows.clear();
        } else {
            this.rowCount = this.external.addRows(this.distinctRows.values());
            this.distinctRows.clear();
        }
        this.memTracker.release(this.memReserved);
        this.memReserved = 0L;
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() {
        if (this.external != null) {
            this.addRowsToDisk(false);
        } else {
            if (this.isAnyDistinct()) {
                this.rows = new ArrayList<Value[]>(this.distinctRows.values());
            }
            if (this.sort != null && this.limit != 0 && !this.limitsWereApplied) {
                boolean withLimit;
                boolean bl = withLimit = this.limit > 0 && this.withTiesSortOrder == null;
                if (this.offset > 0 || withLimit) {
                    this.sort.sort(this.rows, this.offset, withLimit ? this.limit : this.rows.size());
                } else {
                    this.sort.sort(this.rows);
                }
            }
        }
        this.applyOffsetAndLimit();
        this.reset();
    }

    private void applyOffsetAndLimit() {
        boolean clearAll;
        if (this.limitsWereApplied) {
            return;
        }
        int offset = Math.max(this.offset, 0);
        int limit = this.limit;
        if (offset == 0 && limit < 0 && !this.fetchPercent || this.rowCount == 0) {
            return;
        }
        if (this.fetchPercent) {
            if (limit < 0 || limit > 100) {
                throw DbException.getInvalidValueException((String)"FETCH PERCENT", (Object)limit);
            }
            limit = (int)(((long)limit * (long)this.rowCount + 99L) / 100L);
        }
        boolean bl = clearAll = offset >= this.rowCount || limit == 0;
        if (!clearAll) {
            int remaining = this.rowCount - offset;
            int n = limit = limit < 0 ? remaining : Math.min(remaining, limit);
            if (offset == 0 && remaining <= limit) {
                return;
            }
        } else {
            limit = 0;
        }
        this.distinctRows = null;
        this.rowCount = limit;
        if (this.external == null) {
            if (clearAll) {
                this.rows.clear();
                return;
            }
            int to = offset + limit;
            if (this.withTiesSortOrder != null) {
                Value[] expected = this.rows.get(to - 1);
                while (to < this.rows.size() && this.withTiesSortOrder.compare(expected, this.rows.get(to)) == 0) {
                    ++to;
                    ++this.rowCount;
                }
            }
            if (offset != 0 || to != this.rows.size()) {
                this.rows = new ArrayList<Value[]>(this.rows.subList(offset, to));
            }
        } else {
            if (clearAll) {
                this.external.close();
                this.external = null;
                return;
            }
            this.trimExternal(offset, limit);
        }
    }

    private void trimExternal(int offset, int limit) {
        ResultExternal temp = this.external;
        this.external = null;
        temp.reset();
        while (--offset >= 0) {
            temp.next();
        }
        Value[] row = null;
        while (--limit >= 0) {
            row = temp.next();
            this.rows.add(row);
            if (this.hasAvailableMemory(null, null, row)) continue;
            this.addRowsToDisk(true);
        }
        if (this.withTiesSortOrder != null && row != null) {
            Value[] expected = row;
            while ((row = temp.next()) != null && this.withTiesSortOrder.compare(expected, row) == 0) {
                this.rows.add(row);
                ++this.rowCount;
                if (this.hasAvailableMemory(null, null, row)) continue;
                this.addRowsToDisk(true);
            }
        }
        if (this.external != null) {
            this.addRowsToDisk(true);
        }
        temp.close();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void limitsWereApplied() {
        this.limitsWereApplied = true;
    }

    public boolean hasNext() {
        return !this.closed && this.rowId < this.rowCount - 1;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setFetchPercent(boolean fetchPercent) {
        this.fetchPercent = fetchPercent;
    }

    public void setWithTies(SortOrder withTiesSortOrder) {
        assert (this.sort == null || this.sort == withTiesSortOrder);
        this.withTiesSortOrder = withTiesSortOrder;
    }

    public boolean needToClose() {
        return !this.closed;
    }

    public long memoryReserved() {
        return this.memReserved;
    }

    public void close() {
        if (!this.closed) {
            this.onClose();
            if (this.external != null) {
                this.external.close();
                this.external = null;
            }
            this.closed = true;
        }
    }

    public String getAlias(int i) {
        return this.expressions[i].getAlias();
    }

    public String getTableName(int i) {
        return this.expressions[i].getTableName();
    }

    public String getSchemaName(int i) {
        return this.expressions[i].getSchemaName();
    }

    public String getColumnName(int i) {
        return this.expressions[i].getColumnName();
    }

    public TypeInfo getColumnType(int i) {
        return this.expressions[i].getType();
    }

    public int getNullable(int i) {
        return this.expressions[i].getNullable();
    }

    public boolean isAutoIncrement(int i) {
        return this.expressions[i].isAutoIncrement();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return super.toString() + " columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getFetchSize() {
        return 0;
    }

    public void setFetchSize(int fetchSize) {
    }

    public H2MemoryTracker memoryTracker() {
        return this.memTracker;
    }

    protected void onClose() {
        this.distinctRows = null;
        this.rows = null;
        if (this.memReserved > 0L) {
            H2MemoryTracker tracker = this.session.memoryTracker();
            assert (tracker != null);
            tracker.release(this.memReserved);
            this.memReserved = 0L;
        }
    }
}

