/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.engine.Session;

public class H2QueryInfo {
    private final Long runningQryId;
    private final QueryType type;
    private final long beginTs;
    private final String schema;
    private final String sql;
    private final boolean enforceJoinOrder;
    private final boolean distributedJoin;
    private final boolean lazy;
    private final Prepared stmt;

    public H2QueryInfo(QueryType type, PreparedStatement stmt, String sql, Long runningQryId) {
        try {
            assert (stmt != null);
            this.type = type;
            this.sql = sql;
            this.runningQryId = runningQryId;
            this.beginTs = U.currentTimeMillis();
            this.schema = stmt.getConnection().getSchema();
            Session s = H2Utils.session(stmt.getConnection());
            this.enforceJoinOrder = s.isForceJoinOrder();
            this.distributedJoin = s.isJoinBatchEnabled();
            this.lazy = s.isLazyQueryExecution();
            this.stmt = GridSqlQueryParser.prepared(stmt);
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Cannot collect query info", 1, (Throwable)e);
        }
    }

    protected void printInfo(StringBuilder msg) {
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public void printLogMessage(IgniteLogger log, String msg, String additionalInfo) {
        this.printLogMessage(log, null, msg, additionalInfo);
    }

    public Long runningQueryId() {
        return this.runningQryId;
    }

    public void printLogMessage(IgniteLogger log, ConnectionManager connMgr, String msg, String additionalInfo) {
        StringBuilder msgSb = new StringBuilder(msg + " [");
        if (additionalInfo != null) {
            msgSb.append(additionalInfo).append(", ");
        }
        msgSb.append("duration=").append(this.time()).append("ms").append(", type=").append((Object)this.type).append(", distributedJoin=").append(this.distributedJoin).append(", enforceJoinOrder=").append(this.enforceJoinOrder).append(", lazy=").append(this.lazy).append(", schema=").append(this.schema);
        msgSb.append(", sql='").append(this.sql);
        msgSb.append("', plan=").append(this.stmt.getPlanSQL(false));
        this.printInfo(msgSb);
        msgSb.append(']');
        LT.warn((IgniteLogger)log, (String)msgSb.toString());
    }

    public String description() {
        return "H2QueryInfo [type=" + (Object)((Object)this.type) + ", runningQryId=" + this.runningQryId + ", beginTs=" + this.beginTs + ", distributedJoin=" + this.distributedJoin + ", enforceJoinOrder=" + this.enforceJoinOrder + ", lazy=" + this.lazy + ", schema=" + this.schema + ", sql='" + this.sql + "']";
    }

    public static enum QueryType {
        LOCAL,
        MAP,
        REDUCE;

    }
}

