/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.IgniteMBeansManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.mxbean.SqlQueryMXBean;
import org.apache.ignite.internal.mxbean.SqlQueryMXBeanImpl;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.IgniteClusterReadOnlyException;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.StaticMvccQueryTracker;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.RegisteredQueryCursor;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.ColumnInformation;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryFinishedInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.GridQueryStartedInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.TableInformation;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.CommandProcessor;
import org.apache.ignite.internal.processors.query.h2.CommandResult;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.apache.ignite.internal.processors.query.h2.FunctionsManager;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2JavaObjectSerializer;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2RowCacheRegistry;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildFullClosure;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildPartialClosure;
import org.apache.ignite.internal.processors.query.h2.LongRunningQueryManager;
import org.apache.ignite.internal.processors.query.h2.ManagedGroupByDataFactory;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryTracker;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParser;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultSelect;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.affinity.H2PartitionResolver;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionExtractor;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeClientIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccLeafIO;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.sql.GridFirstValueFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridLastValueFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationManager;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.lang.IgniteSingletonIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.h2.api.AggregateFunction;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.store.DataHandler;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableType;
import org.h2.util.JdbcUtils;
import org.h2.value.DataType;
import org.jetbrains.annotations.Nullable;

public class IgniteH2Indexing
implements GridQueryIndexing {
    private static final int DFLT_UPDATE_RERUN_ATTEMPTS = 4;
    private final boolean updateInTxAllowed = Boolean.getBoolean("IGNITE_ALLOW_DML_INSIDE_TRANSACTION");
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private GridSpinBusyLock busyLock;
    private final H2RowCacheRegistry rowCache = new H2RowCacheRegistry();
    protected volatile GridKernalContext ctx;
    private final QueryContextRegistry qryCtxRegistry = new QueryContextRegistry();
    private CommandProcessor cmdProc;
    protected PartitionReservationManager partReservationMgr;
    private PartitionExtractor partExtractor;
    private RunningQueryManager runningQryMgr;
    private QueryParser parser;
    private QueryMemoryManager memoryMgr;
    private DistributedSqlConfiguration distrCfg;
    private final IgniteInClosure<? super IgniteInternalFuture<?>> logger = new IgniteInClosure<IgniteInternalFuture<?>>(){

        public void apply(IgniteInternalFuture<?> fut) {
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)IgniteH2Indexing.this.log, (Object)e.getMessage(), (Throwable)e);
            }
        }
    };
    private ConnectionManager connMgr;
    private SchemaManager schemaMgr;
    private LongRunningQueryManager longRunningQryMgr;
    private GridLocalEventListener discoLsnr;
    private GridMessageListener qryLsnr;

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public List<JdbcParameterMeta> parameterMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        assert (qry != null);
        ArrayList<JdbcParameterMeta> metas = new ArrayList<JdbcParameterMeta>();
        SqlFieldsQuery curQry = qry;
        while (curQry != null) {
            QueryParserResult parsed = this.parser.parse(schemaName, curQry, true);
            metas.addAll(parsed.parametersMeta());
            curQry = parsed.remainingQuery();
        }
        return metas;
    }

    public List<GridQueryFieldMetadata> resultMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        if (parsed.remainingQuery() != null) {
            return null;
        }
        if (parsed.isSelect()) {
            return parsed.select().meta();
        }
        return null;
    }

    public void store(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        String cacheName = cctx.name();
        H2TableDescriptor tbl = this.schemaMgr.tableForType(this.schema(cacheName), cacheName, type.name());
        if (tbl == null) {
            return;
        }
        tbl.table().update(row, prevRow, prevRowAvailable);
        if (tbl.luceneIndex() != null) {
            long expireTime = row.expireTime();
            if (expireTime == 0L) {
                expireTime = Long.MAX_VALUE;
            }
            tbl.luceneIndex().store((CacheObject)row.key(), row.value(), row.version(), expireTime);
        }
    }

    public void remove(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row) throws IgniteCheckedException {
        String cacheName;
        H2TableDescriptor tbl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + row.key() + ", val=" + row.value() + ']');
        }
        if ((tbl = this.schemaMgr.tableForType(this.schema(cacheName = cctx.name()), cacheName, type.name())) == null) {
            return;
        }
        if (tbl.table().remove(row) && tbl.luceneIndex() != null) {
            tbl.luceneIndex().remove((CacheObject)row.key());
        }
    }

    public void dynamicIndexCreate(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        this.schemaMgr.createIndex(schemaName, tblName, idxDesc, ifNotExists, cacheVisitor);
    }

    public void dynamicIndexDrop(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        this.schemaMgr.dropIndex(schemaName, idxName, ifExists);
    }

    public void dynamicAddColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        this.schemaMgr.addColumn(schemaName, tblName, cols, ifTblExists, ifColNotExists);
        this.clearPlanCache();
    }

    public void dynamicDropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
        this.schemaMgr.dropColumn(schemaName, tblName, cols, ifTblExists, ifColExists);
        this.clearPlanCache();
    }

    GridH2IndexBase createSortedIndex(String name, GridH2Table tbl, boolean pk, boolean affinityKey, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, int inlineSize) {
        try {
            GridCacheContextInfo cacheInfo = tbl.cacheInfo();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating cache index [cacheId=" + cacheInfo.cacheId() + ", idxName=" + name + ']');
            }
            if (cacheInfo.affinityNode()) {
                int segments = tbl.rowDescriptor().context().config().getQueryParallelism();
                H2RowCache cache = this.rowCache.forGroup(cacheInfo.groupId());
                return H2TreeIndex.createIndex(cacheInfo.cacheContext(), cache, tbl, name, pk, affinityKey, unwrappedCols, wrappedCols, inlineSize, segments, this.log);
            }
            return H2TreeClientIndex.createIndex(tbl, name, pk, unwrappedCols, inlineSize, this.log);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalText(String schemaName, String cacheName, String qry, String typeName, IndexingQueryFilter filters) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.schemaMgr.tableForType(schemaName, cacheName, typeName);
        if (tbl != null && tbl.luceneIndex() != null) {
            Long qryId = this.runningQueryManager().register(qry, GridCacheQueryType.TEXT, schemaName, true, null, null, null);
            Throwable failReason = null;
            try {
                GridCloseableIterator gridCloseableIterator = tbl.luceneIndex().query(qry.toUpperCase(), filters);
                return gridCloseableIterator;
            }
            catch (Throwable t) {
                failReason = t;
                throw t;
            }
            finally {
                this.runningQueryManager().unregister(qryId, failReason);
            }
        }
        return new GridEmptyCloseableIterator();
    }

    private GridQueryFieldsResult executeSelectLocal(final @Nullable Long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, QueryParserResultSelect select, IndexingQueryFilter filter, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, boolean inTx, final int timeout) {
        assert (!select.mvccEnabled() || mvccTracker != null);
        final String qry = select.forUpdate() ? (inTx ? select.forUpdateQueryTx() : select.forUpdateQueryOutTx()) : qryDesc.sql();
        boolean mvccEnabled = mvccTracker != null;
        try {
            assert (select != null);
            if (this.ctx.security().enabled()) {
                this.checkSecurity(select.cacheIds());
            }
            MvccSnapshot mvccSnapshot = null;
            if (mvccEnabled) {
                mvccSnapshot = mvccTracker.snapshot();
            }
            final long maxMem = qryParams.maxMemory();
            final QueryContext qctx = new QueryContext(0, filter, null, mvccSnapshot, null, true);
            return new GridQueryFieldsResultAdapter(select.meta(), null){

                public GridCloseableIterator<List<?>> iterator() throws IgniteCheckedException {
                    H2PooledConnection conn = IgniteH2Indexing.this.connections().connection(qryDesc.schemaName());
                    try {
                        H2Utils.setupConnection(conn, qctx, qryDesc.distributedJoins(), qryDesc.enforceJoinOrder(), qryParams.lazy());
                        List args = F.asList((Object[])qryParams.arguments());
                        PreparedStatement stmt = conn.prepareStatement(qry, H2StatementCache.queryFlags(qryDesc));
                        H2Utils.bindParameters(stmt, args);
                        H2QueryInfo qryInfo = new H2QueryInfo(H2QueryInfo.QueryType.LOCAL, stmt, qry, qryId);
                        ResultSet rs = IgniteH2Indexing.this.executeSqlQueryWithTimer(stmt, conn, qry, timeout, cancel, qryParams.dataPageScanEnabled(), qryInfo, maxMem);
                        return new H2FieldsIterator(rs, mvccTracker, conn, qryParams.pageSize(), IgniteH2Indexing.this.log, IgniteH2Indexing.this, qryInfo);
                    }
                    catch (Error | RuntimeException | IgniteCheckedException e) {
                        conn.close();
                        try {
                            if (mvccTracker != null) {
                                mvccTracker.onDone();
                            }
                        }
                        catch (Exception e0) {
                            e.addSuppressed(e0);
                        }
                        throw e;
                    }
                }
            };
        }
        catch (Exception e) {
            GridNearTxLocal tx = null;
            if (mvccEnabled && (tx != null || (tx = MvccUtils.tx((GridKernalContext)this.ctx)) != null)) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    public static int operationTimeout(int qryTimeout, IgniteTxAdapter tx) {
        if (tx != null) {
            int remaining = (int)tx.remainingTime();
            return remaining > 0 && qryTimeout > 0 ? Math.min(remaining, qryTimeout) : Math.max(remaining, qryTimeout);
        }
        return qryTimeout;
    }

    public long streamUpdateQuery(String schemaName, String qry, @Nullable Object[] params, IgniteDataStreamer<?, ?> streamer, String qryInitiatorId) throws IgniteCheckedException {
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        return this.streamQuery0(qry, schemaName, streamer, dml, params, qryInitiatorId);
    }

    public List<Long> streamBatchedUpdateQuery(String schemaName, String qry, List<Object[]> params, SqlClientContext cliCtx, String qryInitiatorId) throws IgniteCheckedException {
        if (cliCtx == null || !cliCtx.isStream()) {
            U.warn((IgniteLogger)this.log, (Object)"Connection is not in streaming mode.");
            return IgniteH2Indexing.zeroBatchedStreamedUpdateResult(params.size());
        }
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        IgniteDataStreamer streamer = cliCtx.streamerForCache(dml.streamTable().cacheName());
        assert (streamer != null);
        ArrayList<Long> ress = new ArrayList<Long>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            long res = this.streamQuery0(qry, schemaName, streamer, dml, params.get(i), qryInitiatorId);
            ress.add(res);
        }
        return ress;
    }

    private long streamQuery0(String qry, String schemaName, IgniteDataStreamer streamer, QueryParserResultDml dml, Object[] args, String qryInitiatorId) throws IgniteCheckedException {
        Long qryId = this.runningQryMgr.register(qry, GridCacheQueryType.SQL_FIELDS, schemaName, true, null, null, qryInitiatorId);
        Throwable failReason = null;
        try {
            UpdatePlan plan = dml.plan();
            List<List<?>> planRows = plan.createRows(args != null ? args : X.EMPTY_OBJECT_ARRAY);
            GridQueryCacheObjectsIterator iter = new GridQueryCacheObjectsIterator(planRows.iterator(), this.objectContext(), true);
            if (planRows.size() == 1) {
                IgniteBiTuple<?, ?> t = plan.processRow((List)iter.next());
                streamer.addData(t.getKey(), t.getValue());
                long l = 1L;
                return l;
            }
            LinkedHashMap<Object, Object> rows = new LinkedHashMap<Object, Object>(plan.rowCount());
            while (iter.hasNext()) {
                List row = (List)iter.next();
                IgniteBiTuple<?, ?> t = plan.processRow(row);
                rows.put(t.getKey(), t.getValue());
            }
            streamer.addData(rows);
            long l = rows.size();
            return l;
        }
        catch (IgniteCheckedException | IgniteException e) {
            failReason = e;
            throw e;
        }
        finally {
            this.runningQryMgr.unregister(qryId, failReason);
        }
    }

    private QueryParserResultDml streamerParse(String schemaName, String qry) {
        QueryParserResult parseRes = this.parser.parse(schemaName, new SqlFieldsQuery(qry), false);
        QueryParserResultDml dml = parseRes.dml();
        if (dml == null || !dml.streamable()) {
            throw new IgniteSQLException("Streaming mode supports only INSERT commands without subqueries.", 1002);
        }
        return dml;
    }

    private static List<Long> zeroBatchedStreamedUpdateResult(int size) {
        Object[] res = new Long[size];
        Arrays.fill(res, (Object)0L);
        return Arrays.asList(res);
    }

    private ResultSet executeSqlQuery(H2PooledConnection conn, PreparedStatement stmt, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        if (cancel != null) {
            cancel.add(() -> IgniteH2Indexing.cancelStatement(stmt));
        }
        Session ses = H2Utils.session(conn);
        if (timeoutMillis > 0) {
            ses.setQueryTimeout(timeoutMillis);
        } else {
            ses.setQueryTimeout(0);
        }
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{QueryMemoryTracker.TrackerWasClosedException.class})) {
                cancel.checkCancelled();
            }
            if (e.getErrorCode() == 57014) {
                throw new QueryCancelledException();
            }
            if (e.getCause() instanceof IgniteSQLException) {
                throw (IgniteSQLException)e.getCause();
            }
            if (e.getCause() instanceof CacheException) {
                throw (CacheException)e.getCause();
            }
            throw new IgniteSQLException(e);
        }
    }

    private static void cancelStatement(PreparedStatement stmt) {
        try {
            stmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeSqlQueryWithTimer(H2PooledConnection conn, String sql, @Nullable Collection<Object> params, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo, long maxMem) throws IgniteCheckedException {
        PreparedStatement stmt = conn.prepareStatementNoCache(sql);
        H2Utils.bindParameters(stmt, params);
        return this.executeSqlQueryWithTimer(stmt, conn, sql, timeoutMillis, cancel, dataPageScanEnabled, qryInfo, maxMem);
    }

    public void enableDataPageScan(Boolean dataPageScanEnabled) {
        CacheDataTree.setDataPageScanEnabled((boolean)false);
    }

    public ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, H2PooledConnection conn, String sql, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo, long maxMem) throws IgniteCheckedException {
        if (qryInfo != null) {
            this.longRunningQryMgr.registerQuery(qryInfo);
            this.initSession(conn, qryInfo, maxMem);
        }
        this.enableDataPageScan(dataPageScanEnabled);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Start execute query: " + qryInfo);
            }
            ResultSet rs = this.executeSqlQuery(conn, stmt, timeoutMillis, cancel);
            if (qryInfo != null && qryInfo.time() > this.longRunningQryMgr.getTimeout()) {
                qryInfo.printLogMessage(this.log, "Long running query is finished", null);
            }
            ResultSet resultSet = rs;
            return resultSet;
        }
        catch (Throwable e) {
            if (qryInfo != null && qryInfo.time() > this.longRunningQryMgr.getTimeout()) {
                qryInfo.printLogMessage(this.log, "Long running query is finished with error: " + e.getMessage(), null);
            }
            throw e;
        }
        finally {
            CacheDataTree.setDataPageScanEnabled((boolean)false);
            if (qryInfo != null) {
                this.longRunningQryMgr.unregisterQuery(qryInfo);
                H2Utils.session(conn).queryDescription(null);
            }
        }
    }

    public void initSession(H2PooledConnection conn, H2QueryInfo qryInfo, long maxMem) {
        Session s = H2Utils.session(conn);
        s.groupByDataFactory((ManagedGroupByDataFactory)this.memoryMgr);
        s.queryDescription(qryInfo::description);
        GridRunningQueryInfo runningQryInfo = null;
        if (qryInfo.runningQueryId() != null) {
            runningQryInfo = this.runningQryMgr.runningQueryInfo(qryInfo.runningQueryId());
        }
        if (runningQryInfo != null && runningQryInfo.memoryMetricProvider() != null && !(runningQryInfo.memoryMetricProvider() instanceof H2MemoryTracker)) {
            return;
        }
        H2MemoryTracker tracker = null;
        if (runningQryInfo != null && runningQryInfo.memoryMetricProvider() instanceof H2MemoryTracker) {
            tracker = ((H2MemoryTracker)runningQryInfo.memoryMetricProvider()).createChildTracker();
        }
        if (tracker == null) {
            tracker = (H2MemoryTracker)this.memoryMgr.createQueryMemoryTracker(maxMem);
        }
        s.memoryTracker(tracker);
    }

    public SqlFieldsQuery generateFieldsQuery(String cacheName, SqlQuery qry) {
        String sql;
        String type;
        String schemaName = this.schema(cacheName);
        H2TableDescriptor tblDesc = this.schemaMgr.tableForType(schemaName, cacheName, type = qry.getType());
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        try {
            sql = H2Utils.generateFieldsQueryString(qry.getSql(), qry.getAlias(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        SqlFieldsQuery res = new SqlFieldsQuery(sql);
        res.setArgs(qry.getArgs());
        res.setDistributedJoins(qry.isDistributedJoins());
        res.setLocal(qry.isLocal());
        res.setPageSize(qry.getPageSize());
        res.setPartitions(qry.getPartitions());
        res.setReplicatedOnly(qry.isReplicatedOnly());
        res.setSchema(schemaName);
        res.setSql(sql);
        if (qry.getTimeout() > 0) {
            res.setTimeout(qry.getTimeout(), TimeUnit.MILLISECONDS);
        }
        return res;
    }

    private FieldsQueryCursor<List<?>> executeCommand(QueryDescriptor qryDesc, QueryParameters qryParams, @Nullable SqlClientContext cliCtx, QueryParserResultCommand cmd) {
        if (cmd.noOp()) {
            return H2Utils.zeroCursor();
        }
        SqlCommand cmdNative = cmd.commandNative();
        GridSqlStatement cmdH2 = cmd.commandH2();
        if (qryDesc.local()) {
            throw new IgniteSQLException("DDL statements are not supported for LOCAL caches", 1002);
        }
        Long qryId = this.registerRunningQuery(qryDesc, qryParams, null);
        CommandResult res = null;
        Throwable failReason = null;
        try {
            res = this.cmdProc.runCommand(qryDesc.sql(), cmdNative, cmdH2, qryParams, cliCtx, qryId);
            FieldsQueryCursor<List<?>> fieldsQueryCursor = res.cursor();
            return fieldsQueryCursor;
        }
        catch (IgniteException e) {
            failReason = e;
            throw e;
        }
        catch (IgniteCheckedException e) {
            failReason = e;
            throw new IgniteSQLException("Failed to execute DDL statement [stmt=" + qryDesc.sql() + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        finally {
            if (res == null || res.unregisterRunningQuery()) {
                this.runningQryMgr.unregister(qryId, failReason);
            }
        }
    }

    private void checkClusterState(QueryParserResult parseRes) {
        if (!this.ctx.state().publicApiActiveState(true)) {
            if (parseRes.isCommand()) {
                QueryParserResultCommand cmd = parseRes.command();
                assert (cmd != null);
                SqlCommand cmd0 = cmd.commandNative();
                if (cmd0 instanceof SqlCommitTransactionCommand || cmd0 instanceof SqlRollbackTransactionCommand) {
                    return;
                }
            }
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, GridQueryCancel cancel) {
        try {
            ArrayList res = new ArrayList(1);
            SqlFieldsQuery remainingQry = qry;
            while (remainingQry != null) {
                QueryParserResult parseRes = this.parser.parse(schemaName, remainingQry, !failOnMultipleStmts);
                remainingQry = parseRes.remainingQuery();
                QueryDescriptor newQryDesc = parseRes.queryDescriptor();
                QueryParameters newQryParams = parseRes.queryParameters();
                if (!newQryDesc.batched()) {
                    int qryParamsCnt;
                    int n = qryParamsCnt = F.isEmpty((Object[])newQryParams.arguments()) ? 0 : newQryParams.arguments().length;
                    if (qryParamsCnt < parseRes.parametersCount()) {
                        throw new IgniteSQLException("Invalid number of query parameters [expected=" + parseRes.parametersCount() + ", actual=" + qryParamsCnt + ']');
                    }
                }
                this.checkClusterState(parseRes);
                if (parseRes.isCommand()) {
                    QueryParserResultCommand cmd = parseRes.command();
                    assert (cmd != null);
                    FieldsQueryCursor<List<?>> cmdRes = this.executeCommand(newQryDesc, newQryParams, cliCtx, cmd);
                    res.add(cmdRes);
                    continue;
                }
                if (parseRes.isDml()) {
                    QueryParserResultDml dml = parseRes.dml();
                    assert (dml != null);
                    List<? extends FieldsQueryCursor<List<?>>> dmlRes = this.executeDml(newQryDesc, newQryParams, dml, cancel);
                    res.addAll(dmlRes);
                    continue;
                }
                assert (parseRes.isSelect());
                QueryParserResultSelect select = parseRes.select();
                assert (select != null);
                List<? extends FieldsQueryCursor<List<?>>> qryRes = this.executeSelect(newQryDesc, newQryParams, select, keepBinary, cancel);
                res.addAll(qryRes);
            }
            return res;
        }
        catch (Error | RuntimeException e) {
            GridNearTxLocal tx = (GridNearTxLocal)this.ctx.cache().context().tm().tx();
            if (!(tx == null || tx.mvccSnapshot() == null || e instanceof IgniteSQLException && ((IgniteSQLException)e).sqlState() == "42000")) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    private List<? extends FieldsQueryCursor<List<?>>> executeDml(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) {
        IndexingQueryFilter filter = qryDesc.local() ? this.backupFilter(null, qryParams.partitions()) : null;
        Long qryId = this.registerRunningQuery(qryDesc, qryParams, cancel);
        Throwable failReason = null;
        try {
            if (!dml.mvccEnabled() && !this.updateInTxAllowed && this.ctx.cache().context().tm().inUserTx()) {
                throw new IgniteSQLException("DML statements are not allowed inside a transaction over cache(s) with TRANSACTIONAL atomicity mode (change atomicity mode to TRANSACTIONAL_SNAPSHOT or disable this error message with system property \"-DIGNITE_ALLOW_DML_INSIDE_TRANSACTION=true\")");
            }
            if (!qryDesc.local()) {
                List<QueryCursorImpl<List<?>>> list = this.executeUpdateDistributed(qryId, qryDesc, qryParams, dml, cancel);
                return list;
            }
            final UpdateResult updRes = this.executeUpdate(qryId, qryDesc, qryParams, dml, true, filter, cancel);
            List<QueryCursorImpl> list = Collections.singletonList(new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    return new IgniteSingletonIterator(Collections.singletonList(updRes.counter()));
                }
            }, cancel, true, false));
            return list;
        }
        catch (IgniteException e) {
            failReason = e;
            throw e;
        }
        catch (IgniteCheckedException e) {
            failReason = e;
            IgniteClusterReadOnlyException roEx = (IgniteClusterReadOnlyException)X.cause((Throwable)e, IgniteClusterReadOnlyException.class);
            if (roEx != null) {
                throw new IgniteSQLException("Failed to execute DML statement. Cluster in read-only mode [stmt=" + qryDesc.sql() + ", params=" + Arrays.deepToString(qryParams.arguments()) + "]", 4011, (Throwable)e);
            }
            throw new IgniteSQLException("Failed to execute DML statement [stmt=" + qryDesc.sql() + ", params=" + Arrays.deepToString(qryParams.arguments()) + "]", (Throwable)e);
        }
        finally {
            this.runningQryMgr.unregister(qryId, failReason);
        }
    }

    private List<? extends FieldsQueryCursor<List<?>>> executeSelect(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, GridQueryCancel cancel) {
        assert (cancel != null);
        Long qryId = this.registerRunningQuery(qryDesc, qryParams, cancel);
        try {
            GridNearTxLocal tx = null;
            MvccQueryTracker tracker = null;
            GridCacheContext mvccCctx = null;
            boolean inTx = false;
            if (select.mvccEnabled()) {
                boolean autoStartTx;
                mvccCctx = this.ctx.cache().context().cacheContext(select.mvccCacheId().intValue());
                if (mvccCctx == null) {
                    throw new IgniteCheckedException("Cache has been stopped concurrently [cacheId=" + select.mvccCacheId() + ']');
                }
                boolean bl = autoStartTx = !qryParams.autoCommit() && MvccUtils.tx((GridKernalContext)this.ctx) == null;
                if (autoStartTx) {
                    MvccUtils.txStart((GridKernalContext)this.ctx, (long)qryParams.timeout());
                }
                tx = MvccUtils.tx((GridKernalContext)this.ctx);
                MvccUtils.checkActive((GridNearTxLocal)tx);
                inTx = tx != null;
                tracker = MvccUtils.mvccTracker((GridCacheContext)mvccCctx, (GridNearTxLocal)tx);
            }
            int timeout = IgniteH2Indexing.operationTimeout(qryParams.timeout(), tx);
            Iterable<List<?>> iter = this.executeSelect0(qryId, qryDesc, qryParams, select, keepBinary, tracker, cancel, inTx, timeout);
            if (select.forUpdate() && inTx) {
                iter = this.lockSelectedRows(iter, mvccCctx, timeout, qryParams.pageSize());
            }
            RegisteredQueryCursor cursor = new RegisteredQueryCursor(iter, cancel, this.runningQueryManager(), qryParams.lazy(), qryId);
            cancel.add(cursor::cancel);
            cursor.fieldsMeta(select.meta());
            cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
            return Collections.singletonList(cursor);
        }
        catch (Exception e) {
            this.runningQryMgr.unregister(qryId, (Throwable)e);
            if (e instanceof IgniteCheckedException) {
                throw U.convertException((IgniteCheckedException)((IgniteCheckedException)((Object)e)));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IgniteSQLException("Failed to execute SELECT statement: " + qryDesc.sql(), (Throwable)e);
        }
    }

    private QueryCursorImpl<List<?>> executeSelectForDml(@Nullable Long qryId, String schema, SqlFieldsQuery selectQry, MvccQueryTracker mvccTracker, GridQueryCancel cancel, int timeout) throws IgniteCheckedException {
        QueryParserResult parseRes = this.parser.parse(schema, selectQry, false);
        QueryParserResultSelect select = parseRes.select();
        assert (select != null);
        Iterable<List<?>> iter = this.executeSelect0(qryId, parseRes.queryDescriptor(), parseRes.queryParameters(), select, true, mvccTracker, cancel, false, timeout);
        QueryCursorImpl cursor = new QueryCursorImpl(iter, cancel, true, parseRes.queryParameters().lazy());
        cursor.fieldsMeta(select.meta());
        cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
        return cursor;
    }

    private Iterable<List<?>> executeSelect0(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, MvccQueryTracker mvccTracker, GridQueryCancel cancel, boolean inTx, int timeout) throws IgniteCheckedException {
        Iterable<List<Object>> iter;
        assert (!select.mvccEnabled() || mvccTracker != null);
        if (this.ctx.security().enabled()) {
            this.checkSecurity(select.cacheIds());
        }
        if (select.splitNeeded()) {
            GridCacheTwoStepQuery twoStepQry;
            GridCacheTwoStepQuery gridCacheTwoStepQuery = twoStepQry = select.forUpdate() && inTx ? select.forUpdateTwoStepQuery() : select.twoStepQuery();
            assert (twoStepQry != null);
            iter = this.executeSelectDistributed(qryId, qryDesc, qryParams, twoStepQry, keepBinary, mvccTracker, cancel, timeout);
        } else {
            IndexingQueryFilter filter = qryDesc.local() ? this.backupFilter(null, qryParams.partitions()) : null;
            GridQueryFieldsResult res = this.executeSelectLocal(qryId, qryDesc, qryParams, select, filter, mvccTracker, cancel, inTx, timeout);
            iter = () -> {
                try {
                    return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), this.objectContext(), keepBinary);
                }
                catch (IgniteCheckedException | IgniteSQLException e) {
                    throw new CacheException(e);
                }
            };
        }
        return iter;
    }

    private Iterable<List<?>> lockSelectedRows(final Iterable<List<?>> cur, final GridCacheContext cctx, int pageSize, long timeout) {
        assert (cctx != null && cctx.mvccEnabled());
        GridNearTxLocal tx = MvccUtils.tx((GridKernalContext)this.ctx);
        if (tx == null) {
            throw new IgniteSQLException("Failed to perform SELECT FOR UPDATE operation: transaction has already finished.");
        }
        final ArrayList rowsCache = new ArrayList();
        UpdateSourceIterator<KeyCacheObject> srcIt = new UpdateSourceIterator<KeyCacheObject>(){
            private Iterator<List<?>> it;
            {
                this.it = cur.iterator();
            }

            public EnlistOperation operation() {
                return EnlistOperation.LOCK;
            }

            public boolean hasNextX() throws IgniteCheckedException {
                return this.it.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public KeyCacheObject nextX() throws IgniteCheckedException {
                List<?> res = this.it.next();
                Collection collection = rowsCache;
                synchronized (collection) {
                    rowsCache.add(res.subList(0, res.size() - 1));
                    if (rowsCache.size() > MvccCachingManager.TX_SIZE_THRESHOLD) {
                        throw new IgniteCheckedException("Too many rows are locked by SELECT FOR UPDATE statement. Consider locking fewer keys or increase the limit by setting a IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD system property. Current value is " + MvccCachingManager.TX_SIZE_THRESHOLD + " rows.");
                    }
                }
                return cctx.toCacheKeyObject(res.get(res.size() - 1));
            }
        };
        IgniteInternalFuture fut = tx.updateAsync(cctx, (UpdateSourceIterator)srcIt, pageSize, timeout, true);
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return rowsCache;
    }

    private Long registerRunningQuery(QueryDescriptor qryDesc, QueryParameters qryParams, GridQueryCancel cancel) {
        return this.runningQryMgr.register(qryDesc.sql(), GridCacheQueryType.SQL_FIELDS, qryDesc.schemaName(), qryDesc.local(), this.memoryMgr.createQueryMemoryTracker(qryParams.maxMemory()), cancel, qryDesc.queryInitiatorId());
    }

    private void checkSecurity(Collection<Integer> cacheIds) {
        if (F.isEmpty(cacheIds)) {
            return;
        }
        for (Integer cacheId : cacheIds) {
            DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(cacheId.intValue());
            if (desc == null) continue;
            this.ctx.security().authorize(desc.cacheName(), SecurityPermission.CACHE_READ);
        }
    }

    public void registerQueryStartedListener(Consumer<GridQueryStartedInfo> lsnr) {
        this.runningQueryManager().registerQueryStartedListener(lsnr);
    }

    public boolean unregisterQueryStartedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryStartedListener(lsnr);
    }

    public void registerQueryFinishedListener(Consumer<GridQueryFinishedInfo> lsnr) {
        this.runningQueryManager().registerQueryFinishedListener(lsnr);
    }

    public boolean unregisterQueryFinishedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryFinishedListener(lsnr);
    }

    public UpdateSourceIterator<?> executeUpdateOnDataNodeTransactional(GridCacheContext<?, ?> cctx, int[] ids, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, int timeout, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, GridQueryCancel cancel) throws IgniteCheckedException {
        QueryCursorImpl cur;
        GridCacheContext cctx0;
        SqlFieldsQuery fldsQry = new SqlFieldsQuery(qry);
        if (params != null) {
            fldsQry.setArgs(params);
        }
        fldsQry.setEnforceJoinOrder(U.isFlagSet((int)flags, (int)2));
        fldsQry.setTimeout(timeout, TimeUnit.MILLISECONDS);
        fldsQry.setPageSize(pageSize);
        fldsQry.setLocal(true);
        fldsQry.setLazy(U.isFlagSet((int)flags, (int)32));
        boolean loc = true;
        boolean replicated = U.isFlagSet((int)flags, (int)16);
        if (!replicated && !F.isEmpty((int[])ids) && (cctx0 = CU.firstPartitioned((GridCacheSharedContext)cctx.shared(), (int[])ids)) != null && cctx0.config().getQueryParallelism() > 1) {
            fldsQry.setDistributedJoins(true);
            loc = false;
        }
        QueryParserResult parseRes = this.parser.parse(schema, fldsQry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        IndexingQueryFilter filter = this.backupFilter(topVer, parts);
        UpdatePlan plan = dml.plan();
        GridCacheContext planCctx = plan.cacheContext();
        DmlUtils.setKeepBinaryContext(planCctx);
        SqlFieldsQuery selectFieldsQry = new SqlFieldsQuery(plan.selectQuery(), fldsQry.isCollocated()).setArgs(fldsQry.getArgs()).setDistributedJoins(fldsQry.isDistributedJoins()).setEnforceJoinOrder(fldsQry.isEnforceJoinOrder()).setLocal(fldsQry.isLocal()).setPageSize(fldsQry.getPageSize()).setTimeout(fldsQry.getTimeout(), TimeUnit.MILLISECONDS).setLazy(fldsQry.isLazy());
        if (!loc && !plan.isLocalSubquery()) {
            cur = this.executeSelectForDml(null, schema, selectFieldsQry, (MvccQueryTracker)new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, timeout);
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(schema, selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(null, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filter, (MvccQueryTracker)new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, true, timeout);
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return res.iterator();
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }, cancel, true, selectParseRes.queryParameters().lazy());
        }
        return plan.iteratorForTransaction(this.connections(), (QueryCursor<List<?>>)cur);
    }

    private Iterable<List<?>> executeSelectDistributed(final @Nullable Long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, final GridCacheTwoStepQuery twoStepQry, final boolean keepBinary, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, final int timeout) {
        Iterable<List<?>> iter;
        PartitionResult derivedParts = twoStepQry.derivedPartitions();
        final int[] parts = PartitionResult.calculatePartitions((int[])qryParams.partitions(), (PartitionResult)derivedParts, (Object[])qryParams.arguments());
        if (parts != null && parts.length == 0) {
            iter = new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    return new Iterator<List<?>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public List<?> next() {
                            return null;
                        }
                    };
                }
            };
        } else {
            assert (!twoStepQry.mvccEnabled() || !F.isEmpty(twoStepQry.cacheIds()));
            assert (twoStepQry.mvccEnabled() == (mvccTracker != null));
            iter = new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return IgniteH2Indexing.this.rdcQryExec.query(qryId, qryDesc.schemaName(), twoStepQry, keepBinary, qryDesc.enforceJoinOrder(), timeout, cancel, qryParams.arguments(), parts, qryParams.lazy(), mvccTracker, qryParams.dataPageScanEnabled(), qryParams.pageSize(), qryParams.maxMemory());
                    }
                    catch (Throwable e) {
                        if (mvccTracker != null) {
                            mvccTracker.onDone();
                        }
                        throw e;
                    }
                }
            };
        }
        return iter;
    }

    public UpdateResult executeUpdateOnDataNode(String schemaName, SqlFieldsQuery qry, IndexingQueryFilter filter, GridQueryCancel cancel, boolean loc) throws IgniteCheckedException {
        QueryParserResult parseRes = this.parser.parse(schemaName, qry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        return this.executeUpdate(null, parseRes.queryDescriptor(), parseRes.queryParameters(), dml, loc, filter, cancel);
    }

    public boolean registerType(GridCacheContextInfo cacheInfo, GridQueryTypeDescriptor type, boolean isSql) throws IgniteCheckedException {
        H2Utils.validateTypeDescriptor(type);
        this.schemaMgr.onCacheTypeCreated(cacheInfo, this, type, isSql);
        return true;
    }

    public GridCacheContextInfo registeredCacheInfo(String cacheName) {
        for (H2TableDescriptor tbl : this.schemaMgr.tablesForCache(cacheName)) {
            if (!F.eq((Object)tbl.cacheName(), (Object)cacheName)) continue;
            return tbl.cacheInfo();
        }
        return null;
    }

    public void closeCacheOnClient(String cacheName) {
        GridCacheContextInfo cacheInfo = this.registeredCacheInfo(cacheName);
        if (cacheInfo != null) {
            this.parser.clearCache();
            cacheInfo.clearCacheContext();
        }
    }

    public String schema(String cacheName) {
        return this.schemaMgr.schemaName(cacheName);
    }

    public Set<String> schemasNames() {
        return this.schemaMgr.schemaNames();
    }

    public Collection<TableInformation> tablesInformation(String schemaNamePtrn, String tblNamePtrn, String ... tblTypes) {
        boolean allTypes;
        ArrayList<TableInformation> infos;
        HashSet<String> types;
        block5: {
            block4: {
                types = F.isEmpty((Object[])tblTypes) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(tblTypes));
                infos = new ArrayList<TableInformation>();
                allTypes = F.isEmpty((Object[])tblTypes);
                if (allTypes) break block4;
                if (!types.contains(TableType.TABLE.name())) break block5;
            }
            this.schemaMgr.dataTables().stream().filter(t -> QueryUtils.matches((String)t.getSchema().getName(), (String)schemaNamePtrn)).filter(t -> QueryUtils.matches((String)t.getName(), (String)tblNamePtrn)).map(t -> {
                int cacheGrpId = t.cacheInfo().groupId();
                CacheGroupDescriptor cacheGrpDesc = (CacheGroupDescriptor)this.ctx.cache().cacheGroupDescriptors().get(cacheGrpId);
                if (cacheGrpDesc == null) {
                    return null;
                }
                GridQueryTypeDescriptor type = t.rowDescriptor().type();
                IndexColumn affCol = t.getExplicitAffinityKeyColumn();
                String affinityKeyCol = affCol != null ? affCol.columnName : null;
                return new TableInformation(t.getSchema().getName(), t.getName(), TableType.TABLE.name(), cacheGrpId, cacheGrpDesc.cacheOrGroupName(), t.cacheId(), t.cacheName(), affinityKeyCol, type.keyFieldAlias(), type.valueFieldAlias(), type.keyTypeName(), type.valueTypeName());
            }).filter(Objects::nonNull).forEach(infos::add);
        }
        if ((allTypes || types.contains(TableType.VIEW.name())) && QueryUtils.matches((String)QueryUtils.sysSchemaName(), (String)schemaNamePtrn)) {
            this.schemaMgr.systemViews().stream().filter(t -> QueryUtils.matches((String)t.getTableName(), (String)tblNamePtrn)).map(v -> new TableInformation(QueryUtils.sysSchemaName(), v.getTableName(), TableType.VIEW.name())).forEach(infos::add);
        }
        return infos;
    }

    public Collection<ColumnInformation> columnsInformation(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        ArrayList<ColumnInformation> infos = new ArrayList<ColumnInformation>();
        this.schemaMgr.dataTables().stream().filter(t -> QueryUtils.matches((String)t.getSchema().getName(), (String)schemaNamePtrn)).filter(t -> QueryUtils.matches((String)t.getName(), (String)tblNamePtrn)).flatMap(tbl -> {
            IndexColumn affCol = tbl.getAffinityKeyColumn();
            return Stream.of(tbl.getColumns()).filter(Column::getVisible).filter(c -> QueryUtils.matches((String)c.getName(), (String)colNamePtrn)).map(c -> {
                GridQueryProperty prop = tbl.rowDescriptor().type().property(c.getName());
                boolean isAff = affCol != null && c.getColumnId() == affCol.column.getColumnId();
                return new ColumnInformation(c.getColumnId() - 2 + 1, tbl.getSchema().getName(), tbl.getName(), c.getName(), prop.type(), c.isNullable(), prop.defaultValue(), prop.precision(), prop.scale(), isAff);
            });
        }).forEach(infos::add);
        if (QueryUtils.matches((String)QueryUtils.sysSchemaName(), (String)schemaNamePtrn)) {
            this.schemaMgr.systemViews().stream().filter(v -> QueryUtils.matches((String)v.getTableName(), (String)tblNamePtrn)).flatMap(view -> Stream.of(view.getColumns()).filter(c -> QueryUtils.matches((String)c.getName(), (String)colNamePtrn)).map(c -> new ColumnInformation(c.getColumnId() + 1, QueryUtils.sysSchemaName(), view.getTableName(), c.getName(), IgniteUtils.classForName((String)DataType.getTypeClassName((int)c.getType().getValueType(), (boolean)false), Object.class), c.isNullable(), null, (int)c.getType().getPrecision(), c.getType().getScale(), false))).forEach(infos::add);
        }
        return infos;
    }

    public boolean isStreamableInsertStatement(String schemaName, SqlFieldsQuery qry) throws SQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        return parsed.isDml() && parsed.dml().streamable() && parsed.remainingQuery() == null;
    }

    public GridQueryRowCacheCleaner rowCacheCleaner(int grpId) {
        return this.rowCache.forGroup(grpId);
    }

    public void markAsRebuildNeeded(GridCacheContext cctx) {
        assert (cctx.group().persistenceEnabled()) : cctx;
        this.markIndexRebuild(cctx.name(), true);
    }

    public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx) {
        Object clo;
        assert (Objects.nonNull(cctx));
        if (!cctx.group().persistenceEnabled()) {
            return null;
        }
        IgnitePageStoreManager pageStore = cctx.shared().pageStore();
        assert (Objects.nonNull(pageStore));
        String cacheName = cctx.name();
        if (!pageStore.hasIndexStore(cctx.groupId())) {
            clo = new IndexRebuildFullClosure(cctx.queries(), cctx.mvccEnabled());
        } else {
            IndexRebuildPartialClosure clo0 = new IndexRebuildPartialClosure(cctx);
            for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
                GridH2Table tbl = tblDesc.table();
                assert (Objects.nonNull((Object)tbl));
                tbl.collectIndexesForPartialRebuild(clo0);
            }
            if (clo0.hasIndexes()) {
                clo = clo0;
            } else {
                return null;
            }
        }
        this.markIndexRebuild(cacheName, true);
        GridFutureAdapter rebuildCacheIdxFut = new GridFutureAdapter();
        GridFutureAdapter outRebuildCacheIdxFut = new GridFutureAdapter();
        cctx.group().metrics().addIndexBuildCountPartitionsLeft((long)cctx.topology().localPartitions().size());
        rebuildCacheIdxFut.listen((IgniteInClosure & Serializable)fut -> {
            Throwable err = fut.error();
            if (Objects.isNull(err)) {
                try {
                    this.markIndexRebuild(cacheName, false);
                }
                catch (Throwable t) {
                    err = t;
                }
            }
            if (Objects.nonNull(err)) {
                U.error((IgniteLogger)this.log, (Object)("Failed to rebuild indexes for cache: " + cacheName), (Throwable)err);
            }
            outRebuildCacheIdxFut.onDone(err);
        });
        this.rebuildIndexesFromHash0(cctx, (SchemaIndexCacheVisitorClosure)clo, (GridFutureAdapter<Void>)rebuildCacheIdxFut);
        return outRebuildCacheIdxFut;
    }

    protected void rebuildIndexesFromHash0(GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut) {
        new SchemaIndexCacheVisitorImpl(cctx, null, rebuildIdxFut).visit(clo);
    }

    private void markIndexRebuild(String cacheName, boolean val) {
        for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
            assert (tblDesc.table() != null);
            tblDesc.table().markRebuildFromHashInProgress(val);
        }
    }

    public GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public RunningQueryManager runningQueryManager() {
        return this.runningQryMgr;
    }

    public QueryMemoryManager memoryManager() {
        return this.memoryMgr;
    }

    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        JavaObjectSerializer h2Serializer;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        this.busyLock = busyLock;
        if (SysProperties.serializeJavaObject) {
            U.warn((IgniteLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        this.ctx = ctx;
        this.partReservationMgr = new PartitionReservationManager(ctx);
        this.connMgr = new ConnectionManager(ctx);
        this.longRunningQryMgr = new LongRunningQueryManager(ctx);
        this.parser = new QueryParser(this, this.connections());
        this.schemaMgr = new SchemaManager(ctx, this.connections());
        this.schemaMgr.start(ctx.config().getSqlConfiguration().getSqlSchemas());
        this.nodeId = ctx.localNodeId();
        this.marshaller = ctx.config().getMarshaller();
        this.memoryMgr = new QueryMemoryManager(ctx);
        this.runningQryMgr = new RunningQueryManager(ctx);
        this.mapQryExec = new GridMapQueryExecutor();
        this.rdcQryExec = new GridReduceQueryExecutor();
        this.mapQryExec.start(ctx, this);
        this.rdcQryExec.start(ctx, this);
        this.discoLsnr = evt -> {
            this.mapQryExec.onNodeLeft((DiscoveryEvent)evt);
            this.rdcQryExec.onNodeLeft((DiscoveryEvent)evt);
        };
        ctx.event().addLocalEventListener(this.discoLsnr, 12, new int[]{11});
        this.qryLsnr = (nodeId, msg, plc) -> this.onMessage(nodeId, msg);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.partExtractor = new PartitionExtractor(new H2PartitionResolver(this), ctx);
        this.cmdProc = new CommandProcessor(ctx, this.schemaMgr, this);
        this.cmdProc.start();
        if (JdbcUtils.serializer != null) {
            U.warn((IgniteLogger)this.log, (Object)"Custom H2 serialization is already configured, will override.");
        }
        JdbcUtils.serializer = h2Serializer = this.h2Serializer();
        this.connMgr.setH2Serializer(h2Serializer);
        this.registerAggregateFunctions();
        this.distrCfg = new DistributedSqlConfiguration(ctx, this.log);
        this.distrCfg.listenDisabledFunctions(new FunctionsManager());
    }

    public void onKernalStart() {
        this.memoryMgr.cleanSpillDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(UUID nodeId, Object msg) {
        assert (msg != null);
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (msg instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)msg).unmarshall(this.ctx.config().getMarshaller(), this.ctx);
            }
            try {
                boolean processed = true;
                boolean tracebleMsg = false;
                if (msg instanceof GridQueryNextPageRequest) {
                    this.mapQueryExecutor().onNextPageRequest(node, (GridQueryNextPageRequest)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridQueryNextPageResponse) {
                    this.reduceQueryExecutor().onNextPage(node, (GridQueryNextPageResponse)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridH2QueryRequest) {
                    this.mapQueryExecutor().onQueryRequest(node, (GridH2QueryRequest)msg);
                } else if (msg instanceof GridH2DmlRequest) {
                    this.mapQueryExecutor().onDmlRequest(node, (GridH2DmlRequest)msg);
                } else if (msg instanceof GridH2DmlResponse) {
                    this.reduceQueryExecutor().onDmlResponse(node, (GridH2DmlResponse)msg);
                } else if (msg instanceof GridQueryFailResponse) {
                    this.reduceQueryExecutor().onFail(node, (GridQueryFailResponse)msg);
                } else if (msg instanceof GridQueryCancelRequest) {
                    this.mapQueryExecutor().onCancel(node, (GridQueryCancelRequest)msg);
                } else {
                    processed = false;
                }
                if (processed && this.log.isDebugEnabled() && (!tracebleMsg || this.log.isTraceEnabled())) {
                    this.log.debug("Processed message: [srcNodeId=" + nodeId + ", msg=" + msg + ']');
                }
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to process message: [srcNodeId=" + nodeId + ", msg=" + msg + ']'), (Throwable)th);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CacheObjectValueContext objectContext() {
        return this.ctx.query().objectContext();
    }

    public boolean send(Object topic, int topicOrd, Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, final @Nullable IgniteInClosure2X<ClusterNode, Message> locNodeHnd, byte plc, boolean runLocParallel) {
        boolean ok = true;
        if (specialize == null && msg instanceof GridCacheQueryMarshallable) {
            ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
        }
        ClusterNode locNode = null;
        for (ClusterNode node : nodes) {
            if (node.isLocal()) {
                if (locNode != null) {
                    throw new IllegalStateException();
                }
                locNode = node;
                continue;
            }
            try {
                if (specialize != null && (msg = (Message)specialize.apply((Object)node, (Object)msg)) instanceof GridCacheQueryMarshallable) {
                    ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
                }
                this.ctx.io().sendGeneric(node, topic, topicOrd, msg, plc);
            }
            catch (IgniteCheckedException e) {
                ok = false;
                U.warn((IgniteLogger)this.log, (Object)("Failed to send message [node=" + node + ", msg=" + msg + ", errMsg=" + e.getMessage() + "]"));
            }
        }
        if (locNode != null) {
            assert (locNodeHnd != null);
            if (specialize != null && (msg = (Message)specialize.apply(locNode, (Object)msg)) instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
            }
            if (runLocParallel) {
                final ClusterNode finalLocNode = locNode;
                final Message finalMsg = msg;
                try {
                    this.ctx.closure().runLocal((Runnable)new GridPlainRunnable(){

                        public void run() {
                            if (!IgniteH2Indexing.this.busyLock.enterBusy()) {
                                return;
                            }
                            try {
                                locNodeHnd.apply((Object)finalLocNode, (Object)finalMsg);
                            }
                            finally {
                                IgniteH2Indexing.this.busyLock.leaveBusy();
                            }
                        }
                    }, plc).listen(this.logger);
                }
                catch (IgniteCheckedException e) {
                    ok = false;
                    U.error((IgniteLogger)this.log, (Object)"Failed to execute query locally.", (Throwable)e);
                }
            } else {
                locNodeHnd.apply((Object)locNode, (Object)msg);
            }
        }
        return ok;
    }

    private JavaObjectSerializer h2Serializer() {
        return new H2JavaObjectSerializer(this.ctx);
    }

    public DataHandler dataHandler() {
        return this.connMgr.dataHandler();
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        if (this.mapQryExec != null) {
            this.mapQryExec.stop();
        }
        this.qryCtxRegistry.clearSharedOnLocalNodeStop();
        if (this.runningQryMgr != null) {
            this.runningQryMgr.stop();
        }
        if (this.schemaMgr != null) {
            this.schemaMgr.stop();
        }
        if (this.longRunningQryMgr != null) {
            this.longRunningQryMgr.stop();
        }
        if (this.connMgr != null) {
            this.connMgr.stop();
        }
        if (this.connMgr != null) {
            this.cmdProc.stop();
        }
        this.memoryMgr.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    public void onClientDisconnect() throws IgniteCheckedException {
        if (!MvccUtils.mvccEnabled((GridKernalContext)this.ctx)) {
            return;
        }
        GridNearTxLocal tx = MvccUtils.tx((GridKernalContext)this.ctx);
        if (tx != null) {
            this.cmdProc.doRollback(tx);
        }
    }

    public boolean initCacheContext(GridCacheContext cacheCtx) {
        GridCacheContextInfo cacheInfo = this.registeredCacheInfo(cacheCtx.name());
        if (cacheInfo != null) {
            assert (!cacheInfo.isCacheContextInited()) : cacheInfo.name();
            assert (cacheInfo.name().equals(cacheCtx.name())) : cacheInfo.name() + " != " + cacheCtx.name();
            cacheInfo.initCacheContext(cacheCtx);
            return true;
        }
        return false;
    }

    public void registerCache(String cacheName, String schemaName, GridCacheContextInfo<?, ?> cacheInfo) throws IgniteCheckedException {
        this.rowCache.onCacheRegistered(cacheInfo);
        this.schemaMgr.onCacheCreated(cacheName, schemaName, cacheInfo.config().getSqlFunctionClasses());
    }

    public void unregisterCache(GridCacheContextInfo cacheInfo, boolean rmvIdx) {
        this.rowCache.onCacheUnregistered(cacheInfo);
        String cacheName = cacheInfo.name();
        this.partReservationMgr.onCacheStop(cacheName);
        this.schemaMgr.onCacheDestroyed(cacheName, rmvIdx);
        this.connMgr.onCacheDestroyed();
        this.clearPlanCache();
    }

    public void destroyOrphanIndex(RootPage page, String indexName, int grpId, PageMemory pageMemory, GridAtomicLong removeId, ReuseList reuseList, boolean mvccEnabled) throws IgniteCheckedException {
        assert (this.ctx.cache().context().database().checkpointLockIsHeldByThread());
        long metaPageId = page.pageId().pageId();
        int inlineSize = this.getInlineSize(page, grpId, pageMemory);
        String grpName = this.ctx.cache().cacheGroup(grpId).cacheOrGroupName();
        PageLockListener lockLsnr = this.ctx.cache().context().diagnostic().pageLockTracker().createPageLockTracker(grpName + "IndexTree##" + indexName);
        BPlusTree<H2Row, H2Row> tree = new BPlusTree<H2Row, H2Row>(indexName, grpId, grpName, pageMemory, this.ctx.cache().context().wal(), (AtomicLong)removeId, metaPageId, reuseList, H2ExtrasInnerIO.getVersions(inlineSize, mvccEnabled), H2ExtrasLeafIO.getVersions(inlineSize, mvccEnabled), this.ctx.failure(), lockLsnr){

            protected int compare(BPlusIO io, long pageAddr, int idx, H2Row row) {
                throw new AssertionError();
            }

            public H2Row getRow(BPlusIO io, long pageAddr, int idx, Object x) {
                throw new AssertionError();
            }
        };
        tree.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInlineSize(RootPage page, int grpId, PageMemory pageMemory) throws IgniteCheckedException {
        long metaPageId = page.pageId().pageId();
        long metaPage = pageMemory.acquirePage(grpId, metaPageId);
        try {
            int n;
            long pageAddr = pageMemory.readLock(grpId, metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)metaPageId) + ']';
            try {
                BPlusMetaIO io = (BPlusMetaIO)BPlusMetaIO.VERSIONS.forPage(pageAddr);
                n = io.getInlineSize(pageAddr);
            }
            catch (Throwable throwable) {
                pageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            pageMemory.readUnlock(grpId, metaPageId, metaPage);
            return n;
        }
        finally {
            pageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }

    private void clearPlanCache() {
        this.parser.clearCache();
    }

    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts) {
        return new IndexingQueryFilterImpl(this.ctx, topVer, parts);
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public boolean serverTopologyChanged(AffinityTopologyVersion readyVer) {
        GridDhtPartitionsExchangeFuture fut = this.ctx.cache().context().exchange().lastTopologyFuture();
        if (fut.isDone()) {
            return false;
        }
        AffinityTopologyVersion initVer = fut.initialVersion();
        return initVer.compareTo(readyVer) > 0 && !fut.firstEvent().node().isClient();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        this.ctx.cache().context().exchange().affinityReadyFuture(topVer).get();
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
        this.cmdProc.onDisconnected();
    }

    public List<GridRunningQueryInfo> runningSqlQueries() {
        return this.runningQryMgr.runningSqlQueries();
    }

    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        return this.runningQryMgr.longRunningQueries(duration);
    }

    public void cancelQueries(Collection<Long> queries) {
        if (!F.isEmpty(queries)) {
            for (Long qryId : queries) {
                this.runningQryMgr.cancel(qryId);
            }
        }
    }

    public void onKernalStop() {
        this.connMgr.onKernalStop();
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
    }

    public QueryContextRegistry queryContextRegistry() {
        return this.qryCtxRegistry;
    }

    public ConnectionManager connections() {
        return this.connMgr;
    }

    public QueryParser parser() {
        return this.parser;
    }

    public SchemaManager schemaManager() {
        return this.schemaMgr;
    }

    public PartitionExtractor partitionExtractor() {
        return this.partExtractor;
    }

    public PartitionReservationManager partitionReservationManager() {
        return this.partReservationMgr;
    }

    public H2MemoryTracker memoryTrackerForQry(Long qryId) {
        if (qryId == null) {
            return null;
        }
        GridRunningQueryInfo info = this.runningQryMgr.runningQueryInfo(qryId);
        if (info == null) {
            return null;
        }
        GridQueryMemoryMetricProvider memTracker = info.memoryMetricProvider();
        assert (memTracker == null || memTracker instanceof H2MemoryTracker) : "Memory tracker either should be null or should be instance of " + H2MemoryTracker.class.getName() + ", but it is " + memTracker.getClass().getName();
        return (H2MemoryTracker)memTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryCursorImpl<List<?>>> executeUpdateDistributed(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) throws IgniteCheckedException {
        if (qryDesc.batched()) {
            List<Object> ress;
            List<Object[]> argss = qryParams.batchedArguments();
            UpdatePlan plan = dml.plan();
            GridCacheContext cctx = plan.cacheContext();
            if (plan.hasRows() && plan.mode() == UpdateMode.INSERT && !cctx.mvccEnabled()) {
                CacheOperationContext opCtx = DmlUtils.setKeepBinaryContext(cctx);
                try {
                    List<List<List<?>>> cur = plan.createRows(argss);
                    ress = DmlUtils.processSelectResultBatched(plan, cur, qryParams.updateBatchSize());
                }
                finally {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            } else {
                ress = new ArrayList(argss.size());
                Throwable batchException = null;
                int[] cntPerRow = new int[argss.size()];
                boolean bl = false;
                for (Object[] args : argss) {
                    try {
                        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams.toSingleBatchedArguments(args), dml, false, null, cancel);
                        cntPerRow[var12_16++] = (int)res.counter();
                        ress.add(res);
                    }
                    catch (Exception e) {
                        SQLException sqlEx = QueryUtils.toSqlException((Exception)e);
                        batchException = DmlUtils.chainException((SQLException)batchException, sqlEx);
                        cntPerRow[var12_16++] = -3;
                    }
                }
                if (batchException != null) {
                    BatchUpdateException e = new BatchUpdateException(batchException.getMessage(), ((SQLException)batchException).getSQLState(), ((SQLException)batchException).getErrorCode(), cntPerRow, batchException);
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            ArrayList resCurs = new ArrayList(ress.size());
            for (UpdateResult updateResult : ress) {
                updateResult.throwIfError();
                QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(updateResult.counter())), cancel, false, false);
                resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
                resCurs.add(resCur);
            }
            return resCurs;
        }
        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams, dml, false, null, cancel);
        res.throwIfError();
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(res.counter())), cancel, false, false);
        resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
        resCur.partitionResult(res.partitionResult());
        return Collections.singletonList(resCur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdate(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Object[] errKeys = null;
        long items = 0L;
        PartitionResult partRes = null;
        GridCacheContext cctx = dml.plan().cacheContext();
        boolean transactional = cctx != null && cctx.mvccEnabled();
        int maxRetryCnt = transactional ? 1 : 4;
        for (int i = 0; i < maxRetryCnt; ++i) {
            UpdateResult r;
            CacheOperationContext opCtx = cctx != null ? DmlUtils.setKeepBinaryContext(cctx) : null;
            try {
                r = transactional ? this.executeUpdateTransactional(qryId, qryDesc, qryParams, dml, loc, cancel) : this.executeUpdateNonTransactional(qryId, qryDesc, qryParams, dml, loc, filters, cancel);
            }
            finally {
                if (opCtx != null) {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            }
            items += r.counter();
            errKeys = r.errorKeys();
            partRes = r.partitionResult();
            if (F.isEmpty((Object[])errKeys)) break;
        }
        if (F.isEmpty(errKeys) && partRes == null) {
            if (items == 1L) {
                return UpdateResult.ONE;
            }
            if (items == 0L) {
                return UpdateResult.ZERO;
            }
        }
        return new UpdateResult(items, errKeys, partRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdateNonTransactional(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        QueryCursorImpl cur;
        GridQueryCancel selectCancel;
        DmlDistributedPlanInfo distributedPlan;
        UpdatePlan plan = dml.plan();
        UpdateResult fastUpdateRes = plan.processFast(qryParams.arguments());
        if (fastUpdateRes != null) {
            return fastUpdateRes;
        }
        DmlDistributedPlanInfo dmlDistributedPlanInfo = distributedPlan = loc ? null : plan.distributedPlan();
        if (distributedPlan != null) {
            UpdateResult result;
            if (cancel == null) {
                cancel = new GridQueryCancel();
            }
            if ((result = this.rdcQryExec.update(qryDesc.schemaName(), distributedPlan.getCacheIds(), qryDesc.sql(), qryParams.arguments(), qryDesc.enforceJoinOrder(), qryParams.pageSize(), qryParams.timeout(), qryParams.partitions(), distributedPlan.isReplicatedOnly(), cancel)) != null) {
                return result;
            }
        }
        GridQueryCancel gridQueryCancel = selectCancel = cancel != null ? new GridQueryCancel() : null;
        if (cancel != null) {
            cancel.add(() -> ((GridQueryCancel)selectCancel).cancel());
        }
        SqlFieldsQuery selectFieldsQry = new SqlFieldsQueryEx(plan.selectQuery() == null ? "" : plan.selectQuery(), Boolean.valueOf(true)).setCollocated(qryDesc.collocated()).setArgs(qryParams.arguments()).setDistributedJoins(qryDesc.distributedJoins()).setEnforceJoinOrder(qryDesc.enforceJoinOrder()).setLocal(qryDesc.local()).setPageSize(qryParams.pageSize()).setTimeout(qryParams.timeout(), TimeUnit.MILLISECONDS).setMaxMemory(qryParams.maxMemory()).setLazy(qryParams.lazy() && plan.canSelectBeLazy());
        if (!loc && !plan.isLocalSubquery()) {
            assert (!F.isEmpty((String)plan.selectQuery()));
            cur = this.executeSelectForDml(qryId, qryDesc.schemaName(), selectFieldsQry, null, selectCancel, qryParams.timeout());
        } else if (plan.hasRows()) {
            cur = plan.createRows(qryParams.arguments());
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(qryDesc.schemaName(), selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(qryId, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filters, null, selectCancel, false, qryParams.timeout());
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), IgniteH2Indexing.this.objectContext(), true);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }, cancel, true, qryParams.lazy());
        }
        int pageSize = qryParams.updateBatchSize();
        try {
            UpdateResult updateResult = DmlUtils.processSelectResult(plan, cur, pageSize);
            return updateResult;
        }
        finally {
            if (cur instanceof AutoCloseable) {
                U.closeQuiet((AutoCloseable)((AutoCloseable)cur));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private UpdateResult executeUpdateTransactional(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, GridQueryCancel cancel) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void registerMxBeans(IgniteMBeansManager mbMgr) throws IgniteCheckedException {
        SqlQueryMXBeanImpl qryMXBean = new SqlQueryMXBeanImpl(this.ctx);
        mbMgr.registerMBean("SQL Query", qryMXBean.getClass().getSimpleName(), (Object)qryMXBean, SqlQueryMXBean.class);
    }

    public LongRunningQueryManager longRunningQueries() {
        return this.longRunningQryMgr;
    }

    public long indexSize(String schemaName, String tblName, String idxName) throws IgniteCheckedException {
        GridH2Table tbl = this.schemaMgr.dataTable(schemaName, tblName);
        if (tbl == null) {
            return 0L;
        }
        H2TreeIndex idx = (H2TreeIndex)tbl.userIndex(idxName);
        return idx == null ? 0L : idx.size();
    }

    private void registerAggregateFunctions() throws IgniteCheckedException {
        this.registerAggregateFunction("FIRSTVALUE", GridFirstValueFunction.class);
        this.registerAggregateFunction("LASTVALUE", GridLastValueFunction.class);
    }

    public void registerAggregateFunction(String fnName, Class<? extends AggregateFunction> cls) throws IgniteCheckedException {
        Objects.requireNonNull(fnName, "Function name can't be null");
        Objects.requireNonNull(cls, "Class name can't be null");
        if (!AggregateFunction.class.isAssignableFrom(cls)) {
            throw new IgniteSQLException("Aggregate function '" + cls.getName() + "' should implement '" + AggregateFunction.class.getName() + "'");
        }
        this.connections().executeStatement(null, "CREATE AGGREGATE " + fnName + " FOR \"" + cls.getName() + "\"");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Aggregation function " + fnName + "(" + cls.getName() + ") has been registered.");
        }
    }

    public DistributedSqlConfiguration distributedConfiguration() {
        return this.distrCfg;
    }

    public Map<String, Integer> secondaryIndexesInlineSize() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (GridH2Table table : this.schemaMgr.dataTables()) {
            for (Index index : table.getIndexes()) {
                if (!(index instanceof H2TreeIndexBase) || index.getIndexType().isPrimaryKey()) continue;
                map.put(index.getSchema().getName() + "#" + index.getTable().getName() + "#" + index.getName(), ((H2TreeIndexBase)index).inlineSize());
            }
        }
        return map;
    }

    static {
        PageIO.registerH2(H2InnerIO.VERSIONS, H2LeafIO.VERSIONS, H2MvccInnerIO.VERSIONS, H2MvccLeafIO.VERSIONS);
        H2ExtrasInnerIO.register();
        H2ExtrasLeafIO.register();
    }
}

