/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.NestedTxMode;

public class QueryParameters {
    private final Object[] args;
    private final int[] parts;
    private final int timeout;
    private final boolean lazy;
    private final int pageSize;
    private final Boolean dataPageScanEnabled;
    private final NestedTxMode nestedTxMode;
    private final boolean autoCommit;
    private final List<Object[]> batchedArgs;
    private final int updateBatchSize;
    private final long maxMem;

    public static QueryParameters fromQuery(SqlFieldsQuery qry) {
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        boolean autoCommit = true;
        List batchedArgs = null;
        long maxMem = 0L;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            if (qry0.getNestedTxMode() != null) {
                nestedTxMode = qry0.getNestedTxMode();
            }
            autoCommit = qry0.isAutoCommit();
            batchedArgs = qry0.batchedArguments();
            maxMem = qry0.getMaxMemory();
        }
        return new QueryParameters(qry.getArgs(), qry.getPartitions(), qry.getTimeout(), qry.isLazy(), qry.getPageSize(), maxMem, null, nestedTxMode, autoCommit, batchedArgs, qry.getUpdateBatchSize());
    }

    private QueryParameters(Object[] args, int[] parts, int timeout, boolean lazy, int pageSize, long maxMem, Boolean dataPageScanEnabled, NestedTxMode nestedTxMode, boolean autoCommit, List<Object[]> batchedArgs, int updateBatchSize) {
        this.args = args;
        this.parts = parts;
        this.timeout = timeout;
        this.lazy = lazy;
        this.pageSize = pageSize;
        this.maxMem = maxMem;
        this.dataPageScanEnabled = dataPageScanEnabled;
        this.nestedTxMode = nestedTxMode;
        this.autoCommit = autoCommit;
        this.batchedArgs = batchedArgs;
        this.updateBatchSize = updateBatchSize;
    }

    public Object[] arguments() {
        return this.args;
    }

    public int[] partitions() {
        return this.parts;
    }

    public int timeout() {
        return this.timeout;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Boolean dataPageScanEnabled() {
        return this.dataPageScanEnabled;
    }

    public NestedTxMode nestedTxMode() {
        return this.nestedTxMode;
    }

    public boolean autoCommit() {
        return this.autoCommit;
    }

    public List<Object[]> batchedArguments() {
        return this.batchedArgs;
    }

    public int updateBatchSize() {
        return this.updateBatchSize;
    }

    public long maxMemory() {
        return this.maxMem;
    }

    public QueryParameters toSingleBatchedArguments(Object[] args) {
        return new QueryParameters(args, this.parts, this.timeout, this.lazy, this.pageSize, this.maxMem, this.dataPageScanEnabled, this.nestedTxMode, this.autoCommit, null, this.updateBatchSize);
    }
}

