/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.affinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.affinity.H2PartitionResolver;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAffinityFunctionType;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAllNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionCompositeNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionCompositeNodeOperator;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionConstantNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionGroupNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionJoinCondition;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNoneNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResolver;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTable;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTableAffinityDescriptor;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTableModel;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public class PartitionExtractor {
    private static final int DFLT_MAX_EXTRACTED_PARTS_FROM_BETWEEN = 16;
    private final H2PartitionResolver partResolver;
    private final int maxPartsCntBetween;
    private final GridKernalContext ctx;

    public PartitionExtractor(H2PartitionResolver partResolver, GridKernalContext ctx) {
        this.partResolver = partResolver;
        this.maxPartsCntBetween = Integer.getInteger("IGNITE_SQL_MAX_EXTRACTED_PARTS_FROM_BETWEEN", 16);
        this.ctx = ctx;
    }

    public PartitionResult extract(GridSqlQuery qry) throws IgniteCheckedException {
        if (!(qry instanceof GridSqlSelect)) {
            return null;
        }
        GridSqlSelect select = (GridSqlSelect)qry;
        PartitionTableModel tblModel = this.prepareTableModel(select.from());
        PartitionNode tree = this.extractFromExpression(select.where(), tblModel, false);
        assert (tree != null);
        if ((tree = tree.optimize()) instanceof PartitionAllNode) {
            return null;
        }
        return new PartitionResult(tree, tblModel.joinGroupAffinity(tree.joinGroup()), this.ctx.cache().context().exchange().readyAffinityVersion());
    }

    public PartitionResult mergeMapQueries(List<GridCacheSqlQuery> qrys) {
        PartitionTableAffinityDescriptor aff = null;
        for (GridCacheSqlQuery qry : qrys) {
            PartitionResult qryRes = (PartitionResult)qry.derivedPartitions();
            if (qryRes == null) {
                return null;
            }
            if (qryRes.affinity() == null) continue;
            if (aff == null) {
                aff = qryRes.affinity();
                continue;
            }
            if (aff.isCompatible(qryRes.affinity())) continue;
            return null;
        }
        Object tree = null;
        AffinityTopologyVersion affinityTopVer = null;
        for (GridCacheSqlQuery qry : qrys) {
            PartitionResult qryRes = (PartitionResult)qry.derivedPartitions();
            tree = tree == null ? qryRes.tree() : new PartitionCompositeNode(tree, qryRes.tree(), PartitionCompositeNodeOperator.OR);
            if (affinityTopVer == null) {
                affinityTopVer = qryRes.topologyVersion();
                continue;
            }
            assert (affinityTopVer.equals((Object)qryRes.topologyVersion()));
        }
        assert (tree != null);
        if ((tree = tree.optimize()) instanceof PartitionAllNode) {
            return null;
        }
        assert (aff != null || tree == PartitionNoneNode.INSTANCE);
        assert (affinityTopVer != null);
        return new PartitionResult(tree, aff, affinityTopVer);
    }

    private PartitionTableModel prepareTableModel(GridSqlAst from) {
        PartitionTableModel res = new PartitionTableModel();
        this.prepareTableModel0(from, res);
        return res;
    }

    private List<PartitionTable> prepareTableModel0(GridSqlAst from, PartitionTableModel model) {
        if (from instanceof GridSqlJoin) {
            GridSqlJoin join = (GridSqlJoin)from;
            List<PartitionTable> leftTbls = this.prepareTableModel0(join.leftTable(), model);
            List<PartitionTable> rightTbls = this.prepareTableModel0(join.rightTable(), model);
            if (join.isLeftOuter()) {
                for (PartitionTable rightTbl : rightTbls) {
                    model.addExcludedTable(rightTbl.alias());
                }
                return leftTbls;
            }
            PartitionJoinCondition cond = PartitionExtractor.parseJoinCondition(join.on());
            if (cond != null && !cond.cross()) {
                model.addJoin(cond);
            }
            ArrayList<PartitionTable> res = new ArrayList<PartitionTable>(leftTbls.size() + rightTbls.size());
            res.addAll(leftTbls);
            res.addAll(rightTbls);
            return res;
        }
        PartitionTable tbl = PartitionExtractor.prepareTable(from, model);
        return tbl != null ? Collections.singletonList(tbl) : Collections.emptyList();
    }

    private static PartitionJoinCondition parseJoinCondition(GridSqlElement on) {
        GridSqlOperation on0;
        if (on instanceof GridSqlOperation && (on0 = (GridSqlOperation)on).operationType() == GridSqlOperationType.EQUAL) {
            GridSqlConst leftConst = PartitionExtractor.unwrapConst(on0.child(0));
            GridSqlConst rightConst = PartitionExtractor.unwrapConst(on0.child(1));
            if (leftConst != null && rightConst != null) {
                try {
                    int leftConstval = leftConst.value().getInt();
                    int rightConstVal = rightConst.value().getInt();
                    if (leftConstval == rightConstVal) {
                        return PartitionJoinCondition.CROSS;
                    }
                }
                catch (Exception leftConstval) {
                    // empty catch block
                }
            }
            if (leftConst != null || rightConst != null) {
                return null;
            }
            GridSqlColumn left = PartitionExtractor.unwrapColumn(on0.child(0));
            GridSqlColumn right = PartitionExtractor.unwrapColumn(on0.child(1));
            if (left != null && right != null) {
                String leftAlias = left.tableAlias();
                String rightAlias = right.tableAlias();
                String leftCol = left.columnName();
                String rightCol = right.columnName();
                return new PartitionJoinCondition(leftAlias, rightAlias, leftCol, rightCol);
            }
        }
        return null;
    }

    private static PartitionTable prepareTable(GridSqlAst from, PartitionTableModel tblModel) {
        assert (from instanceof GridSqlAlias);
        String alias = ((GridSqlAlias)from).alias();
        if ((from = from.child()) instanceof GridSqlTable) {
            GridSqlTable from0 = (GridSqlTable)from;
            GridH2Table tbl0 = from0.dataTable();
            if (tbl0 == null) {
                tblModel.addExcludedTable(alias);
                return null;
            }
            String cacheName = tbl0.cacheName();
            String affColName = null;
            String secondAffColName = null;
            for (Column col : tbl0.getColumns()) {
                if (!tbl0.isColumnForPartitionPruningStrict(col)) continue;
                if (affColName == null) {
                    affColName = col.getName();
                    continue;
                }
                secondAffColName = col.getName();
                break;
            }
            PartitionTable tbl = new PartitionTable(alias, cacheName, affColName, secondAffColName);
            PartitionTableAffinityDescriptor aff = PartitionExtractor.affinityForCache(tbl0.cacheInfo().config());
            if (aff == null) {
                tblModel.addExcludedTable(alias);
                return null;
            }
            tblModel.addTable(tbl, aff);
            return tbl;
        }
        assert (alias != null);
        tblModel.addExcludedTable(alias);
        return null;
    }

    private static PartitionTableAffinityDescriptor affinityForCache(CacheConfiguration ccfg) {
        if (ccfg.getCacheMode() != CacheMode.PARTITIONED) {
            return null;
        }
        PartitionAffinityFunctionType aff = ccfg.getAffinity().getClass().equals(RendezvousAffinityFunction.class) ? PartitionAffinityFunctionType.RENDEZVOUS : PartitionAffinityFunctionType.CUSTOM;
        boolean hasNodeFilter = ccfg.getNodeFilter() != null && !(ccfg.getNodeFilter() instanceof CacheConfiguration.IgniteAllNodesPredicate);
        return new PartitionTableAffinityDescriptor(aff, ccfg.getAffinity().partitions(), hasNodeFilter, ccfg.getDataRegionName());
    }

    private PartitionNode extractFromExpression(GridSqlAst expr, PartitionTableModel tblModel, boolean disjunct) throws IgniteCheckedException {
        PartitionAllNode res = PartitionAllNode.INSTANCE;
        if (expr instanceof GridSqlOperation) {
            GridSqlOperation op = (GridSqlOperation)expr;
            switch (op.operationType()) {
                case AND: {
                    res = this.extractFromAnd(op, tblModel, disjunct);
                    break;
                }
                case OR: {
                    res = this.extractFromOr(op, tblModel);
                    break;
                }
                case IN: {
                    res = this.extractFromIn(op, tblModel);
                    break;
                }
                case EQUAL: {
                    res = this.extractFromEqual(op, tblModel, disjunct);
                }
            }
        }
        return res;
    }

    private PartitionNode extractFromAnd(GridSqlOperation op, PartitionTableModel tblModel, boolean disjunct) throws IgniteCheckedException {
        assert (op.size() == 2);
        PartitionNode betweenNodes = this.tryExtractBetween(op, tblModel);
        if (betweenNodes != null) {
            return betweenNodes;
        }
        PartitionNode part1 = this.extractFromExpression((GridSqlAst)op.child(0), tblModel, disjunct);
        PartitionNode part2 = this.extractFromExpression((GridSqlAst)op.child(1), tblModel, disjunct);
        return new PartitionCompositeNode(part1, part2, PartitionCompositeNodeOperator.AND);
    }

    private PartitionNode extractFromOr(GridSqlOperation op, PartitionTableModel tblModel) throws IgniteCheckedException {
        assert (op.size() == 2);
        PartitionNode part1 = this.extractFromExpression((GridSqlAst)op.child(0), tblModel, true);
        PartitionNode part2 = this.extractFromExpression((GridSqlAst)op.child(1), tblModel, true);
        return new PartitionCompositeNode(part1, part2, PartitionCompositeNodeOperator.OR);
    }

    private PartitionNode extractFromIn(GridSqlOperation op, PartitionTableModel tblModel) throws IgniteCheckedException {
        if (op.size() < 2) {
            return PartitionAllNode.INSTANCE;
        }
        Object left = op.child();
        GridSqlColumn leftCol = PartitionExtractor.unwrapColumn(left);
        if (leftCol == null) {
            return PartitionAllNode.INSTANCE;
        }
        if (!(leftCol.column().getTable() instanceof GridH2Table)) {
            return PartitionAllNode.INSTANCE;
        }
        HashSet<PartitionSingleNode> parts = new HashSet<PartitionSingleNode>();
        for (int i = 1; i < op.size(); ++i) {
            GridSqlParameter rightParam;
            GridSqlConst rightConst;
            Object right = op.child(i);
            if (right instanceof GridSqlConst) {
                rightConst = (GridSqlConst)right;
                rightParam = null;
            } else if (right instanceof GridSqlParameter) {
                rightConst = null;
                rightParam = (GridSqlParameter)right;
            } else {
                return PartitionAllNode.INSTANCE;
            }
            PartitionSingleNode part = this.extractSingle(leftCol, rightConst, rightParam, tblModel);
            if (part == null) {
                return PartitionAllNode.INSTANCE;
            }
            parts.add(part);
        }
        return parts.size() == 1 ? (PartitionNode)parts.iterator().next() : new PartitionGroupNode(parts);
    }

    private PartitionNode extractFromEqual(GridSqlOperation op, PartitionTableModel tblModel, boolean disjunct) throws IgniteCheckedException {
        GridSqlParameter rightParam;
        GridSqlConst rightConst;
        assert (op.operationType() == GridSqlOperationType.EQUAL);
        GridSqlElement left = (GridSqlElement)op.child(0);
        GridSqlElement right = (GridSqlElement)op.child(1);
        GridSqlColumn leftCol = PartitionExtractor.unwrapColumn(left);
        if (leftCol == null) {
            return PartitionAllNode.INSTANCE;
        }
        if (!(leftCol.column().getTable() instanceof GridH2Table)) {
            return PartitionAllNode.INSTANCE;
        }
        if (right instanceof GridSqlConst) {
            rightConst = (GridSqlConst)right;
            rightParam = null;
        } else if (right instanceof GridSqlParameter) {
            rightConst = null;
            rightParam = (GridSqlParameter)right;
        } else {
            PartitionJoinCondition cond;
            if (right instanceof GridSqlColumn && !disjunct && (cond = PartitionExtractor.parseJoinCondition(op)) != null && !cond.cross()) {
                tblModel.addJoin(cond);
            }
            return PartitionAllNode.INSTANCE;
        }
        PartitionSingleNode part = this.extractSingle(leftCol, rightConst, rightParam, tblModel);
        return part != null ? part : PartitionAllNode.INSTANCE;
    }

    @Nullable
    private PartitionSingleNode extractSingle(GridSqlColumn leftCol, GridSqlConst rightConst, GridSqlParameter rightParam, PartitionTableModel tblModel) throws IgniteCheckedException {
        assert (leftCol != null);
        Column leftCol0 = leftCol.column();
        assert (leftCol0.getTable() != null);
        assert (leftCol0.getTable() instanceof GridH2Table);
        GridH2Table tbl = (GridH2Table)leftCol0.getTable();
        if (!tbl.isColumnForPartitionPruning(leftCol0)) {
            return null;
        }
        PartitionTable tbl0 = tblModel.table(leftCol.tableAlias());
        if (tbl0 == null) {
            return null;
        }
        if (rightConst != null) {
            int part = this.partResolver.partition(rightConst.value().getObject(), leftCol0.getType().getValueType(), tbl.cacheName());
            return new PartitionConstantNode(tbl0, part);
        }
        if (rightParam != null) {
            int colType = leftCol0.getType().getValueType();
            return new PartitionParameterNode(tbl0, (PartitionResolver)this.partResolver, rightParam.index(), leftCol0.getType().getValueType(), PartitionExtractor.mappedType(colType));
        }
        return null;
    }

    @Nullable
    private static PartitionParameterType mappedType(int type) {
        switch (type) {
            case 1: {
                return PartitionParameterType.BOOLEAN;
            }
            case 2: {
                return PartitionParameterType.BYTE;
            }
            case 3: {
                return PartitionParameterType.SHORT;
            }
            case 4: {
                return PartitionParameterType.INT;
            }
            case 5: {
                return PartitionParameterType.LONG;
            }
            case 8: {
                return PartitionParameterType.FLOAT;
            }
            case 7: {
                return PartitionParameterType.DOUBLE;
            }
            case 13: {
                return PartitionParameterType.STRING;
            }
            case 6: {
                return PartitionParameterType.DECIMAL;
            }
            case 20: {
                return PartitionParameterType.UUID;
            }
        }
        return null;
    }

    @Nullable
    public static GridSqlConst unwrapConst(GridSqlAst ast) {
        return ast instanceof GridSqlConst ? (GridSqlConst)ast : null;
    }

    @Nullable
    public static GridSqlColumn unwrapColumn(GridSqlAst ast) {
        if (ast instanceof GridSqlAlias) {
            ast = ast.child();
        }
        return ast instanceof GridSqlColumn ? (GridSqlColumn)ast : null;
    }

    private PartitionNode tryExtractBetween(GridSqlOperation op, PartitionTableModel tblModel) throws IgniteCheckedException {
        long rightLongVal;
        long leftLongVal;
        assert (op.size() == 2);
        Object left = op.child();
        Object right = op.child(1);
        GridSqlOperationType leftOpType = this.retrieveOperationType((GridSqlAst)left);
        GridSqlOperationType rightOpType = this.retrieveOperationType((GridSqlAst)right);
        if (!(GridSqlOperationType.BIGGER != rightOpType && GridSqlOperationType.BIGGER_EQUAL != rightOpType || GridSqlOperationType.SMALLER != leftOpType && GridSqlOperationType.SMALLER_EQUAL != leftOpType)) {
            Object tmp = left;
            left = right;
            right = tmp;
        } else if (GridSqlOperationType.BIGGER != leftOpType && GridSqlOperationType.BIGGER_EQUAL != leftOpType || GridSqlOperationType.SMALLER != rightOpType && GridSqlOperationType.SMALLER_EQUAL != rightOpType) {
            return null;
        }
        if (!(left instanceof GridSqlOperation && left.child() instanceof GridSqlColumn && ((GridSqlColumn)left.child()).column().getTable() instanceof GridH2Table)) {
            return null;
        }
        GridSqlColumn leftCol = (GridSqlColumn)left.child();
        if (!(right instanceof GridSqlOperation) || !(right.child() instanceof GridSqlColumn)) {
            return null;
        }
        GridSqlColumn rightCol = (GridSqlColumn)right.child();
        GridH2Table tbl = (GridH2Table)leftCol.column().getTable();
        if (!tbl.isColumnForPartitionPruning(leftCol.column())) {
            return null;
        }
        if (!(F.eq((Object)leftCol.schema(), (Object)rightCol.schema()) && F.eq((Object)leftCol.columnName(), (Object)rightCol.columnName()) && F.eq((Object)leftCol.tableAlias(), (Object)rightCol.tableAlias()))) {
            return null;
        }
        int leftColValueType = leftCol.column().getType().getValueType();
        if (leftColValueType != 2 && leftColValueType != 3 && leftColValueType != 4 && leftColValueType != 5) {
            return null;
        }
        if (!(left.child(1) instanceof GridSqlConst)) {
            return null;
        }
        GridSqlConst leftConst = (GridSqlConst)left.child(1);
        if (!(right.child(1) instanceof GridSqlConst)) {
            return null;
        }
        GridSqlConst rightConst = (GridSqlConst)right.child(1);
        try {
            leftLongVal = leftConst.value().getLong();
            rightLongVal = rightConst.value().getLong();
        }
        catch (Exception e) {
            return null;
        }
        if (((GridSqlOperation)left).operationType() == GridSqlOperationType.BIGGER) {
            ++leftLongVal;
        }
        if (((GridSqlOperation)right).operationType() == GridSqlOperationType.SMALLER) {
            --rightLongVal;
        }
        HashSet<PartitionConstantNode> parts = new HashSet<PartitionConstantNode>();
        PartitionTable tbl0 = tblModel.table(leftCol.tableAlias());
        if (tbl0 == null) {
            return null;
        }
        for (long i = leftLongVal; i <= rightLongVal; ++i) {
            int part = this.partResolver.partition(i, leftColValueType, tbl0.cacheName());
            parts.add(new PartitionConstantNode(tbl0, part));
            if (parts.size() <= this.maxPartsCntBetween) continue;
            return null;
        }
        return parts.isEmpty() ? PartitionNoneNode.INSTANCE : (parts.size() == 1 ? (PartitionNode)parts.iterator().next() : new PartitionGroupNode(parts));
    }

    private GridSqlOperationType retrieveOperationType(GridSqlAst ast) {
        if (!(ast instanceof GridSqlOperation)) {
            return null;
        }
        return ((GridSqlOperation)ast).operationType();
    }
}

