/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public class H2PkHashIndex
extends GridH2IndexBase {
    private final GridCacheContext cctx;
    private final int segments;

    public H2PkHashIndex(GridCacheContext<?, ?> cctx, GridH2Table tbl, String name, List<IndexColumn> colsList, int segments) {
        super(tbl, name, GridH2IndexBase.columnsArray(tbl, colsList), IndexType.createPrimaryKey((boolean)false, (boolean)true));
        assert (segments > 0) : segments;
        this.cctx = cctx;
        this.segments = segments;
    }

    @Override
    public int segmentsCount() {
        return this.segments;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        IndexingQueryCacheFilter filter = null;
        MvccSnapshot mvccSnapshot = null;
        QueryContext qctx = H2Utils.context(ses);
        int seg = 0;
        if (qctx != null) {
            IndexingQueryFilter f = qctx.filter();
            filter = f != null ? f.forCache(this.getTable().cacheName()) : null;
            mvccSnapshot = qctx.mvccSnapshot();
            seg = this.segment(qctx);
        }
        assert (!this.cctx.mvccEnabled() || mvccSnapshot != null);
        KeyCacheObject lowerObj = lower != null ? this.cctx.toCacheKeyObject(lower.getValue(0).getObject()) : null;
        KeyCacheObject upperObj = upper != null ? this.cctx.toCacheKeyObject(upper.getValue(0).getObject()) : null;
        try {
            CacheDataRowStore.setSkipVersion((boolean)true);
            ArrayList<GridCursor> cursors = new ArrayList<GridCursor>();
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cctx.offheap().cacheDataStores()) {
                int part = store.partId();
                if (this.segmentForPartition(part) != seg || filter != null && !filter.applyPartition(part)) continue;
                cursors.add(store.cursor(this.cctx.cacheId(), lowerObj, upperObj, null, mvccSnapshot));
            }
            H2PkHashIndexCursor h2PkHashIndexCursor = new H2PkHashIndexCursor(cursors.iterator());
            return h2PkHashIndexCursor;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            CacheDataRowStore.setSkipVersion((boolean)false);
        }
    }

    public boolean canScan() {
        return false;
    }

    @Override
    public H2CacheRow put(H2CacheRow row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"put");
    }

    @Override
    public boolean putx(H2CacheRow row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"putx");
    }

    @Override
    public boolean removex(SearchRow row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"removex");
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColsSet) {
        return Double.MAX_VALUE;
    }

    public long getRowCount(Session ses) {
        Cursor cursor = this.find(ses, null, null);
        long res = 0L;
        while (cursor.next()) {
            ++res;
        }
        return res;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        CacheDataRowStore.setSkipVersion((boolean)true);
        try {
            ArrayList<GridCursor> cursors = new ArrayList<GridCursor>();
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cctx.offheap().cacheDataStores()) {
                int part = store.partId();
                if (partsFilter != null && !partsFilter.applyPartition(part)) continue;
                cursors.add(store.cursor(this.cctx.cacheId()));
            }
            H2PkHashIndexCursor pkHashCursor = new H2PkHashIndexCursor(cursors.iterator());
            long res = 0L;
            while (pkHashCursor.next()) {
                ++res;
            }
            long l = res;
            return l;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        finally {
            CacheDataRowStore.setSkipVersion((boolean)false);
        }
    }

    private class H2PkHashIndexCursor
    implements Cursor {
        private final GridH2RowDescriptor desc;
        private final Iterator<GridCursor<? extends CacheDataRow>> iter;
        private GridCursor<? extends CacheDataRow> curr;
        private final long time;

        private H2PkHashIndexCursor(Iterator<GridCursor<? extends CacheDataRow>> iter) {
            assert (iter != null);
            this.iter = iter;
            this.desc = H2PkHashIndex.this.rowDescriptor();
            this.time = U.currentTimeMillis();
        }

        public Row get() {
            try {
                return this.desc.createRow((CacheDataRow)this.curr.get());
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean next() {
            try {
                CacheDataRowStore.setSkipVersion((boolean)true);
                GridQueryTypeDescriptor type = this.desc.type();
                while (true) {
                    if (this.curr != null) {
                        while (this.curr.next()) {
                            CacheDataRow row = (CacheDataRow)this.curr.get();
                            if (!type.matchType(row.value()) || this.wasExpired(row)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (!this.iter.hasNext()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.curr = this.iter.next();
                    continue;
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
            finally {
                CacheDataRowStore.setSkipVersion((boolean)false);
            }
        }

        private boolean wasExpired(CacheDataRow row) {
            return row.expireTime() > 0L && row.expireTime() <= this.time;
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

