/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeInlineObjectDetector;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class H2Tree
extends BPlusTree<H2Row, H2Row> {
    public static final String IGNITE_THROTTLE_INLINE_SIZE_CALCULATION = "IGNITE_THROTTLE_INLINE_SIZE_CALCULATION";
    private final GridCacheContext cctx;
    private final GridH2Table table;
    private final int inlineSize;
    private final List<InlineIndexColumn> inlineIdxs;
    private final IndexColumn[] cols;
    private final IndexColumn[] inlineCols;
    private final boolean mvccEnabled;
    private final boolean pk;
    private final boolean affinityKey;
    private final String cacheName;
    private final String tblName;
    private final String idxName;
    private final IoStatisticsHolder stats;
    private final Comparator<Value> comp = this::compareValues;
    private final H2RowCache rowCache;
    private final int THROTTLE_INLINE_SIZE_CALCULATION = IgniteSystemProperties.getInteger((String)"IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", (int)1000);
    private final ThreadLocal<Long> inlineSizeCalculationCntr = ThreadLocal.withInitial(() -> 0L);
    private final AtomicInteger maxCalculatedInlineSize;
    private final IgniteLogger log;
    private final boolean unwrappedPk;
    private final boolean created;

    public H2Tree(GridCacheContext cctx, GridH2Table table, String name, String idxName, String cacheName, String tblName, ReuseList reuseList, int grpId, String grpName, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, boolean initNew, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, AtomicInteger maxCalculatedInlineSize, boolean pk, boolean affinityKey, boolean mvccEnabled, @Nullable H2RowCache rowCache, @Nullable FailureProcessor failureProcessor, IgniteLogger log, IoStatisticsHolder stats, InlineIndexColumnFactory factory, int configuredInlineSize) throws IgniteCheckedException {
        super(name, grpId, grpName, pageMem, wal, globalRmvId, metaPageId, reuseList, failureProcessor, null);
        this.cctx = cctx;
        this.table = table;
        this.stats = stats;
        this.log = log;
        this.rowCache = rowCache;
        this.idxName = idxName;
        this.cacheName = cacheName;
        this.tblName = tblName;
        this.maxCalculatedInlineSize = maxCalculatedInlineSize;
        this.pk = pk;
        this.affinityKey = affinityKey;
        this.mvccEnabled = mvccEnabled;
        if (!initNew) {
            boolean inlineDecimalSupported;
            MetaPageInfo metaInfo = this.getMetaInfo();
            this.unwrappedPk = metaInfo.useUnwrappedPk();
            this.cols = (this.unwrappedPk ? unwrappedCols : wrappedCols).toArray(H2Utils.EMPTY_COLUMNS);
            this.inlineSize = metaInfo.inlineSize();
            List<InlineIndexColumn> inlineIdxs0 = H2TreeIndexBase.getAvailableInlineColumns(affinityKey, cacheName, idxName, log, pk, (Table)table, this.cols, factory, metaInfo.inlineObjectHash());
            this.setIos(H2ExtrasInnerIO.getVersions(this.inlineSize, mvccEnabled), H2ExtrasLeafIO.getVersions(this.inlineSize, mvccEnabled));
            boolean inlineObjSupported = this.inlineSize > 0 && this.inlineObjectSupported(metaInfo, inlineIdxs0);
            this.inlineIdxs = inlineObjSupported ? inlineIdxs0 : inlineIdxs0.stream().filter(ih -> ih.type() != 19).collect(Collectors.toList());
            this.inlineCols = new IndexColumn[this.inlineIdxs.size()];
            int j = 0;
            for (int i = 0; i < this.cols.length && j < this.inlineIdxs.size(); ++i) {
                if (this.cols[i].column.getColumnId() != this.inlineIdxs.get(j).columnIndex()) continue;
                this.inlineCols[j++] = this.cols[i];
            }
            boolean bl = inlineDecimalSupported = this.inlineSize > 0 && metaInfo.inlineDecimalSupported();
            if (!inlineDecimalSupported) {
                boolean decimal = false;
                Iterator<InlineIndexColumn> it = this.inlineIdxs.iterator();
                while (it.hasNext()) {
                    InlineIndexColumn ih2 = it.next();
                    if (ih2.type() == 6) {
                        decimal = true;
                    }
                    if (!decimal) continue;
                    it.remove();
                }
            }
            if (!metaInfo.flagsSupported()) {
                this.upgradeMetaPage(inlineObjSupported);
            }
        } else {
            this.unwrappedPk = true;
            this.cols = unwrappedCols.toArray(H2Utils.EMPTY_COLUMNS);
            this.inlineCols = this.cols;
            this.inlineIdxs = H2TreeIndexBase.getAvailableInlineColumns(affinityKey, cacheName, idxName, log, pk, (Table)table, this.cols, factory, true);
            this.inlineSize = H2TreeIndexBase.computeInlineSize(this.inlineIdxs, configuredInlineSize, cctx.config().getSqlIndexMaxInlineSize());
            this.setIos(H2ExtrasInnerIO.getVersions(this.inlineSize, mvccEnabled), H2ExtrasLeafIO.getVersions(this.inlineSize, mvccEnabled));
            this.initTree(true, this.inlineSize);
        }
        this.created = initNew;
    }

    private boolean inlineObjectSupported(MetaPageInfo metaInfo, List<InlineIndexColumn> inlineIdxs) {
        if (metaInfo.flagsSupported()) {
            return metaInfo.inlineObjectSupported();
        }
        try {
            if (H2TreeInlineObjectDetector.objectMayBeInlined(this.inlineSize, inlineIdxs)) {
                H2TreeInlineObjectDetector inlineObjDetector = new H2TreeInlineObjectDetector(this.inlineSize, inlineIdxs, this.tblName, this.idxName, this.log);
                this.findFirst(inlineObjDetector);
                return inlineObjDetector.inlineObjectSupported();
            }
            return false;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Unexpected exception on detect inline object", (Throwable)e);
        }
    }

    IndexColumn[] cols() {
        return this.cols;
    }

    public H2Row createRow(long link) throws IgniteCheckedException {
        if (this.rowCache != null) {
            H2CacheRow row = this.rowCache.get(link);
            if (row == null) {
                row = this.createRow0(link);
                this.rowCache.put(row);
            }
            return row;
        }
        return this.createRow0(link);
    }

    private H2CacheRow createRow0(long link) throws IgniteCheckedException {
        CacheDataRowAdapter row = new CacheDataRowAdapter(link);
        row.initFromLink(this.cctx.group(), CacheDataRowAdapter.RowData.FULL, true);
        return this.table.rowDescriptor().createRow((CacheDataRow)row);
    }

    public H2Row createMvccRow(long link, long mvccCrdVer, long mvccCntr, int mvccOpCntr) throws IgniteCheckedException {
        if (this.rowCache != null) {
            H2CacheRow row = this.rowCache.get(link);
            if (row == null) {
                row = this.createMvccRow0(link, mvccCrdVer, mvccCntr, mvccOpCntr);
                this.rowCache.put(row);
            }
            return row;
        }
        return this.createMvccRow0(link, mvccCrdVer, mvccCntr, mvccOpCntr);
    }

    private H2CacheRow createMvccRow0(long link, long mvccCrdVer, long mvccCntr, int mvccOpCntr) throws IgniteCheckedException {
        int partId = PageIdUtils.partId((long)PageIdUtils.pageId((long)link));
        MvccDataRow row = new MvccDataRow(this.cctx.group(), 0, link, partId, null, mvccCrdVer, mvccCntr, mvccOpCntr, true);
        return this.table.rowDescriptor().createRow((CacheDataRow)row);
    }

    public H2Row getRow(BPlusIO<H2Row> io, long pageAddr, int idx, Object ignore) throws IgniteCheckedException {
        return (H2Row)io.getLookupRow((BPlusTree)this, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaPageInfo getMetaInfo() throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            MetaPageInfo metaPageInfo;
            long pageAddr = this.readLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO io = (BPlusMetaIO)BPlusMetaIO.VERSIONS.forPage(pageAddr);
                metaPageInfo = new MetaPageInfo(io, pageAddr);
            }
            catch (Throwable throwable) {
                this.readUnlock(this.metaPageId, metaPage, pageAddr);
                throw throwable;
            }
            this.readUnlock(this.metaPageId, metaPage, pageAddr);
            return metaPageInfo;
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeMetaPage(boolean inlineObjSupported) throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long pageAddr = this.writeLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO.upgradePageVersion((long)pageAddr, (boolean)inlineObjSupported, (boolean)false, (int)this.pageSize());
                if (this.wal != null) {
                    this.wal.log((WALRecord)new PageSnapshot(new FullPageId(this.metaPageId, this.grpId), pageAddr, this.pageMem.pageSize(), this.pageMem.realPageSize(this.grpId)));
                }
            }
            finally {
                this.writeUnlock(this.metaPageId, metaPage, pageAddr, true);
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    protected int compare(BPlusIO<H2Row> io, long pageAddr, int idx, H2Row row) throws IgniteCheckedException {
        try {
            if (this.inlineSize() == 0) {
                return this.compareRows((H2Row)this.getRow(io, pageAddr, idx), row);
            }
            int off = io.offset(idx);
            int fieldOff = 0;
            int lastIdxUsed = 0;
            for (int i = 0; i < this.inlineIdxs.size(); ++i) {
                InlineIndexColumn inlineIdx = this.inlineIdxs.get(i);
                Value v2 = row.getValue(inlineIdx.columnIndex());
                if (v2 == null) {
                    return 0;
                }
                int c = inlineIdx.compare(pageAddr, off + fieldOff, this.inlineSize() - fieldOff, v2, this.comp);
                if (c == -2) break;
                ++lastIdxUsed;
                if (c != 0) {
                    return H2Tree.fixSort(c, this.inlineCols[i].sortType);
                }
                if ((fieldOff += inlineIdx.fullSize(pageAddr, off + fieldOff)) > this.inlineSize()) break;
            }
            if (lastIdxUsed == this.cols.length) {
                return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
            }
            this.inlineSizeRecomendation((SearchRow)row);
            SearchRow rowData = (SearchRow)this.getRow(io, pageAddr, idx);
            int len = this.cols.length;
            for (int i = lastIdxUsed; i < len; ++i) {
                IndexColumn col = this.cols[i];
                int idx0 = col.column.getColumnId();
                Value v2 = row.getValue(idx0);
                if (v2 == null) {
                    return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
                }
                Value v1 = rowData.getValue(idx0);
                int c = this.compareValues(v1, v2);
                if (c == 0) continue;
                return H2Tree.fixSort(c, col.sortType);
            }
            return this.mvccCompare((H2RowLinkIO)io, pageAddr, idx, row);
        }
        catch (DbException ex) {
            throw new IgniteCheckedException("Rows cannot be compared", (Throwable)ex);
        }
    }

    private static int fixSort(int c, int sortType) {
        return sortType == 0 ? c : -c;
    }

    public int compareRows(H2Row r1, H2Row r2) {
        assert (!this.mvccEnabled || r2.indexSearchRow() || MvccUtils.mvccVersionIsValid((long)r2.mvccCoordinatorVersion(), (long)r2.mvccCounter())) : r2;
        if (r1 == r2) {
            return 0;
        }
        for (IndexColumn idxCol : this.cols) {
            int idx = idxCol.column.getColumnId();
            Value v1 = r1.getValue(idx);
            Value v2 = r2.getValue(idx);
            if (v1 == null || v2 == null) {
                return this.mvccCompare(r1, r2);
            }
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return H2Tree.fixSort(c, idxCol.sortType);
        }
        return this.mvccCompare(r1, r2);
    }

    private int mvccCompare(H2RowLinkIO io, long pageAddr, int idx, H2Row r2) {
        if (!this.mvccEnabled || r2.indexSearchRow()) {
            return 0;
        }
        long crd = io.getMvccCoordinatorVersion(pageAddr, idx);
        long cntr = io.getMvccCounter(pageAddr, idx);
        int opCntr = io.getMvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid((long)crd, (long)cntr, (int)opCntr));
        return -MvccUtils.compare((long)crd, (long)cntr, (int)opCntr, (MvccVersionAware)r2);
    }

    private int mvccCompare(H2Row r1, H2Row r2) {
        long crdVer2;
        if (!this.mvccEnabled || r2.indexSearchRow()) {
            return 0;
        }
        long crdVer1 = r1.mvccCoordinatorVersion();
        int c = -Long.compare(crdVer1, crdVer2 = r2.mvccCoordinatorVersion());
        if (c != 0) {
            return c;
        }
        return -Long.compare(r1.mvccCounter(), r2.mvccCounter());
    }

    private void inlineSizeRecomendation(SearchRow row) {
        boolean throttle;
        if (!(row instanceof H2CacheRow)) {
            return;
        }
        Long invokeCnt = this.inlineSizeCalculationCntr.get();
        invokeCnt = invokeCnt + 1L;
        this.inlineSizeCalculationCntr.set(invokeCnt);
        boolean bl = throttle = invokeCnt % (long)this.THROTTLE_INLINE_SIZE_CALCULATION != 0L;
        if (throttle) {
            return;
        }
        int newSize = 0;
        ArrayList<String> colNames = new ArrayList<String>();
        Iterator<InlineIndexColumn> iterator = this.inlineIdxs.iterator();
        while (iterator.hasNext()) {
            InlineIndexColumn index;
            InlineIndexColumn idx = index = iterator.next();
            newSize += idx.inlineSizeOf(row.getValue(idx.columnIndex()));
            colNames.add(index.columnName());
        }
        if (newSize > this.inlineSize()) {
            int oldSize;
            do {
                if ((oldSize = this.maxCalculatedInlineSize.get()) < newSize) continue;
                return;
            } while (!this.maxCalculatedInlineSize.compareAndSet(oldSize, newSize));
            String cols = colNames.stream().collect(Collectors.joining(", ", "(", ")"));
            String idxType = this.pk ? "PRIMARY KEY" : (this.affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
            String recommendation = this.pk || this.affinityKey ? "set system property IGNITE_MAX_INDEX_PAYLOAD_SIZE with recommended size (be aware it will be used by default for all indexes without explicit inline size)" : "use INLINE_SIZE option for CREATE INDEX command, QuerySqlField.inlineSize for annotated classes, or QueryIndex.inlineSize for explicit QueryEntity configuration";
            String warn = "Indexed columns of a row cannot be fully inlined into index what may lead to slowdown due to additional data page reads, increase index inline size if needed (" + recommendation + ") [cacheName=" + this.cacheName + ", tableName=" + this.tblName + ", idxName=" + this.idxName + ", idxCols=" + cols + ", idxType=" + idxType + ", curSize=" + this.inlineSize() + ", recommendedInlineSize=" + newSize + "]";
            U.warn((IgniteLogger)this.log, (Object)warn);
        }
    }

    protected IoStatisticsHolder statisticsHolder() {
        return this.stats;
    }

    public boolean unwrappedPk() {
        return this.unwrappedPk;
    }

    public List<InlineIndexColumn> inlineIndexes() {
        return this.inlineIdxs;
    }

    public int compareValues(Value v1, Value v2) {
        return v1 == v2 ? 0 : this.table.compareValues(v1, v2);
    }

    public boolean created() {
        return this.created;
    }

    public String toString() {
        return S.toString(H2Tree.class, (Object)((Object)this), (String)"super", (Object)super.toString());
    }

    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        CorruptedTreeException e = new CorruptedTreeException(msg, cause, grpId, this.grpName, this.cacheName, this.idxName, pageIds);
        this.processFailure(FailureType.CRITICAL_ERROR, (Throwable)e);
        return e;
    }

    protected void temporaryReleaseLock() {
        this.cctx.kernalContext().cache().context().database().checkpointReadUnlock();
        this.cctx.kernalContext().cache().context().database().checkpointReadLock();
    }

    protected long maxLockHoldTime() {
        long sysWorkerBlockedTimeout = this.cctx.kernalContext().workersRegistry().getSystemWorkerBlockedTimeout();
        return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
    }

    public static class MetaPageInfo {
        int inlineSize;
        boolean useUnwrappedPk;
        boolean flagsSupported;
        boolean inlineObjSupported;
        boolean inlineObjHash;
        boolean inlineDecimalSupported;
        IgniteProductVersion createdVer;

        public MetaPageInfo(BPlusMetaIO io, long pageAddr) {
            this.inlineSize = io.getInlineSize(pageAddr);
            this.useUnwrappedPk = io.unwrappedPk(pageAddr);
            this.flagsSupported = io.supportFlags();
            if (this.flagsSupported) {
                this.inlineObjSupported = io.inlineObjectSupported(pageAddr);
                this.inlineObjHash = io.inlineObjectHash(pageAddr);
                this.inlineDecimalSupported = io.inlineDecimalSupported(pageAddr);
            }
            this.createdVer = io.createdVersion(pageAddr);
        }

        public int inlineSize() {
            return this.inlineSize;
        }

        public boolean useUnwrappedPk() {
            return this.useUnwrappedPk;
        }

        public boolean flagsSupported() {
            return this.flagsSupported;
        }

        public boolean inlineObjectSupported() {
            return this.inlineObjSupported;
        }

        public boolean inlineObjectHash() {
            return this.inlineObjHash;
        }

        public boolean inlineDecimalSupported() {
            return this.inlineDecimalSupported;
        }
    }
}

