/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.IndexType;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public abstract class H2TreeIndexBase
extends GridH2IndexBase {
    static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 10;

    protected H2TreeIndexBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super(tbl, name, cols, type);
    }

    public abstract int inlineSize();

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        long rowCnt = this.getRowCountApproximation(ses);
        double baseCost = this.costRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    static int computeInlineSize(List<InlineIndexColumn> inlineIdxs, int cfgInlineSize, int maxInlineSize) {
        int propSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        if (cfgInlineSize != -1) {
            return Math.min(2048, cfgInlineSize);
        }
        int n = propSize = maxInlineSize == -1 ? IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)10) : maxInlineSize;
        if (propSize == 0) {
            return 0;
        }
        int size = 0;
        for (InlineIndexColumn idxHelper : inlineIdxs) {
            if (idxHelper.size() <= 0) {
                size = propSize;
                break;
            }
            size += idxHelper.size() + 1;
        }
        return Math.min(2048, size);
    }

    static List<InlineIndexColumn> getAvailableInlineColumns(boolean affinityKey, String cacheName, String idxName, IgniteLogger log, boolean pk, Table tbl, IndexColumn[] cols, InlineIndexColumnFactory factory, boolean inlineObjHashSupported) {
        ArrayList<InlineIndexColumn> res = new ArrayList<InlineIndexColumn>(cols.length);
        for (IndexColumn col : cols) {
            if (!InlineIndexColumnFactory.typeSupported(col.column.getType().getValueType())) {
                String idxType = pk ? "PRIMARY KEY" : (affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
                U.warn((IgniteLogger)log, (Object)("Column cannot be inlined into the index because it's type doesn't support inlining, index access may be slow due to additional page reads (change column type if possible) [cacheName=" + cacheName + ", tableName=" + tbl.getName() + ", idxName=" + idxName + ", idxType=" + idxType + ", colName=" + col.columnName + ", columnType=" + InlineIndexColumnFactory.nameTypeByCode(col.column.getType().getValueType()) + ']'));
                res.trimToSize();
                break;
            }
            res.add(factory.createInlineHelper(col.column, inlineObjHashSupported));
        }
        return res;
    }
}

