/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueByte;

public class ByteInlineIndexColumn
extends AbstractInlineIndexColumn {
    ByteInlineIndexColumn(Column col) {
        super(col, 2, (short)1);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        byte byte1 = PageUtils.getByte((long)pageAddr, (int)(off + 1));
        byte byte2 = v.getByte();
        return Integer.signum(byte1 - byte2);
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)val.getByte());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueByte.get((byte)PageUtils.getByte((long)pageAddr, (int)(off + 1)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

