/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BooleanInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ByteInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BytesInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DateInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DecimalInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DoubleInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.FixedStringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.FloatInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.IntegerInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.LongInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ObjectBytesInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ObjectHashInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ShortInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringIgnoreCaseInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.TimeInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.TimestampInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.UuidInlineIndexColumn;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.h2.table.Column;
import org.h2.value.CompareMode;

public class InlineIndexColumnFactory {
    private static final ThreadLocal<GridTuple<List<InlineIndexColumn>>> CUR_HELPER = ThreadLocal.withInitial(GridTuple::new);
    private static final Set<Integer> AVAILABLE_TYPES = new HashSet<Integer>(Arrays.asList(1, 2, 12, 10, 7, 8, 4, 5, 19, 3, 13, 21, 14, 9, 11, 20, 6));
    private final Map<String, InlineIndexColumn> helpers = new HashMap<String, InlineIndexColumn>();
    private final CompareMode mode;

    private static InlineIndexColumn createHelper(CompareMode mode, Column col) {
        boolean useOptimizedStrComp = "OFF".equals(mode.getName());
        switch (col.getType().getValueType()) {
            case 1: {
                return new BooleanInlineIndexColumn(col);
            }
            case 2: {
                return new ByteInlineIndexColumn(col);
            }
            case 3: {
                return new ShortInlineIndexColumn(col);
            }
            case 4: {
                return new IntegerInlineIndexColumn(col);
            }
            case 5: {
                return new LongInlineIndexColumn(col);
            }
            case 8: {
                return new FloatInlineIndexColumn(col);
            }
            case 7: {
                return new DoubleInlineIndexColumn(col);
            }
            case 10: {
                return new DateInlineIndexColumn(col);
            }
            case 9: {
                return new TimeInlineIndexColumn(col);
            }
            case 11: {
                return new TimestampInlineIndexColumn(col);
            }
            case 20: {
                return new UuidInlineIndexColumn(col);
            }
            case 13: {
                return new StringInlineIndexColumn(col, useOptimizedStrComp);
            }
            case 21: {
                return new FixedStringInlineIndexColumn(col, useOptimizedStrComp);
            }
            case 14: {
                return new StringIgnoreCaseInlineIndexColumn(col, useOptimizedStrComp);
            }
            case 12: {
                return new BytesInlineIndexColumn(col, mode.isBinaryUnsigned());
            }
            case 19: {
                return new ObjectHashInlineIndexColumn(col);
            }
            case 6: {
                return new DecimalInlineIndexColumn(col);
            }
        }
        throw new IllegalStateException("Unknown value type=" + col.getType().getValueType());
    }

    public InlineIndexColumn createInlineHelper(Column col, boolean inlineObjHash) {
        int type = col.getType().getValueType();
        if (type == 19 && !inlineObjHash) {
            return new ObjectBytesInlineIndexColumn(col, this.mode.isBinaryUnsigned());
        }
        return this.helpers.computeIfAbsent(col.getName(), name -> InlineIndexColumnFactory.createHelper(this.mode, col));
    }

    public static boolean typeSupported(Integer type) {
        return AVAILABLE_TYPES.contains(type);
    }

    public InlineIndexColumnFactory(CompareMode mode) {
        this.mode = mode;
    }

    public static List<InlineIndexColumn> getCurrentInlineIndexes() {
        return (List)CUR_HELPER.get().get();
    }

    public static void setCurrentInlineIndexes(List<InlineIndexColumn> inlineIdxs) {
        CUR_HELPER.get().set(inlineIdxs);
    }

    public static void clearCurrentInlineIndexes() {
        CUR_HELPER.get().set(null);
    }

    public static String nameTypeByCode(int typeCode) {
        switch (typeCode) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "NULL";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "BYTE";
            }
            case 3: {
                return "SHORT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "LONG";
            }
            case 6: {
                return "DECIMAL";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "FLOAT";
            }
            case 9: {
                return "TIME";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIMESTAMP";
            }
            case 12: {
                return "BYTES";
            }
            case 13: {
                return "STRING";
            }
            case 14: {
                return "STRING_IGNORECASE";
            }
            case 15: {
                return "BLOB";
            }
            case 16: {
                return "CLOB";
            }
            case 17: {
                return "ARRAY";
            }
            case 18: {
                return "RESULT_SET";
            }
            case 19: {
                return "JAVA_OBJECT";
            }
            case 20: {
                return "UUID";
            }
            case 21: {
                return "STRING_FIXED";
            }
            case 22: {
                return "GEOMETRY";
            }
            case 24: {
                return "TIMESTAMP_TZ";
            }
            case 25: {
                return "ENUM";
            }
        }
        return "UNKNOWN type " + typeCode;
    }
}

