/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class LongInlineIndexColumn
extends AbstractInlineIndexColumn {
    public LongInlineIndexColumn(Column col) {
        super(col, 5, (short)8);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        long val1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
        long val2 = v.getLong();
        return Integer.signum(Long.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)val.getLong());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueLong.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

