/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueShort;

public class ShortInlineIndexColumn
extends AbstractInlineIndexColumn {
    public ShortInlineIndexColumn(Column col) {
        super(col, 3, (short)2);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        short val1 = PageUtils.getShort((long)pageAddr, (int)(off + 1));
        short val2 = v.getShort();
        return Integer.signum(val1 - val2);
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)val.getShort());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueShort.get((short)PageUtils.getShort((long)pageAddr, (int)(off + 1)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

