/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

public class TimestampInlineIndexColumn
extends AbstractInlineIndexColumn {
    public TimestampInlineIndexColumn(Column col) {
        super(col, 11, (short)16);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        long val2;
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        ValueTimestamp ts = (ValueTimestamp)v.convertTo(type);
        long val1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
        int c = Integer.signum(Long.compare(val1, val2 = ts.getDateValue()));
        if (c != 0) {
            return c;
        }
        long nanos1 = PageUtils.getLong((long)pageAddr, (int)(off + 9));
        long nanos2 = ts.getTimeNanos();
        return Integer.signum(Long.compare(nanos1, nanos2));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueTimestamp)val).getDateValue());
        PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueTimestamp)val).getTimeNanos());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueTimestamp.fromDateValueAndNanos((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

