/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueUuid;

public class UuidInlineIndexColumn
extends AbstractInlineIndexColumn {
    public UuidInlineIndexColumn(Column col) {
        super(col, 20, (short)16);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        ValueUuid uuid = (ValueUuid)v.convertTo(type);
        long part1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
        int c = Integer.signum(Long.compare(part1, uuid.getHigh()));
        if (c != 0) {
            return c;
        }
        long part2 = PageUtils.getLong((long)pageAddr, (int)(off + 9));
        return Integer.signum(Long.compare(part2, uuid.getLow()));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueUuid)val).getHigh());
        PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueUuid)val).getLow());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueUuid.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

