/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultData;
import org.h2.engine.Session;

public abstract class AbstractExternalResult<T>
implements AutoCloseable {
    protected final IgniteLogger log;
    protected int size;
    protected final H2MemoryTracker memTracker;
    protected final QueryMemoryManager memMgr;
    protected final AbstractExternalResult parent;
    private int childCnt;
    private boolean closed;
    protected final ExternalResultData<T> data;

    protected AbstractExternalResult(Session ses, boolean useHashIdx, long initSize, Class<T> cls) {
        this.memMgr = (QueryMemoryManager)ses.groupByDataFactory();
        assert (this.memMgr != null);
        this.log = this.memMgr.log();
        this.data = this.memMgr.createExternalData(ses, useHashIdx, initSize, cls);
        this.parent = null;
        this.memTracker = ses.memoryTracker().createChildTracker();
    }

    protected AbstractExternalResult(AbstractExternalResult parent) {
        this.memMgr = parent.memMgr;
        this.log = parent.log;
        this.size = parent.size;
        this.data = parent.data.createShallowCopy();
        this.parent = parent;
        this.memTracker = null;
    }

    protected boolean needToSpill() {
        return !this.memTracker.reserve(0L);
    }

    protected synchronized void onChildCreated() {
        ++this.childCnt;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent == null) {
            if (this.childCnt == 0) {
                this.onClose();
            }
        } else {
            this.parent.closeChild();
        }
    }

    protected synchronized void closeChild() {
        if (--this.childCnt == 0 && this.closed) {
            this.onClose();
        }
    }

    protected void onClose() {
        this.data.close();
    }

    public int size() {
        return this.size;
    }
}

