/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.disk.AbstractExternalResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.h2.engine.Session;
import org.h2.result.ResultExternal;
import org.h2.value.Value;
import org.h2.value.ValueRow;

public class PlainExternalResult
extends AbstractExternalResult<Value>
implements ResultExternal {
    private List<Map.Entry<ValueRow, Value[]>> rowBuff;

    public PlainExternalResult(Session ses) {
        super(ses, false, 0L, Value.class);
    }

    private PlainExternalResult(AbstractExternalResult parent) {
        super(parent);
    }

    public void reset() {
        this.spillRows();
        this.data.rewindFile();
    }

    public Value[] next() {
        Value[] row = (Value[])this.data.readRowFromFile().getValue();
        return row;
    }

    public int addRow(Value[] row) {
        this.addRowToBuffer(row);
        if (this.needToSpill()) {
            this.spillRows();
        }
        return this.size;
    }

    public int addRows(Collection<Value[]> rows) {
        if (rows.isEmpty()) {
            return this.size;
        }
        for (Value[] row : rows) {
            this.addRowToBuffer(row);
        }
        if (this.needToSpill()) {
            this.spillRows();
        }
        return this.size;
    }

    private void addRowToBuffer(Value[] row) {
        if (this.rowBuff == null) {
            this.rowBuff = new ArrayList<Map.Entry<ValueRow, Value[]>>();
        }
        this.rowBuff.add((Map.Entry<ValueRow, Value[]>)new IgniteBiTuple(null, (Object)row));
        long delta = H2Utils.calculateMemoryDelta(null, null, row);
        this.memTracker.reserve(delta);
        ++this.size;
    }

    private void spillRows() {
        if (F.isEmpty(this.rowBuff)) {
            return;
        }
        this.data.store(this.rowBuff);
        long delta = 0L;
        for (Map.Entry<ValueRow, Value[]> row : this.rowBuff) {
            delta += H2Utils.calculateMemoryDelta(null, row.getValue(), null);
        }
        this.memTracker.release(-delta);
        this.rowBuff.clear();
    }

    public int removeRow(Value[] values) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Value[] values) {
        throw new UnsupportedOperationException();
    }

    public synchronized ResultExternal createShallowCopy() {
        this.onChildCreated();
        return new PlainExternalResult(this);
    }
}

