/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2IndexCostedBase;
import org.apache.ignite.internal.processors.query.h2.opt.join.ProxyDistributedLookupBatch;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public class GridH2ProxyIndex
extends H2IndexCostedBase {
    protected Index idx;

    public GridH2ProxyIndex(GridH2Table tbl, String name, List<IndexColumn> colsList, Index idx) {
        super(tbl, name, GridH2IndexBase.columnsArray(tbl, colsList), IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)(idx instanceof SpatialIndex)));
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.idx = idx;
    }

    public Index underlyingIndex() {
        return this.idx;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) {
        GridH2RowDescriptor desc = ((GridH2Table)this.idx.getTable()).rowDescriptor();
        return this.idx.find(session, desc.prepareProxyIndexRow(first), desc.prepareProxyIndexRow(last));
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        long rowCnt = this.getRowCountApproximation(ses);
        double baseCost = this.costRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = ((GridH2IndexBase)this.idx).getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public void remove(Session session) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean canGetFirstOrLast() {
        return this.idx.canGetFirstOrLast();
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        return this.idx.findFirstOrLast(session, first);
    }

    public boolean needRebuild() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.idx.getRowCount(session);
    }

    public long getRowCountApproximation(Session ses) {
        return this.idx.getRowCountApproximation(ses);
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        IndexLookupBatch batch = this.idx.createLookupBatch(filters, filter);
        if (batch == null) {
            return null;
        }
        GridH2RowDescriptor rowDesc = ((GridH2Table)this.idx.getTable()).rowDescriptor();
        return new ProxyDistributedLookupBatch(batch, rowDesc);
    }

    public void removeChildrenAndResources(Session session) {
    }
}

