/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.result.Row;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class H2CacheRow
extends H2Row
implements CacheDataRow {
    private final GridH2RowDescriptor desc;
    private final CacheDataRow row;
    private Value[] valCache;
    int memory = -1;

    public H2CacheRow(GridH2RowDescriptor desc, CacheDataRow row) {
        this.desc = desc;
        this.row = row;
    }

    public int getColumnCount() {
        if (this.removedRow()) {
            return 1;
        }
        return 2 + this.desc.fieldsCount();
    }

    public Value getValue(int col) {
        if (this.removedRow()) {
            assert (col == 0) : col;
            return this.keyWrapped();
        }
        switch (col) {
            case 0: {
                return this.keyWrapped();
            }
            case 1: {
                return this.valueWrapped();
            }
        }
        if (this.desc.isKeyAliasColumn(col)) {
            return this.keyWrapped();
        }
        if (this.desc.isValueAliasColumn(col)) {
            return this.valueWrapped();
        }
        return this.getValue0(col - 2);
    }

    private Value getValue0(int col) {
        Value v = this.getCached(col);
        if (v != null) {
            return v;
        }
        Object res = this.desc.columnValue(this.row.key(), this.row.value(), col);
        v = res == null ? ValueNull.INSTANCE : this.wrap(res, this.desc.fieldType(col));
        this.setCached(col, v);
        return v;
    }

    public void prepareValuesCache() {
        this.valCache = new Value[this.desc.fieldsCount()];
    }

    public void clearValuesCache() {
        this.valCache = null;
    }

    private Value getCached(int colIdx) {
        return this.valCache != null ? this.valCache[colIdx] : null;
    }

    private void setCached(int colIdx, Value val) {
        if (this.valCache != null) {
            this.valCache[colIdx] = val;
        }
    }

    private Value keyWrapped() {
        return this.wrap(this.row.key(), this.desc.keyType());
    }

    private Value valueWrapped() {
        return this.wrap(this.row.value(), this.desc.valueType());
    }

    private Value wrap(Object val, int type) {
        try {
            return H2Utils.wrap(this.desc.indexing().objectContext(), val, type);
        }
        catch (ClassCastException e) {
            throw new IgniteSQLException("Failed to wrap object into H2 Value. " + e.getMessage(), 5006, (Throwable)e);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wrap object into H2 Value.", (Throwable)e);
        }
    }

    private boolean removedRow() {
        return this.row.value() == null;
    }

    public KeyCacheObject key() {
        return this.row.key();
    }

    public void key(KeyCacheObject key) {
        this.row.key(key);
    }

    public CacheObject value() {
        return this.row.value();
    }

    public GridCacheVersion version() {
        return this.row.version();
    }

    public int partition() {
        return this.row.partition();
    }

    @Override
    public long expireTime() {
        return this.row.expireTime();
    }

    public long link() {
        return this.row.link();
    }

    public void link(long link) {
        this.row.link(link);
    }

    public int hash() {
        return this.row.hash();
    }

    public int cacheId() {
        return this.row.cacheId();
    }

    @Override
    public long mvccCoordinatorVersion() {
        return this.row.mvccCoordinatorVersion();
    }

    @Override
    public long mvccCounter() {
        return this.row.mvccCounter();
    }

    @Override
    public int mvccOperationCounter() {
        return this.row.mvccOperationCounter();
    }

    @Override
    public byte mvccTxState() {
        return this.row.mvccTxState();
    }

    public long newMvccCoordinatorVersion() {
        return this.row.newMvccCoordinatorVersion();
    }

    public long newMvccCounter() {
        return this.row.newMvccCounter();
    }

    public int newMvccOperationCounter() {
        return this.row.newMvccOperationCounter();
    }

    public byte newMvccTxState() {
        return this.row.newMvccTxState();
    }

    @Override
    public boolean indexSearchRow() {
        return false;
    }

    @Override
    public void setKey(long key) {
        throw new UnsupportedOperationException();
    }

    public void setValue(int idx, Value v) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public int headerSize() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSharedData(Row other) {
        throw new UnsupportedOperationException();
    }

    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        long size = 32L;
        if (!F.isEmpty((Object[])this.valCache)) {
            int len = this.valCache.length;
            size += (long)(24 + len * 8);
            for (Value v : this.valCache) {
                if (v == null) continue;
                size += (long)v.getMemory();
            }
        }
        assert (this.row instanceof CacheDataRowAdapter);
        assert (this.row.key() instanceof KeyCacheObjectImpl);
        assert (this.row.value() instanceof BinaryObjectImpl);
        try {
            size += 56L;
            size += (long)(56 + this.row.key().valueBytesLength(null));
            size += (long)(64 + ((BinaryObjectImpl)this.row.value()).array().length);
        }
        catch (IgniteCheckedException e) {
            U.warn((IgniteLogger)this.desc.context().logger(H2CacheRow.class), (Object)((Object)e));
        }
        assert (size < Integer.MAX_VALUE);
        this.memory = (int)size;
        return this.memory;
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        Value v = this.keyWrapped();
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = this.valueWrapped();
        sb.a(", val: ").a(v == null ? "nil" : (S.includeSensitive() ? v.getString() : "Data hidden due to IGNITE_TO_STRING_INCLUDE_SENSITIVE flag."));
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 2; i < cnt; ++i) {
                if (i != 2) {
                    sb.a(", ");
                }
                try {
                    v = this.getValue(i);
                    if (this.desc.isKeyValueOrVersionColumn(i)) continue;
                    sb.a(v == null ? "nil" : (S.includeSensitive() ? v.getString() : "data hidden"));
                    continue;
                }
                catch (Exception e) {
                    sb.a("<value skipped on error: " + e.getMessage() + '>');
                }
            }
        }
        sb.a(" ]");
        return sb.toString();
    }
}

