/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.cache.CacheException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.BroadcastCursor;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedJoinContext;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeStream;
import org.apache.ignite.internal.processors.query.h2.opt.join.SegmentKey;
import org.apache.ignite.internal.processors.query.h2.opt.join.UnicastCursor;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.result.SearchRow;
import org.h2.util.DoneFuture;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class DistributedLookupBatch
implements IndexLookupBatch {
    private static final Object EXPLICIT_NULL = new Object();
    private final H2TreeIndex idx;
    private final GridCacheContext<?, ?> cctx;
    private final QueryContextRegistry qryCtxRegistry;
    private final boolean ucast;
    private final int affColId;
    private DistributedJoinContext joinCtx;
    private int batchLookupId;
    private Map<SegmentKey, RangeStream> rangeStreams = Collections.emptyMap();
    private List<SegmentKey> broadcastSegments;
    private List<Future<Cursor>> res = Collections.emptyList();
    private boolean batchFull;
    private boolean findCalled;

    public DistributedLookupBatch(H2TreeIndex idx, GridCacheContext<?, ?> cctx, QueryContextRegistry qryCtxRegistry, boolean ucast, int affColId) {
        this.idx = idx;
        this.cctx = cctx;
        this.qryCtxRegistry = qryCtxRegistry;
        this.ucast = ucast;
        this.affColId = affColId;
    }

    private Object getAffinityKey(SearchRow firstRow, SearchRow lastRow) {
        if (this.affColId == -1) {
            return null;
        }
        if (firstRow == null || lastRow == null) {
            return null;
        }
        Value affKeyFirst = firstRow.getValue(this.affColId);
        Value affKeyLast = lastRow.getValue(this.affColId);
        if (affKeyFirst != null && this.equal(affKeyFirst, affKeyLast)) {
            return affKeyFirst == ValueNull.INSTANCE ? EXPLICIT_NULL : affKeyFirst.getObject();
        }
        if (this.idx.getTable().rowDescriptor().isKeyColumn(this.affColId)) {
            return null;
        }
        Value pkFirst = firstRow.getValue(0);
        Value pkLast = lastRow.getValue(0);
        if (pkFirst == ValueNull.INSTANCE || pkLast == ValueNull.INSTANCE) {
            return EXPLICIT_NULL;
        }
        if (pkFirst == null || pkLast == null || !this.equal(pkFirst, pkLast)) {
            return null;
        }
        Object pkAffKeyFirst = this.cctx.affinity().affinityKey(pkFirst.getObject());
        Object pkAffKeyLast = this.cctx.affinity().affinityKey(pkLast.getObject());
        if (pkAffKeyFirst == null || pkAffKeyLast == null) {
            throw new CacheException("Cache key without affinity key.");
        }
        if (pkAffKeyFirst.equals(pkAffKeyLast)) {
            return pkAffKeyFirst;
        }
        return null;
    }

    public boolean addSearchRows(Session ses, SearchRow firstRow, SearchRow lastRow) {
        List segmentKeys;
        Object affKey;
        if (this.joinCtx == null || this.findCalled) {
            if (this.joinCtx == null) {
                QueryContext qctx = H2Utils.context(ses);
                this.res = new ArrayList<Future<Cursor>>();
                assert (qctx != null);
                assert (!this.findCalled);
                this.joinCtx = qctx.distributedJoinContext();
            } else {
                assert (this.batchLookupId != 0);
                this.findCalled = false;
                this.joinCtx.putStreams(this.batchLookupId, null);
                this.res.clear();
            }
            this.batchLookupId = this.joinCtx.nextBatchLookupId();
            this.rangeStreams = new HashMap<SegmentKey, RangeStream>();
        }
        if ((affKey = this.getAffinityKey(firstRow, lastRow)) != null) {
            if (affKey == EXPLICIT_NULL) {
                return false;
            }
            segmentKeys = F.asList((Object)this.rangeSegment(affKey));
        } else {
            if (this.broadcastSegments == null) {
                this.broadcastSegments = this.broadcastSegments();
            }
            segmentKeys = this.broadcastSegments;
        }
        assert (!F.isEmpty((Collection)segmentKeys)) : segmentKeys;
        int rangeId = this.res.size();
        GridH2RowMessage first = this.idx.toSearchRowMessage(firstRow);
        GridH2RowMessage last = this.idx.toSearchRowMessage(lastRow);
        GridH2RowRangeBounds rangeBounds = GridH2RowRangeBounds.rangeBounds(rangeId, first, last);
        for (int i = 0; i < segmentKeys.size(); ++i) {
            List<GridH2RowRangeBounds> bounds;
            SegmentKey segmentKey = (SegmentKey)segmentKeys.get(i);
            assert (segmentKey != null);
            RangeStream stream = this.rangeStreams.get(segmentKey);
            if (stream == null) {
                stream = new RangeStream(this.cctx.kernalContext(), this.idx, this.joinCtx, segmentKey.node());
                stream.request(DistributedLookupBatch.createRequest(this.joinCtx, this.batchLookupId, segmentKey.segmentId()));
                bounds = new ArrayList<GridH2RowRangeBounds>();
                stream.request().bounds(bounds);
                this.rangeStreams.put(segmentKey, stream);
            } else {
                bounds = stream.request().bounds();
            }
            bounds.add(rangeBounds);
            if (bounds.size() < this.joinCtx.pageSize()) continue;
            this.batchFull = true;
        }
        Object cur = segmentKeys.size() == 1 ? new UnicastCursor(rangeId, this.rangeStreams.get(F.first((List)segmentKeys))) : new BroadcastCursor(this.idx, rangeId, segmentKeys, this.rangeStreams);
        this.res.add((Future<Cursor>)new DoneFuture(cur));
        return true;
    }

    private boolean equal(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1 != ValueNull.INSTANCE && v2 != ValueNull.INSTANCE && v1.compareTypeSafe(v2, this.idx.getDatabase().getCompareMode()) == 0;
    }

    public boolean isBatchFull() {
        return this.batchFull;
    }

    private void startStreams() {
        if (this.rangeStreams.isEmpty()) {
            assert (this.res.isEmpty());
            return;
        }
        this.joinCtx.putStreams(this.batchLookupId, this.rangeStreams);
        for (RangeStream stream : this.rangeStreams.values()) {
            stream.start();
        }
    }

    public List<Future<Cursor>> find() {
        this.batchFull = false;
        this.findCalled = true;
        this.startStreams();
        return this.res;
    }

    public void reset(boolean beforeQry) {
        if (beforeQry || this.joinCtx == null) {
            return;
        }
        assert (this.batchLookupId != 0);
        this.joinCtx.putStreams(this.batchLookupId, null);
        this.joinCtx = null;
        this.batchLookupId = 0;
        this.rangeStreams = Collections.emptyMap();
        this.broadcastSegments = null;
        this.batchFull = false;
        this.findCalled = false;
        this.res = Collections.emptyList();
    }

    public String getPlanSQL() {
        return this.ucast ? "unicast" : "broadcast";
    }

    public SegmentKey rangeSegment(Object affKeyObj) {
        ClusterNode node;
        assert (affKeyObj != null && affKeyObj != EXPLICIT_NULL) : affKeyObj;
        int partition = this.cctx.affinity().partition(affKeyObj);
        if (this.joinCtx.partitionsMap() != null) {
            UUID nodeId = this.joinCtx.nodeForPartition(partition, this.cctx);
            node = this.cctx.discovery().node(nodeId);
        } else {
            node = this.cctx.affinity().primaryByKey(affKeyObj, this.joinCtx.topologyVersion());
        }
        if (node == null) {
            throw H2Utils.retryException("Failed to get primary node by key for range segment.");
        }
        return new SegmentKey(node, this.idx.segmentForPartition(partition));
    }

    public List<SegmentKey> broadcastSegments() {
        ArrayList<ClusterNode> nodes;
        Map<UUID, int[]> partMap = this.joinCtx.partitionsMap();
        if (partMap == null) {
            nodes = new ArrayList(CU.affinityNodes(this.cctx, (AffinityTopologyVersion)this.joinCtx.topologyVersion()));
        } else {
            nodes = new ArrayList<ClusterNode>(partMap.size());
            for (UUID nodeId : partMap.keySet()) {
                ClusterNode node = this.cctx.kernalContext().discovery().node(nodeId);
                if (node == null) {
                    throw H2Utils.retryException("Failed to get node by ID during broadcast [nodeId=" + nodeId + ']');
                }
                nodes.add(node);
            }
        }
        if (F.isEmpty(nodes)) {
            throw H2Utils.retryException("Failed to collect affinity nodes during broadcast [cacheName=" + this.cctx.name() + ']');
        }
        int segmentsCount = this.idx.segmentsCount();
        ArrayList<SegmentKey> res = new ArrayList<SegmentKey>(nodes.size() * segmentsCount);
        for (ClusterNode node : nodes) {
            for (int seg = 0; seg < segmentsCount; ++seg) {
                res.add(new SegmentKey(node, seg));
            }
        }
        return res;
    }

    public static GridH2IndexRangeRequest createRequest(DistributedJoinContext joinCtx, int batchLookupId, int segmentId) {
        GridH2IndexRangeRequest req = new GridH2IndexRangeRequest();
        req.originNodeId(joinCtx.originNodeId());
        req.queryId(joinCtx.queryId());
        req.originSegmentId(joinCtx.segment());
        req.segment(segmentId);
        req.batchLookupId(batchLookupId);
        return req;
    }
}

