/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.expression.aggregate.AggregateType;
import org.jetbrains.annotations.Nullable;

public class GridSqlAggregateFunction
extends GridSqlFunction {
    private static final GridSqlFunctionType[] TYPE_INDEX = new GridSqlFunctionType[]{GridSqlFunctionType.COUNT_ALL, GridSqlFunctionType.COUNT, GridSqlFunctionType.GROUP_CONCAT, GridSqlFunctionType.SUM, GridSqlFunctionType.MIN, GridSqlFunctionType.MAX, GridSqlFunctionType.AVG};
    private final boolean distinct;
    private GridSqlElement groupConcatSeparator;
    private GridSqlElement[] groupConcatOrderExpression;
    private boolean[] groupConcatOrderDesc;

    @Nullable
    private static GridSqlFunctionType mapType(AggregateType type) {
        switch (type) {
            case COUNT_ALL: {
                return GridSqlFunctionType.COUNT_ALL;
            }
            case COUNT: {
                return GridSqlFunctionType.COUNT;
            }
            case LISTAGG: {
                return GridSqlFunctionType.GROUP_CONCAT;
            }
            case SUM: {
                return GridSqlFunctionType.SUM;
            }
            case MIN: {
                return GridSqlFunctionType.MIN;
            }
            case MAX: {
                return GridSqlFunctionType.MAX;
            }
            case AVG: {
                return GridSqlFunctionType.AVG;
            }
        }
        return null;
    }

    public GridSqlAggregateFunction(boolean distinct, GridSqlFunctionType type) {
        super(type);
        this.distinct = distinct;
    }

    public GridSqlAggregateFunction(boolean distinct, AggregateType type) {
        this(distinct, GridSqlAggregateFunction.mapType(type));
    }

    public GridSqlAggregateFunction(GridSqlFunctionType type, String name, boolean distinct) {
        super(null, type, name);
        this.distinct = distinct;
    }

    protected static boolean isValidType(AggregateType type) {
        return GridSqlAggregateFunction.mapType(type) != null;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public GridSqlAggregateFunction setGroupConcatOrder(GridSqlElement[] orderExpression, boolean[] orderDesc) {
        this.groupConcatOrderExpression = orderExpression;
        this.groupConcatOrderDesc = orderDesc;
        return this;
    }

    public boolean hasGroupConcatOrder() {
        return !F.isEmpty((Object[])this.groupConcatOrderExpression);
    }

    public GridSqlAggregateFunction setGroupConcatSeparator(GridSqlElement separator) {
        this.groupConcatSeparator = separator;
        return this;
    }

    public GridSqlElement getGroupConcatSeparator() {
        return this.groupConcatSeparator;
    }

    @Override
    public String getSQL() {
        int i;
        if (this.type == GridSqlFunctionType.COUNT_ALL) {
            return "COUNT(*)";
        }
        StringBuilder buff = new StringBuilder(this.name()).append('(');
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        if (this.type == GridSqlFunctionType.UNKNOWN_FUNCTION) {
            for (i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.child(i).getSQL());
            }
        } else {
            buff.append(this.child().getSQL());
        }
        if (!F.isEmpty((Object[])this.groupConcatOrderExpression)) {
            buff.append(" ORDER BY ");
            for (i = 0; i < this.groupConcatOrderExpression.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.groupConcatOrderExpression[i].getSQL());
                if (!this.groupConcatOrderDesc[i]) continue;
                buff.append(" DESC");
            }
        }
        if (this.groupConcatSeparator != null) {
            buff.append(" SEPARATOR ").append(this.groupConcatSeparator.getSQL());
        }
        buff.append(')');
        return buff.toString();
    }
}

