/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.expression.Expression;
import org.h2.table.Column;
import org.h2.value.TypeInfo;

public final class GridSqlType {
    public static final GridSqlType UNKNOWN = new GridSqlType(-1, 0, 0L, 0, null);
    public static final GridSqlType BIGINT = new GridSqlType(5, 0, 19L, 20, "BIGINT");
    public static final GridSqlType DOUBLE = new GridSqlType(7, 0, 17L, 24, "DOUBLE");
    public static final GridSqlType UUID = new GridSqlType(20, 0, Integer.MAX_VALUE, 36, "UUID");
    public static final GridSqlType BOOLEAN = new GridSqlType(1, 0, 1L, 5, "BOOLEAN");
    public static final GridSqlType STRING = new GridSqlType(13, 0, 0L, -1, "VARCHAR");
    public static final GridSqlType RESULT_SET = new GridSqlType(18, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, "");
    private final int type;
    private final int scale;
    private final long precision;
    private final int displaySize;
    private final String sql;

    private GridSqlType(int type, int scale, long precision, int displaySize, String sql) {
        assert (!F.isEmpty((String)sql) || type == -1 || type == 18);
        this.type = type;
        this.scale = scale;
        this.precision = precision;
        this.displaySize = displaySize;
        this.sql = sql;
    }

    public static GridSqlType fromColumn(Column c) {
        TypeInfo type = c.getType();
        if (c.getName() != null) {
            c = new Column(null, type);
        }
        return new GridSqlType(type.getValueType(), type.getScale(), type.getPrecision(), type.getDisplaySize(), c.getCreateSQL());
    }

    public static GridSqlType fromExpression(Expression e) {
        if (e.getType().getValueType() == -1) {
            return UNKNOWN;
        }
        return GridSqlType.fromColumn(new Column(null, e.getType()));
    }

    public int type() {
        return this.type;
    }

    public int scale() {
        return this.scale;
    }

    public long precision() {
        return this.precision;
    }

    public int displaySize() {
        return this.displaySize;
    }

    public String sql() {
        return this.sql;
    }

    public String toString() {
        return S.toString(GridSqlType.class, (Object)this);
    }
}

