/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.h2.command.Parser;
import org.h2.util.StringUtils;

public class GridSqlUpdate
extends GridSqlStatement {
    private GridSqlElement target;
    private ArrayList<GridSqlColumn> cols;
    private LinkedHashMap<String, GridSqlElement> set;
    private GridSqlElement where;

    public GridSqlUpdate target(GridSqlElement target) {
        this.target = target;
        return this;
    }

    public GridSqlElement target() {
        return this.target;
    }

    public GridSqlUpdate cols(ArrayList<GridSqlColumn> cols) {
        this.cols = cols;
        return this;
    }

    public ArrayList<GridSqlColumn> cols() {
        return this.cols;
    }

    public GridSqlUpdate set(LinkedHashMap<String, GridSqlElement> set) {
        this.set = set;
        return this;
    }

    public GridSqlUpdate where(GridSqlElement where) {
        this.where = where;
        return this;
    }

    public GridSqlElement where() {
        return this.where;
    }

    public LinkedHashMap<String, GridSqlElement> set() {
        return this.set;
    }

    @Override
    public String getSQL() {
        StringBuilder buff = new StringBuilder(this.explain() ? "EXPLAIN " : "");
        buff.append("UPDATE ").append(this.target.getSQL()).append("\nSET\n");
        for (int i = 0; i < this.cols.size(); ++i) {
            GridSqlColumn c = this.cols.get(i);
            GridSqlElement e = this.set.get(c.columnName());
            if (i > 0) {
                buff.append(",\n    ");
            }
            buff.append(Parser.quoteIdentifier((String)c.columnName(), (boolean)true)).append(" = ").append(e != null ? e.getSQL() : "DEFAULT");
        }
        if (this.where != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose((String)this.where.getSQL()));
        }
        if (this.limit != null) {
            buff.append("\nLIMIT ").append(StringUtils.unEnclose((String)this.limit.getSQL()));
        }
        return buff.toString();
    }
}

