/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewCacheGroups
extends SqlAbstractLocalSystemView {
    public SqlSystemViewCacheGroups(GridKernalContext ctx) {
        super("CACHE_GROUPS", "Cache groups", ctx, "CACHE_GROUP_ID", SqlSystemViewCacheGroups.newColumn("CACHE_GROUP_ID", 4), SqlSystemViewCacheGroups.newColumn("CACHE_GROUP_NAME"), SqlSystemViewCacheGroups.newColumn("IS_SHARED", 1), SqlSystemViewCacheGroups.newColumn("CACHE_COUNT", 4), SqlSystemViewCacheGroups.newColumn("CACHE_MODE"), SqlSystemViewCacheGroups.newColumn("ATOMICITY_MODE"), SqlSystemViewCacheGroups.newColumn("AFFINITY"), SqlSystemViewCacheGroups.newColumn("PARTITIONS_COUNT", 4), SqlSystemViewCacheGroups.newColumn("NODE_FILTER"), SqlSystemViewCacheGroups.newColumn("DATA_REGION_NAME"), SqlSystemViewCacheGroups.newColumn("TOPOLOGY_VALIDATOR"), SqlSystemViewCacheGroups.newColumn("PARTITION_LOSS_POLICY"), SqlSystemViewCacheGroups.newColumn("REBALANCE_MODE"), SqlSystemViewCacheGroups.newColumn("REBALANCE_DELAY", 5), SqlSystemViewCacheGroups.newColumn("REBALANCE_ORDER", 4), SqlSystemViewCacheGroups.newColumn("BACKUPS", 4));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Collection<Object> cacheGroups;
        SqlSystemViewColumnCondition idCond = this.conditionForColumn("ID", first, last);
        if (idCond.isEquality()) {
            try {
                CacheGroupDescriptor cacheGrp = (CacheGroupDescriptor)this.ctx.cache().cacheGroupDescriptors().get(idCond.valueForEquality().getInt());
                cacheGroups = cacheGrp == null ? Collections.emptySet() : Collections.singleton(cacheGrp);
            }
            catch (Exception ignore) {
                cacheGroups = Collections.emptySet();
            }
        } else {
            cacheGroups = this.ctx.cache().cacheGroupDescriptors().values();
        }
        return F.iterator(cacheGroups, (IgniteClosure & Serializable)grp -> {
            CacheConfiguration ccfg = grp.config();
            return this.createRow(ses, grp.groupId(), grp.cacheOrGroupName(), grp.sharedGroup(), grp.caches() == null ? 0 : grp.caches().size(), ccfg.getCacheMode(), ccfg.getAtomicityMode(), SqlSystemViewCacheGroups.toStringSafe(ccfg.getAffinity()), ccfg.getAffinity() != null ? Integer.valueOf(ccfg.getAffinity().partitions()) : null, SqlSystemViewCacheGroups.nodeFilter(ccfg), ccfg.getDataRegionName(), SqlSystemViewCacheGroups.toStringSafe(ccfg.getTopologyValidator()), ccfg.getPartitionLossPolicy(), ccfg.getRebalanceMode(), ccfg.getRebalanceDelay(), ccfg.getRebalanceOrder(), ccfg.getCacheMode() == CacheMode.REPLICATED ? null : Integer.valueOf(ccfg.getBackups()));
        }, (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.cache().cacheGroupDescriptors().size();
    }
}

