/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.database.IndexInformation;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewIndexes
extends SqlAbstractLocalSystemView {
    private final SchemaManager schemaMgr;

    public SqlSystemViewIndexes(GridKernalContext ctx, SchemaManager schemaMgr) {
        super("INDEXES", "Ignite SQL indexes", ctx, "TABLE_NAME", SqlSystemViewIndexes.newColumn("CACHE_GROUP_ID", 4), SqlSystemViewIndexes.newColumn("CACHE_GROUP_NAME"), SqlSystemViewIndexes.newColumn("CACHE_ID", 4), SqlSystemViewIndexes.newColumn("CACHE_NAME"), SqlSystemViewIndexes.newColumn("SCHEMA_NAME"), SqlSystemViewIndexes.newColumn("TABLE_NAME"), SqlSystemViewIndexes.newColumn("INDEX_NAME"), SqlSystemViewIndexes.newColumn("INDEX_TYPE"), SqlSystemViewIndexes.newColumn("COLUMNS"), SqlSystemViewIndexes.newColumn("IS_PK", 1), SqlSystemViewIndexes.newColumn("IS_UNIQUE", 1), SqlSystemViewIndexes.newColumn("INLINE_SIZE", 4));
        this.schemaMgr = schemaMgr;
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Predicate<GridH2Table> filter;
        SqlSystemViewColumnCondition tblNameCond = this.conditionForColumn("TABLE_NAME", first, last);
        if (tblNameCond.isEquality()) {
            String tblName = tblNameCond.valueForEquality().getString();
            filter = tbl -> tblName.equals(tbl.getName());
        } else {
            filter = tbl -> true;
        }
        ArrayList rows = new ArrayList();
        this.schemaMgr.dataTables().stream().filter(filter).forEach(tbl -> {
            String schema = tbl.getSchema().getName();
            String tblName = tbl.getName();
            int cacheGrpId = tbl.cacheInfo().groupId();
            CacheGroupDescriptor cacheGrpDesc = (CacheGroupDescriptor)this.ctx.cache().cacheGroupDescriptors().get(cacheGrpId);
            if (cacheGrpDesc == null) {
                return;
            }
            String cacheGrpName = cacheGrpDesc.cacheOrGroupName();
            int cacheId = tbl.cacheId();
            String cacheName = tbl.cacheName();
            List<IndexInformation> idxInfoList = tbl.indexesInformation();
            for (IndexInformation idxInfo : idxInfoList) {
                Object[] data = new Object[]{cacheGrpId, cacheGrpName, cacheId, cacheName, schema, tblName, idxInfo.name(), idxInfo.type(), idxInfo.keySql(), idxInfo.pk(), idxInfo.unique(), idxInfo.inlineSize()};
                rows.add(this.createRow(ses, data));
            }
        });
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.schemaMgr.dataTables().stream().mapToInt(t -> t.indexesInformation().size()).sum();
    }
}

