/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewQueryHistoryMetrics
extends SqlAbstractLocalSystemView {
    public SqlSystemViewQueryHistoryMetrics(GridKernalContext ctx) {
        super("LOCAL_SQL_QUERY_HISTORY", "Ignite SQL query history metrics", ctx, SqlSystemViewQueryHistoryMetrics.newColumn("SCHEMA_NAME"), SqlSystemViewQueryHistoryMetrics.newColumn("SQL"), SqlSystemViewQueryHistoryMetrics.newColumn("LOCAL", 1), SqlSystemViewQueryHistoryMetrics.newColumn("EXECUTIONS", 5), SqlSystemViewQueryHistoryMetrics.newColumn("FAILURES", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DURATION_MIN", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DURATION_MAX", 5), SqlSystemViewQueryHistoryMetrics.newColumn("LAST_START_TIME", 11), SqlSystemViewQueryHistoryMetrics.newColumn("MEMORY_MIN", 5), SqlSystemViewQueryHistoryMetrics.newColumn("MEMORY_MAX", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DISK_ALLOCATION_MIN", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DISK_ALLOCATION_MAX", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DISK_ALLOCATION_TOTAL_MIN", 5), SqlSystemViewQueryHistoryMetrics.newColumn("DISK_ALLOCATION_TOTAL_MAX", 5));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        this.ctx.security().authorize(SecurityPermission.GET_QUERY_VIEWS);
        Map qryHistMetrics = ((IgniteH2Indexing)this.ctx.query().getIndexing()).runningQueryManager().queryHistoryMetrics();
        ArrayList rows = new ArrayList();
        qryHistMetrics.values().forEach(m -> {
            Object[] data = new Object[]{m.schema(), m.query(), m.local(), m.executions(), m.failures(), m.minimumTime(), m.maximumTime(), SqlSystemViewQueryHistoryMetrics.valueTimestampFromMillis(m.lastStartTime()), m.minMemory(), m.maxMemory(), m.minBytesAllocatedOnDisk(), m.maxBytesAllocatedOnDisk(), m.minTotalBytesWrittenOnDisk(), m.maxTotalBytesWrittenOnDisk()};
            rows.add(this.createRow(ses, data));
        });
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return ((IgniteH2Indexing)this.ctx.query().getIndexing()).runningQueryManager().queryHistoryMetrics().size();
    }
}

