/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueCollectionBase;

public class GridH2Array
extends GridH2ValueMessage {
    @GridDirectCollection(value=Message.class)
    private Collection<Message> x;

    public GridH2Array() {
    }

    public GridH2Array(Value val) throws IgniteCheckedException {
        assert (val.getValueType() == 17 || val.getValueType() == 39) : val.getType();
        ValueCollectionBase col = (ValueCollectionBase)val;
        this.x = new ArrayList<Message>(col.getList().length);
        for (Value v : col.getList()) {
            this.x.add(GridH2ValueMessageFactory.toMessage(v));
        }
    }

    @Override
    public Value value(GridKernalContext ctx) throws IgniteCheckedException {
        return ValueArray.get((Value[])GridH2ValueMessageFactory.fillArray(this.x.iterator(), new Value[this.x.size()], ctx));
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("x", this.x, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.x = reader.readCollection("x", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Array.class);
    }

    public short directType() {
        return -18;
    }

    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return String.valueOf(this.x);
    }
}

