/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableContainingInOrder<E>
extends TypeSafeDiagnosingMatcher<Iterable<E>> {
    private final List<Matcher<? super E>> matchers;

    public IsIterableContainingInOrder(List<Matcher<? super E>> matchers) {
        this.matchers = matchers;
    }

    protected boolean matchesSafely(Iterable<E> iterable, Description mismatchDescription) {
        MatchSeries<E> matchSeries = new MatchSeries<E>(this.matchers, mismatchDescription);
        for (E item : iterable) {
            if (matchSeries.matches(item)) continue;
            return false;
        }
        return matchSeries.isFinished();
    }

    public void describeTo(Description description) {
        description.appendText("iterable over ").appendList("[", ", ", "]", this.matchers);
    }

    @Factory
    public static <E> Matcher<Iterable<E>> contains(E ... items) {
        ArrayList<Matcher<Matcher>> matchers = new ArrayList<Matcher<Matcher>>();
        for (E item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return IsIterableContainingInOrder.contains(matchers);
    }

    @Factory
    public static <E> Matcher<Iterable<E>> contains(final Matcher<E> item) {
        return IsIterableContainingInOrder.contains(new ArrayList<Matcher<? super E>>(){
            {
                this.add(item);
            }
        });
    }

    @Factory
    public static <E> Matcher<Iterable<E>> contains(Matcher<? super E> ... items) {
        return IsIterableContainingInOrder.contains(Arrays.asList(items));
    }

    @Factory
    public static <E> Matcher<Iterable<E>> contains(List<Matcher<? super E>> contents) {
        return new IsIterableContainingInOrder<E>(contents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchSeries<F> {
        public final List<Matcher<? super F>> matchers;
        private final Description mismatchDescription;
        public int nextMatchIx = 0;

        public MatchSeries(List<Matcher<? super F>> matchers, Description mismatchDescription) {
            this.mismatchDescription = mismatchDescription;
            if (matchers.isEmpty()) {
                throw new IllegalArgumentException("Should specify at least one expected element");
            }
            this.matchers = matchers;
        }

        public boolean matches(F item) {
            return this.isNotSurplus(item) && this.isMatched(item);
        }

        public boolean isFinished() {
            if (this.nextMatchIx < this.matchers.size()) {
                this.mismatchDescription.appendText("No item matched: ").appendDescriptionOf((SelfDescribing)this.matchers.get(this.nextMatchIx));
                return false;
            }
            return true;
        }

        private boolean isMatched(F item) {
            Matcher<? super F> matcher = this.matchers.get(this.nextMatchIx);
            if (!matcher.matches(item)) {
                this.describeMismatch(matcher, item);
                return false;
            }
            ++this.nextMatchIx;
            return true;
        }

        private boolean isNotSurplus(F item) {
            if (this.matchers.size() <= this.nextMatchIx) {
                this.mismatchDescription.appendText("Not matched: ").appendValue(item);
                return false;
            }
            return true;
        }

        private void describeMismatch(Matcher<? super F> matcher, F item) {
            this.mismatchDescription.appendText("item " + this.nextMatchIx + ": ");
            matcher.describeMismatch(item, this.mismatchDescription);
        }
    }
}

