/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.SynonymFilter;
import org.apache.solr.analysis.SynonymMap;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private SynonymMap synMap;

    @Override
    public void inform(ResourceLoader loader) {
        String synonyms = (String)this.args.get("synonyms");
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        boolean expand = this.getBoolean("expand", true);
        String tf = (String)this.args.get("tokenizerFactory");
        TokenizerFactory tokFactory = null;
        if (tf != null) {
            tokFactory = SynonymFilterFactory.loadTokenizerFactory(loader, tf, this.args);
        }
        if (synonyms != null) {
            List<String> wlist = null;
            try {
                File synonymFile = new File(synonyms);
                if (synonymFile.exists()) {
                    wlist = loader.getLines(synonyms);
                } else {
                    List<String> files = StrUtils.splitFileNames(synonyms);
                    wlist = new ArrayList<String>();
                    for (String file : files) {
                        List<String> lines = loader.getLines(file.trim());
                        wlist.addAll(lines);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.synMap = new SynonymMap(ignoreCase);
            SynonymFilterFactory.parseRules(wlist, this.synMap, "=>", ",", expand, tokFactory);
        }
    }

    static void parseRules(List<String> rules, SynonymMap map, String mappingSep, String synSep, boolean expansion, TokenizerFactory tokFactory) {
        int count = 0;
        for (String rule : rules) {
            List<List<String>> target;
            List<List<String>> source;
            List<String> mapping = StrUtils.splitSmart(rule, mappingSep, false);
            if (mapping.size() > 2) {
                throw new RuntimeException("Invalid Synonym Rule:" + rule);
            }
            if (mapping.size() == 2) {
                source = SynonymFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                target = SynonymFilterFactory.getSynList(mapping.get(1), synSep, tokFactory);
            } else {
                source = SynonymFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                if (expansion) {
                    target = source;
                } else {
                    target = new ArrayList<List<String>>(1);
                    target.add(source.get(0));
                }
            }
            boolean includeOrig = false;
            for (List<String> fromToks : source) {
                ++count;
                for (List<String> toToks : target) {
                    map.add(fromToks, SynonymMap.makeTokens(toToks), includeOrig, true);
                }
            }
        }
    }

    private static List<List<String>> getSynList(String str, String separator, TokenizerFactory tokFactory) {
        List<String> strList = StrUtils.splitSmart(str, separator, false);
        ArrayList<List<String>> synList = new ArrayList<List<String>>();
        for (String toks : strList) {
            List<String> tokList = tokFactory == null ? StrUtils.splitWS(toks, true) : SynonymFilterFactory.splitByTokenizer(toks, tokFactory);
            synList.add(tokList);
        }
        return synList;
    }

    private static List<String> splitByTokenizer(String source, TokenizerFactory tokFactory) {
        StringReader reader = new StringReader(source);
        TokenStream ts = SynonymFilterFactory.loadTokenizer(tokFactory, reader);
        ArrayList<String> tokList = new ArrayList<String>();
        try {
            TermAttribute termAtt = (TermAttribute)ts.addAttribute(TermAttribute.class);
            while (ts.incrementToken()) {
                if (termAtt.termLength() <= 0) continue;
                tokList.add(termAtt.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            reader.close();
        }
        return tokList;
    }

    private static TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname, Map<String, String> args) {
        TokenizerFactory tokFactory = (TokenizerFactory)loader.newInstance(cname, new String[0]);
        tokFactory.init(args);
        return tokFactory;
    }

    private static TokenStream loadTokenizer(TokenizerFactory tokFactory, Reader reader) {
        return tokFactory.create(reader);
    }

    public SynonymMap getSynonymMap() {
        return this.synMap;
    }

    public SynonymFilter create(TokenStream input) {
        return new SynonymFilter(input, this.synMap);
    }
}

