/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.lucene.Changeset;
import org.hibernate.search.backend.impl.lucene.ChangesetList;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1769")
public class ChangeSetIteratorTest {
    @Test
    public void testOutherIteratorBeingEmpty() {
        ChangesetList list = new ChangesetList(new ArrayList(2));
        Iterator iterator = list.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testOutherIteratorBeingEmptyException() {
        ChangesetList list = new ChangesetList(new ArrayList(2));
        Iterator iterator = list.iterator();
        try {
            iterator.next();
            Assert.fail((String)"Should have thrown the exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testInnerIteratorBeingEmpty() {
        ArrayList<Changeset> outher = new ArrayList<Changeset>(2);
        outher.add(new Changeset(new ArrayList(2), null, null));
        outher.add(new Changeset(new ArrayList(2), null, null));
        ChangesetList list = new ChangesetList(outher);
        Iterator iterator = list.iterator();
        Assert.assertFalse((String)"Iterator should have been empty", (boolean)iterator.hasNext());
    }

    @Test
    public void testInnerIteratorBeingEmptyException() {
        ArrayList<Changeset> outher = new ArrayList<Changeset>(2);
        outher.add(new Changeset(new ArrayList(2), null, null));
        outher.add(new Changeset(new ArrayList(2), null, null));
        ChangesetList list = new ChangesetList(outher);
        Iterator iterator = list.iterator();
        try {
            iterator.next();
            Assert.fail((String)"Should have thrown the exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testInnerIteratorSingleEmpty() {
        ArrayList<PurgeAllLuceneWork> workListOne = new ArrayList<PurgeAllLuceneWork>(2);
        workListOne.add(new PurgeAllLuceneWork(Object.class));
        ArrayList<Changeset> outher = new ArrayList<Changeset>(2);
        outher.add(new Changeset(workListOne, null, null));
        ChangesetList list = new ChangesetList(outher);
        Iterator iterator = list.iterator();
        Assert.assertTrue((String)"Iterator should contain some elements", (boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof PurgeAllLuceneWork));
    }

    @Test
    public void testFourElementsIterator() {
        ArrayList<Object> workListOne = new ArrayList<Object>(2);
        workListOne.add(new PurgeAllLuceneWork(Object.class));
        workListOne.add(new AddLuceneWork(null, null, null, null));
        ArrayList<Object> workListTwo = new ArrayList<Object>(2);
        workListTwo.add(new OptimizeLuceneWork(Object.class));
        workListTwo.add(new UpdateLuceneWork(null, null, null, null));
        ArrayList<Changeset> outher = new ArrayList<Changeset>(2);
        outher.add(new Changeset(workListOne, null, null));
        outher.add(new Changeset(workListTwo, null, null));
        ChangesetList list = new ChangesetList(outher);
        Iterator iterator = list.iterator();
        Assert.assertTrue((String)"Iterator should contain some elements", (boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof PurgeAllLuceneWork));
        iterator.hasNext();
        Assert.assertTrue((boolean)(iterator.next() instanceof AddLuceneWork));
        iterator.hasNext();
        Assert.assertTrue((boolean)(iterator.next() instanceof OptimizeLuceneWork));
        iterator.hasNext();
        Assert.assertTrue((boolean)(iterator.next() instanceof UpdateLuceneWork));
    }
}

