/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1824")
public class DefinitionsOnHotRebootTest {
    @Test
    public void notForgettingDefinedFilters() {
        SearchIntegratorBuilder emptySearchBuilder = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest());
        try (SearchIntegrator sf = emptySearchBuilder.buildSearchIntegrator();){
            Assert.assertEquals((long)0L, (long)this.countFilters(sf));
            sf.addClasses(new Class[]{A.class});
            Assert.assertEquals((long)1L, (long)this.countFilters(sf));
            Assert.assertTrue((boolean)this.filterExists(sf, "anyFilter"));
            sf.addClasses(new Class[]{B.class});
            Assert.assertEquals((long)2L, (long)this.countFilters(sf));
            Assert.assertTrue((boolean)this.filterExists(sf, "anyFilter"));
            Assert.assertTrue((boolean)this.filterExists(sf, "anotherFilter"));
        }
    }

    @Test
    public void notForgettingDefinedAnalyzers() {
        SearchIntegratorBuilder emptySearchBuilder = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest());
        try (SearchIntegrator sf = emptySearchBuilder.buildSearchIntegrator();){
            Assert.assertEquals((long)0L, (long)this.countAnalyzers(sf));
            sf.addClasses(new Class[]{A.class});
            Assert.assertEquals((long)1L, (long)this.countAnalyzers(sf));
            Assert.assertTrue((boolean)this.analyzerExists(sf, "anAnalyzer"));
            sf.addClasses(new Class[]{B.class});
            Assert.assertEquals((long)2L, (long)this.countAnalyzers(sf));
            Assert.assertTrue((boolean)this.analyzerExists(sf, "anAnalyzer"));
            Assert.assertTrue((boolean)this.analyzerExists(sf, "anotherAnalyzer"));
        }
    }

    private boolean analyzerExists(SearchIntegrator sf, String analyzerName) {
        Analyzer analyzer = (Analyzer)((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getAnalyzers().get(analyzerName);
        return analyzer != null;
    }

    private int countAnalyzers(SearchIntegrator sf) {
        return ((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getAnalyzers().size();
    }

    private boolean filterExists(SearchIntegrator sf, String filterName) {
        FilterDef filterDef = (FilterDef)((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getFilterDefinitions().get(filterName);
        return filterDef != null;
    }

    private int countFilters(SearchIntegrator sf) {
        return ((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getFilterDefinitions().size();
    }

    @Indexed
    @FullTextFilterDef(name="anotherFilter", impl=ShardSensitiveOnlyFilter.class)
    @AnalyzerDef(name="anotherAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class B {
        @DocumentId
        Long id;

        B() {
        }
    }

    @Indexed
    @FullTextFilterDef(name="anyFilter", impl=ShardSensitiveOnlyFilter.class)
    @AnalyzerDef(name="anAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class A {
        @DocumentId
        Long id;

        A() {
        }
    }
}

