/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.CollectionRegionImpl;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.hibernate.testing.cache.NaturalIdRegionImpl;
import org.hibernate.testing.cache.Timestamper;
import org.jboss.logging.Logger;

public class CachingRegionFactory
implements RegionFactory {
    private static final Logger LOG = Logger.getLogger((String)CachingRegionFactory.class.getName());
    public static String DEFAULT_ACCESSTYPE = "DefaultAccessType";
    private SessionFactoryOptions settings;
    private Properties properties;

    public CachingRegionFactory() {
        LOG.warn((Object)"CachingRegionFactory should be only used for testing.");
    }

    public CachingRegionFactory(Properties properties) {
        LOG.warn((Object)"CachingRegionFactory should be only used for testing.");
        this.properties = properties;
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        this.settings = settings;
        this.properties = properties;
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        if (this.properties != null && this.properties.get(DEFAULT_ACCESSTYPE) != null) {
            return AccessType.fromExternalName((String)this.properties.getProperty(DEFAULT_ACCESSTYPE));
        }
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionImpl(regionName, metadata, this.settings);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new NaturalIdRegionImpl(regionName, metadata, this.settings);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionImpl(regionName, metadata, this.settings);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionImpl(regionName);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionImpl(regionName);
    }

    private static class TimestampsRegionImpl
    extends BaseGeneralDataRegion
    implements TimestampsRegion {
        TimestampsRegionImpl(String name) {
            super(name);
        }
    }

    private static class QueryResultsRegionImpl
    extends BaseGeneralDataRegion
    implements QueryResultsRegion {
        QueryResultsRegionImpl(String name) {
            super(name);
        }
    }
}

