/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.logger.Triggerable;
import org.jboss.logging.Logger;

final class TriggerOnPrefixLogListener
implements LogListener,
Triggerable {
    private final String expectedPrefix;
    private final AtomicBoolean triggered = new AtomicBoolean(false);

    public TriggerOnPrefixLogListener(String expectedPrefix) {
        this.expectedPrefix = expectedPrefix;
    }

    @Override
    public void loggedEvent(Logger.Level level, String renderedMessage, Throwable thrown) {
        if (renderedMessage != null && renderedMessage.startsWith(this.expectedPrefix)) {
            this.triggered.set(true);
        }
    }

    @Override
    public boolean wasTriggered() {
        return this.triggered.get();
    }

    @Override
    public void reset() {
        this.triggered.set(false);
    }
}

