/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Properties;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.TypeSpecification;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.Type;

public final class BasicMetadataGenerator {
    public boolean addBasic(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        if (value.getType() instanceof BasicType) {
            if (attributeContainer != null) {
                BasicAttribute attribute = this.buildProperty(propertyAuditingData, value, insertable, key);
                attributeContainer.addAttribute(attribute);
                if (this.isAddNestedType(value)) {
                    this.applyNestedType((SimpleValue)value, attribute);
                }
            }
            if (mapper != null) {
                propertyAuditingData.setPropertyType(value.getType());
                mapper.add(propertyAuditingData.resolvePropertyData());
            }
            return true;
        }
        return false;
    }

    private void mapEnumerationType(TypeSpecification typeDefinition, EnumType type, Properties parameters) {
        if (parameters.getProperty("enumClass") != null) {
            typeDefinition.setParameter("enumClass", parameters.getProperty("enumClass"));
        } else {
            typeDefinition.setParameter("enumClass", type.getEnumClass().getName());
        }
        if (parameters.getProperty("useNamed") != null) {
            typeDefinition.setParameter("useNamed", parameters.getProperty("useNamed"));
        } else {
            typeDefinition.setParameter("useNamed", Boolean.toString(!type.isOrdinal()));
        }
    }

    private boolean isAddNestedType(Value value) {
        if (value instanceof SimpleValue) {
            return ((SimpleValue)value).getTypeParameters() != null;
        }
        return false;
    }

    private BasicAttribute buildProperty(PropertyAuditingData propertyAuditingData, Value value, boolean insertable, boolean key) {
        BasicAttribute attribute = new BasicAttribute(propertyAuditingData.getName(), this.isAddNestedType(value) ? null : this.getBasicTypeName(value.getType()), propertyAuditingData.isForceInsertable() || insertable, key);
        attribute.addColumnsFromValue(value);
        return attribute;
    }

    private void applyNestedType(SimpleValue value, BasicAttribute attribute) {
        Properties typeParameters = value.getTypeParameters();
        String typeName = this.getBasicTypeName(value.getType());
        TypeSpecification typeSpecification = new TypeSpecification(typeName);
        attribute.setType(typeSpecification);
        Type type = value.getType();
        if (type instanceof CustomType && ((CustomType)type).getUserType() instanceof EnumType) {
            this.mapEnumerationType(typeSpecification, (EnumType)((CustomType)type).getUserType(), typeParameters);
        } else {
            for (Object object : typeParameters.keySet()) {
                String keyType = (String)object;
                String property = typeParameters.getProperty(keyType);
                if (property == null) continue;
                typeSpecification.setParameter(keyType, property);
            }
        }
    }

    private String getBasicTypeName(Type type) {
        String typeName = type.getName();
        if (typeName == null) {
            typeName = type.getClass().getName();
        }
        return typeName;
    }
}

