/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.criteria.JoinType;
import java.util.List;
import java.util.Set;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditAssociationQuery;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.internal.impl.EntitiesAtRevisionAssociationQuery;
import org.hibernate.query.Query;

public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;
    private final boolean includeDeletions;

    public EntitiesAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, Number revision, boolean includeDeletions) {
        super(enversService, versionsReader, cls);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    public EntitiesAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision, boolean includeDeletions) {
        super(enversService, versionsReader, cls, entityName);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    @Override
    public List list() {
        Configuration configuration = this.enversService.getConfig();
        String revisionPropertyPath = configuration.getRevisionNumberPath();
        String originalIdPropertyName = configuration.getOriginalIdPropertyName();
        MiddleIdData referencedIdData = new MiddleIdData(configuration, this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMappingData(), null, this.entityName, this.enversService.getEntitiesConfigurations().isVersioned(this.entityName));
        this.enversService.getAuditStrategy().addEntityAtRevisionRestriction(configuration, this.qb, this.qb.getRootParameters(), revisionPropertyPath, configuration.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        if (configuration.isFindByRevisionExactMatch()) {
            this.qb.getRootParameters().addWhereWithNamedParam(revisionPropertyPath, "=", "revision");
        }
        if (!this.includeDeletions) {
            this.qb.getRootParameters().addWhereWithParam(configuration.getRevisionTypePropertyName(), "<>", (Object)RevisionType.DEL);
        }
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, "e__", this.qb, this.qb.getRootParameters());
        }
        for (AbstractAuditAssociationQuery associationQuery : this.associationQueries) {
            associationQuery.addCriterionToQuery(this.versionsReader);
        }
        Query query = this.buildQuery();
        Set params = query.getParameterMetadata().getNamedParameterNames();
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        return this.applyProjections(queryResult, this.revision);
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType, String alias, AuditCriterion onClauseCriterion) {
        EntitiesAtRevisionAssociationQuery<AuditQueryImplementor> query = (EntitiesAtRevisionAssociationQuery<AuditQueryImplementor>)this.associationQueryMap.get(associationName);
        if (query == null) {
            query = new EntitiesAtRevisionAssociationQuery<AuditQueryImplementor>(this.enversService, this.versionsReader, this, this.qb, associationName, joinType, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, "e__", alias, onClauseCriterion);
            this.addAssociationQuery(associationName, query);
        }
        return query;
    }
}

