/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref, @UnknownKeyFor @NonNull @Initialized String message) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument: " + message;
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] arr) {
        return NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] arr, @UnknownKeyFor @NonNull @Initialized String message) {
        return NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr, @UnknownKeyFor @NonNull @Initialized String message) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr, @UnknownKeyFor @NonNull @Initialized String message) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr, @UnknownKeyFor @NonNull @Initialized String message) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] castNonNullDeep(T @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] @Nullable @UnknownKeyFor @Initialized [] arr, @UnknownKeyFor @NonNull @Initialized String message) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    private static <T> @NonNull T @NonNull @UnknownKeyFor @Initialized [] castNonNullArray(T @Nullable @UnknownKeyFor @Initialized [] arr, @Nullable @UnknownKeyFor @Initialized String message) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument" + (String)(message == null ? "" : ": " + message);
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element" + (String)(message == null ? "" : ": " + message);
            NullnessUtil.checkIfArray(arr[i], message);
        }
        return arr;
    }

    private static void checkIfArray(@NonNull @UnknownKeyFor @Initialized Object ref, @Nullable @UnknownKeyFor @Initialized String message) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument" + (String)(message == null ? "" : ": " + message);
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref, message);
        }
    }
}

