/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.BitSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.hql.internal.StandardHqlTranslator;

class ErrorHandler
implements Validation.Handler {
    private final @UnknownKeyFor @NonNull @Initialized Element element;
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror;
    private final @UnknownKeyFor @NonNull @Initialized AnnotationValue value;
    private final @UnknownKeyFor @NonNull @Initialized String queryString;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private @UnknownKeyFor @NonNull @Initialized int errorCount;

    public ErrorHandler(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql) {
        this.element = element;
        this.mirror = mirror;
        this.value = value;
        this.queryString = hql;
        this.context = context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void error(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
        ++this.errorCount;
        this.context.message(this.element, this.mirror, this.value, message, Diagnostic.Kind.ERROR);
    }

    @Override
    public void warn(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
        this.context.message(this.element, this.mirror, this.value, message, Diagnostic.Kind.WARNING);
    }

    public void syntaxError(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Recognizer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> recognizer, @UnknownKeyFor @NonNull @Initialized Object offendingSymbol, @UnknownKeyFor @NonNull @Initialized int line, @UnknownKeyFor @NonNull @Initialized int charPositionInLine, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized RecognitionException e) {
        ++this.errorCount;
        String prettyMessage = "illegal HQL syntax - " + StandardHqlTranslator.prettifyAntlrError((Object)offendingSymbol, (int)line, (int)charPositionInLine, (String)message, (RecognitionException)e, (String)this.queryString, (boolean)false);
        this.context.message(this.element, this.mirror, this.value, prettyMessage, Diagnostic.Kind.ERROR);
    }

    public void reportAmbiguity(@UnknownKeyFor @NonNull @Initialized Parser recognizer, @UnknownKeyFor @NonNull @Initialized DFA dfa, @UnknownKeyFor @NonNull @Initialized int startIndex, @UnknownKeyFor @NonNull @Initialized int stopIndex, @UnknownKeyFor @NonNull @Initialized boolean exact, @UnknownKeyFor @NonNull @Initialized BitSet ambigAlts, @UnknownKeyFor @NonNull @Initialized ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(@UnknownKeyFor @NonNull @Initialized Parser recognizer, @UnknownKeyFor @NonNull @Initialized DFA dfa, @UnknownKeyFor @NonNull @Initialized int startIndex, @UnknownKeyFor @NonNull @Initialized int stopIndex, @UnknownKeyFor @NonNull @Initialized BitSet conflictingAlts, @UnknownKeyFor @NonNull @Initialized ATNConfigSet configs) {
    }

    public void reportContextSensitivity(@UnknownKeyFor @NonNull @Initialized Parser recognizer, @UnknownKeyFor @NonNull @Initialized DFA dfa, @UnknownKeyFor @NonNull @Initialized int startIndex, @UnknownKeyFor @NonNull @Initialized int stopIndex, @UnknownKeyFor @NonNull @Initialized int prediction, @UnknownKeyFor @NonNull @Initialized ATNConfigSet configs) {
    }
}

