/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import jakarta.persistence.AccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessTypeInformation;

public final class Context {
    private static final String DEFAULT_PERSISTENCE_XML_LOCATION = "/META-INF/persistence.xml";
    private final Map<String, Metamodel> metaEntities = new HashMap<String, Metamodel>();
    private final Map<String, Metamodel> metaEmbeddables = new HashMap<String, Metamodel>();
    private final Map<String, Metamodel> dataMetaEntities = new HashMap<String, Metamodel>();
    private final Map<String, Metamodel> dataMetaEmbeddables = new HashMap<String, Metamodel>();
    private final Map<String, Metamodel> metaAuxiliaries = new HashMap<String, Metamodel>();
    private final Map<String, AccessTypeInformation> accessTypeInformation = new HashMap<String, AccessTypeInformation>();
    private final Set<CharSequence> elementsToRedo = new HashSet<CharSequence>();
    private final ProcessingEnvironment processingEnvironment;
    private final boolean logDebug;
    private final boolean lazyXmlParsing;
    private final String persistenceXmlLocation;
    private final List<String> ormXmlFiles;
    private Boolean fullyXmlConfigured;
    private boolean addInjectAnnotation = false;
    private boolean addDependentAnnotation = false;
    private boolean addComponentAnnotation = false;
    private boolean addNonnullAnnotation = false;
    private boolean addGeneratedAnnotation = true;
    private boolean addGenerationDate;
    private String[] suppressedWarnings;
    private boolean addTransactionScopedAnnotation;
    private AccessType persistenceUnitDefaultAccessType;
    private boolean generateJakartaDataStaticMetamodel;
    private boolean quarkusInjection;
    private boolean springInjection;
    private boolean dataEventPackageAvailable;
    private final Set<Metamodel> generatedModelClasses = new HashSet<Metamodel>();
    private final Set<String> checkedNamedQueries = new HashSet<String>();
    private boolean usesQuarkusOrm = false;
    private boolean usesQuarkusReactive = false;
    private boolean usesQuarkusPanache2 = false;
    private boolean usesQuarkusReactiveCommon = false;
    private String[] includes = new String[]{"*"};
    private String[] excludes = new String[0];
    private boolean indexing = true;
    private final Map<String, String> entityNameMappings = new HashMap<String, String>();
    private final Map<String, Set<String>> enumTypesByValue = new HashMap<String, Set<String>>();

    /*
     * WARNING - void declaration
     */
    public Context(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        Map<String, String> options = processingEnvironment.getOptions();
        Object persistenceXmlOption = options.get("persistenceXml");
        if (persistenceXmlOption != null) {
            if (!((String)persistenceXmlOption).startsWith("/")) {
                persistenceXmlOption = "/" + (String)persistenceXmlOption;
            }
            this.persistenceXmlLocation = persistenceXmlOption;
        } else {
            this.persistenceXmlLocation = DEFAULT_PERSISTENCE_XML_LOCATION;
        }
        String ormXmlOption = options.get("ormXml");
        if (ormXmlOption != null) {
            this.ormXmlFiles = new ArrayList<String>();
            for (String string : ormXmlOption.split(",\\s*")) {
                void var8_8;
                if (!string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                this.ormXmlFiles.add((String)var8_8);
            }
        } else {
            this.ormXmlFiles = Collections.emptyList();
        }
        this.lazyXmlParsing = Boolean.parseBoolean(options.get("lazyXmlParsing"));
        this.logDebug = Boolean.parseBoolean(options.get("debug"));
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public boolean generateJakartaDataStaticMetamodel() {
        return this.generateJakartaDataStaticMetamodel;
    }

    public void setGenerateJakartaDataStaticMetamodel(boolean generateJakartaDataStaticMetamodel) {
        this.generateJakartaDataStaticMetamodel = generateJakartaDataStaticMetamodel;
    }

    public boolean addInjectAnnotation() {
        return this.addInjectAnnotation;
    }

    public void setAddInjectAnnotation(boolean addInjectAnnotation) {
        this.addInjectAnnotation = addInjectAnnotation;
    }

    public boolean addDependentAnnotation() {
        return this.addDependentAnnotation;
    }

    public void setAddDependentAnnotation(boolean addDependentAnnotation) {
        this.addDependentAnnotation = addDependentAnnotation;
    }

    public boolean addComponentAnnotation() {
        return this.addComponentAnnotation;
    }

    public void setAddComponentAnnotation(boolean addComponentAnnotation) {
        this.addComponentAnnotation = addComponentAnnotation;
    }

    public boolean addNonnullAnnotation() {
        return this.addNonnullAnnotation;
    }

    public void setAddNonnullAnnotation(boolean addNonnullAnnotation) {
        this.addNonnullAnnotation = addNonnullAnnotation;
    }

    public boolean addGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public void setAddGeneratedAnnotation(boolean addGeneratedAnnotation) {
        this.addGeneratedAnnotation = addGeneratedAnnotation;
    }

    public boolean addGeneratedDate() {
        return this.addGenerationDate;
    }

    public void setAddGenerationDate(boolean addGenerationDate) {
        this.addGenerationDate = addGenerationDate;
    }

    public boolean addSuppressWarningsAnnotation() {
        return this.suppressedWarnings != null;
    }

    public String[] getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    public void setSuppressedWarnings(String[] suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }

    public boolean addTransactionScopedAnnotation() {
        return this.addTransactionScopedAnnotation;
    }

    public void setAddTransactionScopedAnnotation(boolean addTransactionScopedAnnotation) {
        this.addTransactionScopedAnnotation = addTransactionScopedAnnotation;
    }

    public boolean isQuarkusInjection() {
        return this.quarkusInjection;
    }

    public void setQuarkusInjection(boolean quarkusInjection) {
        this.quarkusInjection = quarkusInjection;
    }

    public boolean isSpringInjection() {
        return this.springInjection;
    }

    public void setSpringInjection(boolean springInjection) {
        this.springInjection = springInjection;
    }

    public boolean isDataEventPackageAvailable() {
        return this.dataEventPackageAvailable;
    }

    public void setDataEventPackageAvailable(boolean dataEventPackageAvailable) {
        this.dataEventPackageAvailable = dataEventPackageAvailable;
    }

    public Elements getElementUtils() {
        return this.processingEnvironment.getElementUtils();
    }

    public Types getTypeUtils() {
        return this.processingEnvironment.getTypeUtils();
    }

    public String getPersistenceXmlLocation() {
        return this.persistenceXmlLocation;
    }

    public List<String> getOrmXmlFiles() {
        return this.ormXmlFiles;
    }

    public boolean containsMetaEntity(String qualifiedName) {
        return this.metaEntities.containsKey(qualifiedName);
    }

    public @Nullable Metamodel getMetaEntity(String qualifiedName) {
        return this.metaEntities.get(qualifiedName);
    }

    public Collection<Metamodel> getMetaEntities() {
        return this.metaEntities.values();
    }

    public void addMetaEntity(String qualifiedName, Metamodel metaEntity) {
        this.metaEntities.put(qualifiedName, metaEntity);
    }

    public boolean containsMetaEmbeddable(String qualifiedName) {
        return this.metaEmbeddables.containsKey(qualifiedName);
    }

    public @Nullable Metamodel getMetaEmbeddable(String qualifiedName) {
        return this.metaEmbeddables.get(qualifiedName);
    }

    public void addMetaEmbeddable(String qualifiedName, Metamodel metaEntity) {
        this.metaEmbeddables.put(qualifiedName, metaEntity);
    }

    public Collection<Metamodel> getMetaEmbeddables() {
        return this.metaEmbeddables.values();
    }

    public boolean containsDataMetaEntity(String qualifiedName) {
        return this.dataMetaEntities.containsKey(qualifiedName);
    }

    public @Nullable Metamodel getDataMetaEntity(String qualifiedName) {
        return this.dataMetaEntities.get(qualifiedName);
    }

    public Collection<Metamodel> getDataMetaEntities() {
        return this.dataMetaEntities.values();
    }

    public void addDataMetaEntity(String qualifiedName, Metamodel metaEntity) {
        this.dataMetaEntities.put(qualifiedName, metaEntity);
    }

    public boolean containsDataMetaEmbeddable(String qualifiedName) {
        return this.dataMetaEmbeddables.containsKey(qualifiedName);
    }

    public @Nullable Metamodel getDataMetaEmbeddable(String qualifiedName) {
        return this.dataMetaEmbeddables.get(qualifiedName);
    }

    public void addDataMetaEmbeddable(String qualifiedName, Metamodel metaEntity) {
        this.dataMetaEmbeddables.put(qualifiedName, metaEntity);
    }

    public Collection<Metamodel> getDataMetaEmbeddables() {
        return this.dataMetaEmbeddables.values();
    }

    public @Nullable Metamodel getMetamodel(String qualifiedName) {
        if (this.metaEntities.containsKey(qualifiedName)) {
            return this.metaEntities.get(qualifiedName);
        }
        return this.metaEmbeddables.get(qualifiedName);
    }

    public @Nullable Metamodel getMetaAuxiliary(String qualifiedName) {
        return this.metaAuxiliaries.get(qualifiedName);
    }

    public Collection<Metamodel> getMetaAuxiliaries() {
        return this.metaAuxiliaries.values();
    }

    public void addMetaAuxiliary(String qualifiedName, Metamodel metamodel) {
        this.metaAuxiliaries.put(qualifiedName, metamodel);
    }

    public void addAccessTypeInformation(String qualifiedName, AccessTypeInformation info) {
        this.accessTypeInformation.put(qualifiedName, info);
    }

    public @Nullable AccessTypeInformation getAccessTypeInfo(String qualifiedName) {
        return this.accessTypeInformation.get(qualifiedName);
    }

    public TypeElement getTypeElementForFullyQualifiedName(String qualifiedName) {
        return this.processingEnvironment.getElementUtils().getTypeElement(qualifiedName);
    }

    void markGenerated(Metamodel metamodel) {
        this.generatedModelClasses.add(metamodel);
    }

    boolean isAlreadyGenerated(Metamodel metamodel) {
        return this.generatedModelClasses.contains(metamodel);
    }

    public Set<CharSequence> getElementsToRedo() {
        return this.elementsToRedo;
    }

    public void addElementToRedo(CharSequence qualifiedName) {
        this.elementsToRedo.add(qualifiedName);
    }

    public void removeElementToRedo(CharSequence qualifiedName) {
        this.elementsToRedo.remove(qualifiedName);
    }

    public void logMessage(Diagnostic.Kind type, String message) {
        if (this.logDebug || type != Diagnostic.Kind.OTHER) {
            this.processingEnvironment.getMessager().printMessage(type, message);
        }
    }

    public boolean isFullyXmlConfigured() {
        return this.fullyXmlConfigured != null && this.fullyXmlConfigured != false;
    }

    public void mappingDocumentFullyXmlConfigured(boolean fullyXmlConfigured) {
        this.fullyXmlConfigured = this.fullyXmlConfigured == null ? fullyXmlConfigured : this.fullyXmlConfigured != false && fullyXmlConfigured;
    }

    public AccessType getPersistenceUnitDefaultAccessType() {
        return this.persistenceUnitDefaultAccessType;
    }

    public void setPersistenceUnitDefaultAccessType(AccessType persistenceUnitDefaultAccessType) {
        this.persistenceUnitDefaultAccessType = persistenceUnitDefaultAccessType;
    }

    public boolean doLazyXmlParsing() {
        return this.lazyXmlParsing;
    }

    public void message(Element method, String message, Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method);
    }

    public void message(Element method, AnnotationMirror mirror, AnnotationValue value, String message, Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method, mirror, value);
    }

    public void message(Element method, AnnotationMirror mirror, String message, Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method, mirror);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context");
        sb.append("{accessTypeInformation=").append(this.accessTypeInformation);
        sb.append(", logDebug=").append(this.logDebug);
        sb.append(", lazyXmlParsing=").append(this.lazyXmlParsing);
        sb.append(", fullyXmlConfigured=").append(this.fullyXmlConfigured);
        sb.append(", ormXmlFiles=").append(this.ormXmlFiles);
        sb.append(", persistenceXmlLocation='").append(this.persistenceXmlLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean checkNamedQuery(String name) {
        return this.checkedNamedQueries.add(name);
    }

    public void setUsesQuarkusOrm(boolean b) {
        this.usesQuarkusOrm = b;
    }

    public boolean usesQuarkusOrm() {
        return this.usesQuarkusOrm;
    }

    public void setUsesQuarkusReactive(boolean b) {
        this.usesQuarkusReactive = b;
    }

    public boolean usesQuarkusReactive() {
        return this.usesQuarkusReactive;
    }

    public void setUsesQuarkusPanache2(boolean b) {
        this.usesQuarkusPanache2 = b;
    }

    public boolean usesQuarkusPanache2() {
        return this.usesQuarkusPanache2;
    }

    public void setUsesQuarkusReactiveCommon(boolean b) {
        this.usesQuarkusReactiveCommon = b;
    }

    public boolean usesQuarkusReactiveCommon() {
        return this.usesQuarkusReactiveCommon;
    }

    public void setInclude(String include) {
        this.includes = include.split(",\\s*");
    }

    public void setExclude(String exclude) {
        this.excludes = exclude.isBlank() ? ArrayHelper.EMPTY_STRING_ARRAY : exclude.split(",\\s*");
    }

    public boolean isIncluded(String typeName) {
        for (String include : this.includes) {
            if (!this.matches(typeName, include)) continue;
            for (String exclude : this.excludes) {
                if (!this.matches(typeName, exclude)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matches(String name, String pattern) {
        return "*".equals(pattern) || name.equals(pattern) || pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && name.endsWith(pattern.substring(1)) || pattern.startsWith("*") && pattern.endsWith("*") && name.contains(pattern.substring(1, pattern.length() - 1));
    }

    public List<Element> getAllMembers(TypeElement type) {
        List<? extends Element> elements = type.getEnclosedElements();
        ArrayList<Element> list = new ArrayList<Element>(elements);
        TypeMirror superclass = type.getSuperclass();
        if (superclass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            for (Element inherited : this.getAllMembers(typeElement)) {
                if (!this.notOverridden(type, inherited, elements)) continue;
                list.add(inherited);
            }
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            for (Element inherited : this.getAllMembers(typeElement)) {
                if (!this.notOverridden(type, inherited, elements)) continue;
                list.add(inherited);
            }
        }
        return list;
    }

    private boolean notOverridden(TypeElement type, Element inherited, List<? extends Element> elements) {
        return !(inherited instanceof ExecutableElement) || elements.stream().noneMatch(member -> member instanceof ExecutableElement && this.getElementUtils().overrides((ExecutableElement)member, (ExecutableElement)inherited, type));
    }

    public Map<String, String> getEntityNameMappings() {
        return this.entityNameMappings;
    }

    public void addEntityNameMapping(String entityName, String qualifiedName) {
        this.entityNameMappings.put(entityName, qualifiedName);
    }

    public @Nullable String qualifiedNameForEntityName(String entityName) {
        return this.entityNameMappings.get(entityName);
    }

    public Map<String, Set<String>> getEnumTypesByValue() {
        return this.enumTypesByValue;
    }

    public void addEnumValue(String qualifiedTypeName, String shortTypeName, @Nullable String outerTypeQualifiedName, @Nullable String outerShortTypeName, String value) {
        this.addEnumValue(qualifiedTypeName, value);
        this.addEnumValue(qualifiedTypeName, qualifiedTypeName + "." + value);
        this.addEnumValue(qualifiedTypeName, shortTypeName + "." + value);
        if (outerShortTypeName != null) {
            this.addEnumValue(qualifiedTypeName, outerShortTypeName + "." + shortTypeName + "." + value);
            this.addEnumValue(qualifiedTypeName, outerShortTypeName + "$" + shortTypeName + "." + value);
            this.addEnumValue(qualifiedTypeName, outerTypeQualifiedName + "$" + shortTypeName + "." + value);
        }
    }

    private void addEnumValue(String qualifiedTypeName, String value) {
        this.enumTypesByValue.computeIfAbsent(value, s -> new TreeSet()).add(qualifiedTypeName);
    }

    public void setIndexing(boolean index) {
        this.indexing = index;
    }

    public boolean isIndexing() {
        return this.indexing;
    }
}

