/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.CriteriaDeleteMethod;
import org.hibernate.processor.annotation.OrderBy;

public abstract class AbstractFinderMethod
extends AbstractQueryMethod {
    final @Nullable String containerType;
    final String entity;
    final List<String> fetchProfiles;

    AbstractFinderMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, @Nullable String containerType, boolean belongsToDao, String sessionType, String sessionName, List<String> fetchProfiles, List<String> paramNames, List<String> paramTypes, List<OrderBy> orderBys, boolean addNonnullAnnotation, boolean convertToDataExceptions, String fullReturnType, boolean nullable) {
        super(annotationMetaEntity, method, methodName, paramNames, paramTypes, entity, sessionType, sessionName, belongsToDao, orderBys, addNonnullAnnotation, convertToDataExceptions, fullReturnType, nullable);
        this.entity = entity;
        this.containerType = containerType;
        this.fetchProfiles = fetchProfiles;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getTypeDeclaration() {
        return this.entity;
    }

    @Override
    public String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    void comment(StringBuilder declaration) {
        declaration.append("\n/**").append("\n * ").append(this instanceof CriteriaDeleteMethod ? "Delete" : "Find").append(" {@link ").append(this.annotationMetaEntity.importType(this.entity)).append("}");
        long paramCount = this.paramTypes.stream().filter(type -> !AbstractFinderMethod.isSpecialParam(type)).count();
        if (paramCount > 0L) {
            declaration.append(" by ");
            int count = 0;
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                String type2 = (String)this.paramTypes.get(i);
                if (AbstractFinderMethod.isSpecialParam(type2)) continue;
                if (count > 0) {
                    if ((long)(count + 1) == paramCount) {
                        declaration.append(paramCount > 2L ? ", and " : " and ");
                    } else {
                        declaration.append(", ");
                    }
                }
                ++count;
                String path = (String)this.paramNames.get(i);
                if ("{id}".equals(path)) {
                    declaration.append("identifier");
                    continue;
                }
                declaration.append("{@link ").append(this.annotationMetaEntity.importType(this.entity)).append('#').append(this.qualifier(path)).append(' ').append(path).append("}");
            }
        }
        declaration.append('.').append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    String qualifier(String name) {
        int index = name.indexOf(46);
        return index > 0 ? name.substring(0, index) : name;
    }

    void unwrapSession(StringBuilder declaration) {
        if (this.isUsingEntityManager()) {
            declaration.append(".unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.Session")).append(".class)\n\t\t\t");
        }
    }

    boolean enableFetchProfile(StringBuilder declaration, boolean unwrapped) {
        if (!this.fetchProfiles.isEmpty()) {
            this.unwrapQuery(declaration, unwrapped);
            unwrapped = true;
        }
        for (String profile : this.fetchProfiles) {
            declaration.append("\t\t\t.enableFetchProfile(").append(profile).append(")\n");
        }
        return unwrapped;
    }

    void tryReturn(StringBuilder declaration) {
        if (this.dataRepository) {
            declaration.append("\ttry {\n\t");
        }
        declaration.append("\treturn ").append(this.sessionName).append(this.getObjectCall());
    }

    void modifiers(StringBuilder declaration) {
        declaration.append(this.belongsToDao ? "@Override\npublic " : "public static ");
    }
}

