/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

public class CDIAccessorMetaAttribute
implements MetaAttribute {
    private AnnotationMetaEntity annotationMetaEntity;
    private String propertyName;
    private String typeName;

    public CDIAccessorMetaAttribute(AnnotationMetaEntity annotationMetaEntity, Element repositoryElement) {
        this.annotationMetaEntity = annotationMetaEntity;
        String name = repositoryElement.getSimpleName().toString();
        this.propertyName = StringUtil.decapitalize(name);
        this.typeName = name;
    }

    public CDIAccessorMetaAttribute(AnnotationMetaEntity annotationMetaEntity, String propertyName, String className) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.propertyName = propertyName;
        this.typeName = className;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.modifiers(declaration);
        this.preamble(declaration);
        this.returnCDI(declaration);
        this.closingBrace(declaration);
        return declaration.toString();
    }

    private void returnCDI(StringBuilder declaration) {
        this.annotationMetaEntity.importType("jakarta.enterprise.inject.spi.CDI");
        declaration.append("\treturn CDI.current().select(").append(this.typeName).append(".class).get();\n");
    }

    void closingBrace(StringBuilder declaration) {
        declaration.append("}");
    }

    void preamble(StringBuilder declaration) {
        declaration.append(this.typeName).append(" ").append(this.getPropertyName());
        declaration.append("() {\n");
    }

    @Override
    public String getAttributeNameDeclarationString() {
        return "";
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getTypeDeclaration() {
        return "";
    }

    void modifiers(StringBuilder declaration) {
        declaration.append("\npublic static ");
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

