/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class EnabledFetchProfileMetaAttribute
extends NameMetaAttribute {
    private final String prefix;
    private final String referenceType;

    public EnabledFetchProfileMetaAttribute(Metamodel annotationMetaEntity, String name, String prefix, String referenceType) {
        super(annotationMetaEntity, name, prefix);
        this.prefix = prefix;
        this.referenceType = referenceType;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**\n * @see ").append("#");
        this.appendFieldName(declaration);
        return declaration.append("\n **/\n").append(super.getAttributeNameDeclarationString()).toString();
    }

    @Override
    public String getAttributeDeclarationString() {
        Metamodel entity = this.getHostingEntity();
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**").append("\n * The fetch profile named {@value ").append(this.prefix).append(this.fieldName()).append("}\n").append(" *\n * @see ").append(entity.getQualifiedName()).append("\n **/\n").append("public static final ").append(entity.importType(this.referenceType)).append(' ');
        this.appendFieldName(declaration);
        declaration.append(" = new ").append(entity.importType(this.referenceType)).append("(").append(this.prefix).append(this.fieldName()).append(");");
        return declaration.toString();
    }

    private void appendFieldName(StringBuilder declaration) {
        declaration.append('_').append(StringUtil.nameToMethodName(this.getPropertyName()));
    }
}

