/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.util.TypeUtils;

public class IdFinderMethod
extends AbstractFinderMethod {
    private final String paramName;
    private final String paramType;

    public IdFinderMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, @Nullable String containerType, List<String> paramNames, List<String> paramTypes, boolean belongsToDao, String sessionType, String sessionName, List<String> fetchProfiles, boolean addNonnullAnnotation, boolean dataRepository, String fullReturnType, boolean nullable) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, Collections.emptyList(), addNonnullAnnotation, dataRepository, fullReturnType, nullable);
        int idParameter = IdFinderMethod.idParameter(paramNames, paramTypes);
        this.paramName = paramNames.get(idParameter);
        this.paramType = paramTypes.get(idParameter);
    }

    private static int idParameter(List<String> paramNames, List<String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            if (IdFinderMethod.isSessionParameter(paramTypes.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isNullable(int index) {
        return false;
    }

    @Override
    boolean singleResult() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, this.paramTypes);
        if (this.paramName != null && !TypeUtils.isPrimitive(this.paramType)) {
            this.nullCheck(declaration, this.paramName);
        }
        this.varOrReturn(declaration);
        if (this.fetchProfiles.isEmpty()) {
            this.findWithNoFetchProfiles(declaration);
        } else {
            this.findWithFetchProfiles(declaration);
        }
        this.throwIfNull(declaration);
        this.convertExceptions(declaration);
        IdFinderMethod.closingBrace(declaration);
        return declaration.toString();
    }

    private void throwIfNull(StringBuilder declaration) {
        if (this.containerType != null) {
            if (this.isReactive()) {
                declaration.append("\n\t\t\t.map(").append(this.annotationMetaEntity.importType(this.containerType)).append("::").append("ofNullable");
            }
            declaration.append(')');
        } else if (!this.nullable) {
            if (this.isReactive()) {
                declaration.append("\n\t\t\t.replaceIfNullWith(() -> { ");
                if (this.dataRepository) {
                    this.throwEmptyResult(declaration);
                } else {
                    this.throwObjectNotFound(declaration);
                }
                declaration.append("; })");
            } else {
                declaration.append(";\n");
                if (this.dataRepository) {
                    declaration.append("\t\tif (_result == null) ");
                    this.throwEmptyResult(declaration);
                    declaration.append(";\n").append("\t\treturn _result");
                } else {
                    declaration.append("\tif (_result == null) ");
                    this.throwObjectNotFound(declaration);
                    declaration.append(";\n").append("\treturn _result");
                }
            }
        }
    }

    private void throwEmptyResult(StringBuilder declaration) {
        declaration.append("throw new ").append(this.annotationMetaEntity.importType("jakarta.data.exceptions.EmptyResultException")).append("(\"No '").append(this.annotationMetaEntity.importType(this.entity)).append("' for given id [\" + ").append(IdFinderMethod.parameterName(this.paramName)).append(" + \"]\",\n\t\t\t\t\tnew ").append(this.annotationMetaEntity.importType("org.hibernate.ObjectNotFoundException")).append("((Object) ").append(IdFinderMethod.parameterName(this.paramName)).append(", \"").append(this.entity).append("\"))");
    }

    private void throwObjectNotFound(StringBuilder declaration) {
        declaration.append("throw new ").append(this.annotationMetaEntity.importType("org.hibernate.ObjectNotFoundException")).append("((Object) ").append(this.paramName).append(", \"").append(this.entity).append("\")");
    }

    private void varOrReturn(StringBuilder declaration) {
        if (this.dataRepository && !this.isReactive()) {
            declaration.append("\ttry {\n\t");
        }
        if (this.containerType != null && !this.isReactive()) {
            declaration.append("\treturn ").append(this.annotationMetaEntity.staticImport(this.containerType, "ofNullable")).append('(');
        } else if (!this.nullable && !this.isReactive()) {
            declaration.append("\tvar _result = ");
        } else {
            declaration.append("\treturn ");
        }
        declaration.append(this.sessionName).append(this.getObjectCall());
    }

    private void findWithFetchProfiles(StringBuilder declaration) {
        this.unwrapSession(declaration);
        declaration.append(".byId(").append(this.annotationMetaEntity.importType(this.entity)).append(".class)\n");
        this.enableFetchProfile(declaration, true);
        declaration.append("\t\t\t.load(").append(this.paramName).append(")");
    }

    private void findWithNoFetchProfiles(StringBuilder declaration) {
        if (this.isReactiveSessionAccess()) {
            declaration.append(".chain(").append(this.localSessionName()).append(" -> ").append(this.localSessionName());
        }
        declaration.append(this.isUsingStatelessSession() ? ".get(" : ".find(").append(this.annotationMetaEntity.importType(this.entity)).append(".class, ").append(IdFinderMethod.parameterName(this.paramName));
        if (this.isReactiveSessionAccess()) {
            declaration.append(')');
        }
        declaration.append(")");
    }
}

