/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hotswap.agent.HotswapAgent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.annotation.handler.AnnotationProcessor;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.classloader.ClassLoaderDefineClassPatcher;
import org.hotswap.agent.util.scanner.ClassPathAnnotationScanner;
import org.hotswap.agent.util.scanner.ClassPathScanner;

public class PluginRegistry {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PluginRegistry.class);
    protected Map<Class, Map<ClassLoader, Object>> registeredPlugins = Collections.synchronizedMap(new HashMap());
    private PluginManager pluginManager;
    private ClassPathAnnotationScanner annotationScanner;
    protected AnnotationProcessor annotationProcessor;
    private ClassLoaderDefineClassPatcher classLoaderPatcher;

    public Map<Class, Map<ClassLoader, Object>> getRegisteredPlugins() {
        return this.registeredPlugins;
    }

    public void setAnnotationScanner(ClassPathAnnotationScanner annotationScanner) {
        this.annotationScanner = annotationScanner;
    }

    public void setAnnotationProcessor(AnnotationProcessor annotationProcessor) {
        this.annotationProcessor = annotationProcessor;
    }

    public void setClassLoaderPatcher(ClassLoaderDefineClassPatcher classLoaderPatcher) {
        this.classLoaderPatcher = classLoaderPatcher;
    }

    public PluginRegistry(PluginManager pluginManager, ClassLoaderDefineClassPatcher classLoaderPatcher) {
        this.pluginManager = pluginManager;
        this.classLoaderPatcher = classLoaderPatcher;
        this.annotationScanner = new ClassPathAnnotationScanner(Plugin.class.getName(), new ClassPathScanner());
        this.annotationProcessor = new AnnotationProcessor(pluginManager);
    }

    public void scanPlugins(ClassLoader classLoader, String pluginPackage) {
        String pluginPath = pluginPackage.replace(".", "/");
        ClassLoader agentClassLoader = this.getClass().getClassLoader();
        try {
            List<String> discoveredPlugins = this.annotationScanner.scanPlugins(classLoader, pluginPath);
            ArrayList<String> discoveredPluginNames = new ArrayList<String>();
            if (discoveredPlugins.size() > 0 && agentClassLoader != classLoader) {
                this.classLoaderPatcher.patch(classLoader, pluginPath, agentClassLoader, null);
            }
            for (String discoveredPlugin : discoveredPlugins) {
                Class<?> pluginClass = Class.forName(discoveredPlugin, true, agentClassLoader);
                Plugin pluginAnnotation = pluginClass.getAnnotation(Plugin.class);
                if (pluginAnnotation == null) {
                    LOGGER.error("Scanner discovered plugin class {} which does not contain @Plugin annotation.", pluginClass);
                    continue;
                }
                String pluginName = pluginAnnotation.name();
                if (HotswapAgent.isPluginDisabled(pluginName)) {
                    LOGGER.debug("Plugin {} is disabled, skipping...", pluginName);
                    continue;
                }
                if (this.registeredPlugins.containsKey(pluginClass)) continue;
                this.registeredPlugins.put(pluginClass, Collections.synchronizedMap(new HashMap()));
                if (this.annotationProcessor.processAnnotations(pluginClass, pluginClass)) {
                    LOGGER.debug("Plugin registered {}.", pluginClass);
                } else {
                    LOGGER.error("Error processing annotations for plugin {}. Plugin was unregistered.", pluginClass);
                    this.registeredPlugins.remove(pluginClass);
                }
                discoveredPluginNames.add(pluginName);
            }
            LOGGER.info("Discovered plugins: " + Arrays.toString(discoveredPluginNames.toArray()), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error in plugin initial processing for plugin package '{}'", e, pluginPackage);
        }
    }

    public Object initializePlugin(String pluginClass, ClassLoader appClassLoader) {
        if (appClassLoader == null) {
            throw new IllegalArgumentException("Cannot initialize plugin '" + pluginClass + "', appClassLoader is null.");
        }
        this.pluginManager.initClassLoader(appClassLoader);
        Class<Object> clazz = this.getPluginClass(pluginClass);
        if (this.pluginManager.getPluginConfiguration(appClassLoader).isDisabledPlugin(clazz)) {
            LOGGER.debug("Plugin {} disabled in classloader {}.", clazz, appClassLoader);
            return null;
        }
        if (this.doHasPlugin(clazz, appClassLoader, false, true)) {
            LOGGER.debug("Plugin {} already initialized in parent classloader of {}.", clazz, appClassLoader);
            return this.getPlugin(clazz, appClassLoader);
        }
        Object pluginInstance = this.registeredPlugins.get(clazz).get(appClassLoader);
        if (this.annotationProcessor.processAnnotations(pluginInstance)) {
            LOGGER.info("Plugin '{}' initialized in ClassLoader '{}'.", pluginClass, appClassLoader);
        } else {
            LOGGER.error("Plugin '{}' NOT initialized in ClassLoader '{}', error while processing annotations.", pluginClass, appClassLoader);
            this.registeredPlugins.get(clazz).remove(appClassLoader);
        }
        return pluginInstance;
    }

    public void initializePluginInstance(Object pluginInstance) {
        this.registeredPlugins.put(pluginInstance.getClass(), Collections.singletonMap(pluginInstance.getClass().getClassLoader(), pluginInstance));
        if (!this.annotationProcessor.processAnnotations(pluginInstance)) {
            throw new IllegalStateException("Unable to initialize plugin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getPlugin(Class<T> pluginClass, ClassLoader classLoader) {
        Map<ClassLoader, Object> pluginInstances;
        if (this.registeredPlugins.isEmpty()) {
            throw new IllegalStateException("No plugin initialized. The Hotswap Agent JAR must NOT be in app classloader (only registered as --javaagent: startup parameter). Please check your mapPreviousState.");
        }
        if (!this.registeredPlugins.containsKey(pluginClass)) {
            throw new IllegalArgumentException(String.format("Plugin %s is not known to the registry.", pluginClass));
        }
        Map<ClassLoader, Object> map = pluginInstances = this.registeredPlugins.get(pluginClass);
        synchronized (map) {
            for (Map.Entry<ClassLoader, Object> registeredClassLoaderEntry : pluginInstances.entrySet()) {
                if (!this.isParentClassLoader(registeredClassLoaderEntry.getKey(), classLoader)) continue;
                return (T)registeredClassLoaderEntry.getValue();
            }
        }
        throw new IllegalArgumentException(String.format("Plugin %s is not initialized in classloader %s.", pluginClass, classLoader));
    }

    public boolean hasPlugin(Class<?> pluginClass, ClassLoader classLoader, boolean checkParent) {
        return this.doHasPlugin(pluginClass, classLoader, checkParent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHasPlugin(Class<?> pluginClass, ClassLoader classLoader, boolean checkParent, boolean createIfMissing) {
        Map<ClassLoader, Object> pluginInstances;
        if (!this.registeredPlugins.containsKey(pluginClass)) {
            return false;
        }
        Map<ClassLoader, Object> map = pluginInstances = this.registeredPlugins.get(pluginClass);
        synchronized (map) {
            for (Map.Entry<ClassLoader, Object> registeredClassLoaderEntry : pluginInstances.entrySet()) {
                if (checkParent && this.isParentClassLoader(registeredClassLoaderEntry.getKey(), classLoader)) {
                    return true;
                }
                if (!registeredClassLoaderEntry.getKey().equals(classLoader)) continue;
                return true;
            }
            if (createIfMissing) {
                Object pluginInstance = this.instantiate(pluginClass);
                pluginInstances.put(classLoader, pluginInstance);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getAppClassLoader(Object plugin) {
        Class<Object> clazz = this.getPluginClass(plugin.getClass().getName());
        Map<ClassLoader, Object> pluginInstances = this.registeredPlugins.get(clazz);
        if (pluginInstances != null) {
            Map<ClassLoader, Object> map = pluginInstances;
            synchronized (map) {
                for (Map.Entry<ClassLoader, Object> entry : pluginInstances.entrySet()) {
                    if (!entry.getValue().equals(plugin)) continue;
                    return entry.getKey();
                }
            }
        }
        throw new IllegalArgumentException("Plugin not found in the registry " + plugin);
    }

    protected Class<Object> getPluginClass(String pluginClass) {
        try {
            return this.getClass().getClassLoader().loadClass(pluginClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Plugin class not found " + pluginClass, e);
        }
    }

    private boolean isParentClassLoader(ClassLoader parentClassLoader, ClassLoader classLoader) {
        if (parentClassLoader.equals(classLoader)) {
            return true;
        }
        if (classLoader.getParent() != null) {
            return this.isParentClassLoader(parentClassLoader, classLoader.getParent());
        }
        return false;
    }

    protected Object instantiate(Class<Object> plugin) {
        try {
            return plugin.newInstance();
        }
        catch (InstantiationException e) {
            LOGGER.error("Error instantiating plugin: " + plugin.getClass().getName(), e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Plugin: " + plugin.getClass().getName() + " does not contain public no param constructor", e, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClassLoader(ClassLoader classLoader) {
        LOGGER.debug("Closing classloader {}.", classLoader);
        Map<Class, Map<ClassLoader, Object>> map = this.registeredPlugins;
        synchronized (map) {
            for (Map<ClassLoader, Object> plugins : this.registeredPlugins.values()) {
                plugins.remove(classLoader);
            }
        }
    }
}

