/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.Watcher;
import org.hotswap.agent.watch.nio.EventDispatcher;

public abstract class AbstractNIO2Watcher
implements Watcher {
    protected AgentLogger LOGGER = AgentLogger.getLogger(this.getClass());
    protected static final WatchEvent.Kind<?>[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    protected WatchService watcher;
    protected final Map<WatchKey, Path> keys;
    private final Map<Path, List<WatchEventListener>> listeners = new ConcurrentHashMap<Path, List<WatchEventListener>>();
    protected Map<WatchEventListener, ClassLoader> classLoaderListeners = new ConcurrentHashMap<WatchEventListener, ClassLoader>();
    private Thread runner;
    private volatile boolean stopped;
    protected final EventDispatcher dispatcher;

    public AbstractNIO2Watcher() throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new ConcurrentHashMap<WatchKey, Path>();
        this.dispatcher = new EventDispatcher(this.listeners);
    }

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    @Override
    public synchronized void addEventListener(ClassLoader classLoader, URI pathPrefix, WatchEventListener listener) {
        File path;
        try {
            path = new File(pathPrefix);
        }
        catch (IllegalArgumentException e) {
            if (!this.LOGGER.isLevelEnabled(AgentLogger.Level.TRACE)) {
                this.LOGGER.warning("Unable to watch for path {}, not a local regular file or directory.", pathPrefix);
            } else {
                this.LOGGER.trace("Unable to watch for path {} exception", e, pathPrefix);
            }
            return;
        }
        try {
            this.addDirectory(path.toPath());
        }
        catch (IOException e) {
            if (!this.LOGGER.isLevelEnabled(AgentLogger.Level.TRACE)) {
                this.LOGGER.warning("Unable to watch for path {}, not a local regular file or directory.", pathPrefix);
            } else {
                this.LOGGER.trace("Unable to watch path with prefix '{}' for changes.", e, pathPrefix);
            }
            return;
        }
        List<WatchEventListener> list = this.listeners.get(Paths.get(pathPrefix));
        if (list == null) {
            list = new ArrayList<WatchEventListener>();
            this.listeners.put(Paths.get(pathPrefix), list);
        }
        list.add(listener);
        if (classLoader != null) {
            this.classLoaderListeners.put(listener, classLoader);
        }
    }

    @Override
    public void addEventListener(ClassLoader classLoader, URL pathPrefix, WatchEventListener listener) {
        if (pathPrefix == null) {
            return;
        }
        try {
            this.addEventListener(classLoader, pathPrefix.toURI(), listener);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert URL to URI " + pathPrefix, e);
        }
    }

    @Override
    public void closeClassLoader(ClassLoader classLoader) {
        Iterator<Object> entryIterator = this.classLoaderListeners.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<WatchEventListener, ClassLoader> entry = entryIterator.next();
            if (!entry.getValue().equals(classLoader)) continue;
            entryIterator.remove();
            try {
                Iterator<Map.Entry<Path, List<WatchEventListener>>> listenersIterator = this.listeners.entrySet().iterator();
                while (listenersIterator.hasNext()) {
                    Map.Entry<Path, List<WatchEventListener>> pathListenerEntry = listenersIterator.next();
                    List<WatchEventListener> l = pathListenerEntry.getValue();
                    if (l != null) {
                        l.remove(entry.getKey());
                    }
                    if (l != null && !l.isEmpty()) continue;
                    listenersIterator.remove();
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Ooops", e, new Object[0]);
            }
        }
        if (this.classLoaderListeners.isEmpty()) {
            this.listeners.clear();
            for (WatchKey wk : this.keys.keySet()) {
                try {
                    wk.cancel();
                }
                catch (Exception e) {
                    this.LOGGER.error("Ooops", e, new Object[0]);
                }
            }
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                this.LOGGER.error("Ooops", e, new Object[0]);
            }
            this.LOGGER.info("All classloaders closed, released watch service..", new Object[0]);
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                this.LOGGER.error("Ooops", e, new Object[0]);
            }
        }
        this.LOGGER.debug("All watch listeners removed for classLoader {}", classLoader);
    }

    public void addDirectory(Path path) throws IOException {
        this.registerAll(path);
    }

    protected abstract void registerAll(Path var1) throws IOException;

    private boolean processEvents() throws InterruptedException {
        WatchKey key = this.watcher.poll(10L, TimeUnit.MILLISECONDS);
        if (key == null) {
            return true;
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            this.LOGGER.warning("WatchKey '{}' not recognized", key);
            return true;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                this.LOGGER.warning("WatchKey '{}' overflowed", key);
                continue;
            }
            WatchEvent<Path> ev = AbstractNIO2Watcher.cast(event);
            Path name = (Path)ev.context();
            Path child = dir.resolve(name);
            this.LOGGER.debug("Watch event '{}' on '{}' --> {}", event.kind().name(), child, name);
            this.dispatcher.add(ev, child);
            if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
            try {
                if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                this.registerAll(child);
            }
            catch (IOException x) {
                this.LOGGER.warning("Unable to register events for directory {}", x, child);
            }
        }
        boolean valid = key.reset();
        if (!valid) {
            this.LOGGER.warning("Watcher on {} not valid, removing path=", this.keys.get(key));
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return false;
            }
            if (this.classLoaderListeners.isEmpty()) {
                for (WatchKey k : this.keys.keySet()) {
                    k.cancel();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void run() {
        this.runner = new Thread(){

            @Override
            public void run() {
                try {
                    while (!AbstractNIO2Watcher.this.stopped && AbstractNIO2Watcher.this.processEvents()) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.runner.setDaemon(true);
        this.runner.setName("HotSwap Watcher");
        this.runner.start();
        this.dispatcher.start();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    static WatchEvent.Modifier getWatchEventModifier(String claz, String field) {
        try {
            Class<?> c = Class.forName(claz);
            Field f = c.getField(field);
            return (WatchEvent.Modifier)f.get(c);
        }
        catch (Exception e) {
            return null;
        }
    }
}

