/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.nio.HotswapWatchFileEvent;

public class EventDispatcher
implements Runnable {
    protected AgentLogger LOGGER = AgentLogger.getLogger(this.getClass());
    private final Map<Path, List<WatchEventListener>> listeners;
    private final ArrayList<Event> working = new ArrayList();
    private Thread runnable = null;
    private final ArrayBlockingQueue<Event> eventQueue = new ArrayBlockingQueue(500);

    public EventDispatcher(Map<Path, List<WatchEventListener>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void run() {
        while (true) {
            for (Event e : this.working) {
                this.callListeners(e.event, e.path);
                if (Thread.interrupted()) {
                    return;
                }
                Thread.yield();
            }
            this.eventQueue.drainTo(this.working);
            for (Event e : this.working) {
                this.callListeners(e.event, e.path);
                if (Thread.interrupted()) {
                    return;
                }
                Thread.yield();
            }
            this.working.clear();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                return;
            }
        }
    }

    public void add(WatchEvent<Path> event, Path path) {
        this.eventQueue.offer(new Event(event, path));
    }

    private void callListeners(WatchEvent<?> event, Path path) {
        boolean matchedOne = false;
        for (Map.Entry<Path, List<WatchEventListener>> list : this.listeners.entrySet()) {
            if (!path.startsWith(list.getKey())) continue;
            matchedOne = true;
            for (WatchEventListener listener : new ArrayList(list.getValue())) {
                HotswapWatchFileEvent agentEvent = new HotswapWatchFileEvent(event, path);
                try {
                    listener.onEvent(agentEvent);
                }
                catch (Throwable throwable) {}
            }
        }
        if (!matchedOne) {
            this.LOGGER.error("No match for  watch event '{}',  path '{}'", event, path);
        }
    }

    public void start() {
        this.runnable = new Thread(this);
        this.runnable.setDaemon(true);
        this.runnable.setName("HotSwap Dispatcher");
        this.runnable.start();
    }

    public void stop() throws InterruptedException {
        if (this.runnable != null) {
            this.runnable.interrupt();
            this.runnable.join();
        }
        this.runnable = null;
    }

    static class Event {
        final WatchEvent<Path> event;
        final Path path;

        public Event(WatchEvent<Path> event, Path path) {
            this.event = event;
            this.path = path;
        }
    }
}

