/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.htmlparser.lexerapplications.thumbelina.PictureListener;
import org.htmlparser.lexerapplications.thumbelina.Tile;

public class Picture
extends Rectangle
implements Runnable,
ImageObserver,
Tile {
    protected final int TRANSFER_SIZE = 4096;
    public static final Point ORIGIN = new Point(0, 0);
    protected URL mURL;
    public PictureListener mListener;
    protected boolean mValid;
    protected Point mOrigin;
    protected Point mExtent;
    protected Image mImage;
    protected File mLocalFile;

    public Picture(URL url, PictureListener listener, Rectangle r) {
        this.setIdentity(url);
        this.mListener = listener;
        this.setValid(true);
        if (null != r) {
            this.setOrigin(new Point(r.x, r.y));
            this.setExtent(new Point(r.width, r.height));
        } else {
            this.setOrigin(ORIGIN);
            this.setExtent(ORIGIN);
        }
        this.mImage = null;
        this.mLocalFile = null;
    }

    public Point getOrigin() {
        return this.mOrigin;
    }

    public void setOrigin(Point origin) {
        this.x = origin.x;
        this.y = origin.y;
        this.mOrigin = origin;
    }

    public Point getExtent() {
        return this.mExtent;
    }

    public void setExtent(Point extent) {
        this.width = extent.x;
        this.height = extent.y;
        this.mExtent = extent;
    }

    public Image getImage() {
        Object ret = null;
        if (null == this.mImage && this.getValid() && null != this.mLocalFile) {
            long size = this.mLocalFile.length();
            try {
                if (size > Integer.MAX_VALUE) {
                    this.setValid(false);
                } else {
                    byte[] bytes = new byte[(int)size];
                    try {
                        FileInputStream in = new FileInputStream(this.mLocalFile);
                        in.read(bytes);
                        in.close();
                        this.mImage = Toolkit.getDefaultToolkit().createImage(bytes);
                    }
                    catch (IOException ioe) {
                        System.err.println(this.getIdentity().toString() + " is corrupt on disk");
                        this.setValid(false);
                    }
                }
            }
            catch (OutOfMemoryError oome) {
                System.err.println(this.getIdentity().toString() + " is too big for available memory");
                this.setValid(false);
            }
        }
        return this.mImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String suffix = this.mURL.toString();
        Thread.currentThread().setName(suffix);
        suffix = suffix.substring(suffix.lastIndexOf("."));
        try {
            File file = File.createTempFile("thumbelina", suffix);
            file.deleteOnExit();
            byte[] data = new byte[4096];
            try {
                InputStream in = this.mURL.openStream();
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int read;
                        while (-1 != (read = in.read(data, 0, data.length))) {
                            out.write(data, 0, read);
                        }
                        this.mLocalFile = file;
                        Image image = this.getImage();
                        this.setExtent(new Point(image.getWidth(this), image.getHeight(this)));
                        if (null != this.mListener) {
                            this.mListener.pictureReceived(this);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("broken link " + fnfe.getMessage() + " ignored");
            }
        }
        catch (IOException ioe) {
            System.err.println("I/O problem: " + ioe.getMessage());
            Object file = null;
        }
    }

    public boolean getValid() {
        return this.mValid;
    }

    public void setValid(boolean valid) {
        this.mValid = valid;
        this.mImage = null;
    }

    public Object getIdentity() {
        return this.mURL;
    }

    public void setIdentity(Object object) {
        this.mURL = (URL)object;
    }

    public void reset() {
        this.setBounds(this.mOrigin.x, this.mOrigin.y, this.mExtent.x, this.mExtent.y);
    }

    public void setBounds(Rectangle r) {
        if (r.width < 0 || r.height < 0) {
            System.out.println("oops");
        }
        super.setBounds(r);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            System.out.println("oops");
        }
        super.setBounds(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
        boolean error;
        this.mImage = image;
        boolean done = 0 != (infoflags & 0x20);
        boolean abort = 0 != (infoflags & 0x80);
        boolean bl = error = 0 != (infoflags & 0x40);
        if (done || abort || error) {
            Image image2 = this.mImage;
            synchronized (image2) {
                if (!done) {
                    System.err.println(this.getIdentity().toString() + " is invalid");
                    this.mImage = null;
                    this.setValid(false);
                } else {
                    this.setExtent(new Point(this.mImage.getWidth(null), this.mImage.getHeight(null)));
                    if (null != this.mListener) {
                        this.mListener.pictureReady(this);
                    }
                }
            }
        }
        return !done;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getIdentity().toString());
        ret.append("[x=");
        ret.append(Integer.toString(this.x));
        ret.append(",y=");
        ret.append(Integer.toString(this.y));
        ret.append(",width=");
        ret.append(Integer.toString(this.width));
        ret.append(",height=");
        ret.append(Integer.toString(this.height));
        ret.append("]");
        return ret.toString();
    }
}

