/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.BevelBorder;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.Thumbelina;
import org.htmlparser.lexerapplications.thumbelina.Tile;
import org.htmlparser.lexerapplications.thumbelina.TileSet;

public class PicturePanel
extends JPanel
implements MouseListener,
Scrollable,
ComponentListener,
HierarchyListener {
    protected static final int UNIT_INCREMENT = 10;
    protected static final int BLOCK_INCREMENT = 100;
    protected Thumbelina mThumbelina;
    protected TileSet mMosaic;
    protected Dimension mPreferredSize;

    public PicturePanel(Thumbelina thumbelina) {
        this.mThumbelina = thumbelina;
        this.mMosaic = new TileSet();
        this.mPreferredSize = null;
        this.setDoubleBuffered(false);
        this.setBorder(new BevelBorder(1));
        this.addMouseListener(this);
        this.addHierarchyListener(this);
    }

    public void reset() {
        this.mMosaic = new TileSet();
        this.repaint();
    }

    public void bringToTop(Tile tile) {
        this.mMosaic.bringToTop(tile);
        Rectangle rectangle = tile.getBounds();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.mThumbelina.mUrlText.setText(tile.getIdentity().toString());
    }

    public Picture find(String url) {
        Picture ret = null;
        Iterator<Tile> iterator = this.mMosaic.getTiles();
        while (null == ret && iterator.hasNext()) {
            Picture picture = (Picture)iterator.next();
            if (!url.equals(picture.getIdentity().toString())) continue;
            ret = picture;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Picture picture, boolean add) {
        Container parent = this.getParent();
        boolean dolayout = false;
        TileSet tileSet = this.mMosaic;
        synchronized (tileSet) {
            if (parent instanceof JViewport) {
                Dimension before = this.getPreferredSize();
                this.mMosaic.add(picture);
                Dimension after = this.calculatePreferredSize();
                if (after.width > before.width) {
                    dolayout = true;
                } else {
                    after.width = before.width;
                }
                if (after.height > before.height) {
                    dolayout = true;
                } else {
                    after.height = before.height;
                }
                if (dolayout) {
                    this.mPreferredSize = after;
                }
            } else {
                this.mMosaic.add(picture);
            }
        }
        if (dolayout) {
            this.revalidate();
            this.invalidate();
            this.validate();
        }
        this.repaint(picture.x, picture.y, picture.width, picture.height);
        if (add) {
            this.mThumbelina.addHistory(picture.getIdentity().toString());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void adjustClipForInsets(Graphics graphics) {
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        Rectangle clip = graphics.getClipBounds();
        if (clip.x < insets.left) {
            clip.x = insets.left;
        }
        if (clip.y < insets.top) {
            clip.y = insets.top;
        }
        if (clip.x + clip.width > dim.width - insets.right) {
            clip.width = dim.width - insets.right - clip.x;
        }
        if (clip.y + clip.height > dim.height - insets.bottom) {
            clip.height = dim.height - insets.bottom - clip.y;
        }
        graphics.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Rectangle clip = graphics.getClipBounds();
        TileSet tileSet = this.mMosaic;
        synchronized (tileSet) {
            Rectangle s = graphics.getClipBounds();
            super.paint(graphics);
            if (0 != this.mMosaic.getTileCount()) {
                super.paint(graphics);
                Iterator<Tile> iterator = this.mMosaic.getTiles();
                HashSet<Image> set = new HashSet<Image>();
                while (iterator.hasNext()) {
                    Image image;
                    Picture picture = (Picture)iterator.next();
                    if (!picture.getValid()) continue;
                    Rectangle rectangle = picture.getBounds();
                    if (null != clip && !clip.intersects(rectangle) || set.contains(image = picture.getImage())) continue;
                    set.add(image);
                    Point origin = picture.getOrigin();
                    Watcher observer = new Watcher(this, image, origin.x, origin.y, 0, 0);
                    int width = image.getWidth(observer);
                    int height = image.getHeight(observer);
                    if (!this.prepareImage(image, observer)) continue;
                    if (!observer.drawn) {
                        graphics.drawImage(image, origin.x, origin.y, origin.x + width, origin.y + height, 0, 0, width, height, null);
                        continue;
                    }
                    System.out.println("* *** *** ** * already drawn!!!");
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        if (null == this.mPreferredSize) {
            this.setPreferredSize(this.calculatePreferredSize());
        } else if (0 == this.mPreferredSize.width || 0 == this.mPreferredSize.height) {
            this.setPreferredSize(this.calculatePreferredSize());
        }
        return this.mPreferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.mPreferredSize = dimension;
    }

    protected Dimension calculatePreferredSize() {
        Dimension ret;
        Iterator<Tile> iterator = this.mMosaic.getTiles();
        int x = 0;
        int y = 0;
        Tile picture = null;
        while (iterator.hasNext()) {
            picture = iterator.next();
            Rectangle rectangle = picture.getBounds();
            if (rectangle.x + rectangle.width > x) {
                x = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height <= y) continue;
            y = rectangle.y + rectangle.height;
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            ret = parent.getSize();
            Insets insets = ((JViewport)parent).getInsets();
            ret.width -= insets.left + insets.right;
            ret.height -= insets.top + insets.bottom;
            if (0 != ret.width || 0 != ret.height) {
                ret.width -= 2;
            }
            if (ret.width < x) {
                ret.width = x;
            }
            if (ret.height < y) {
                ret.height = y;
            }
        } else {
            Insets insets = this.getInsets();
            ret = new Dimension(x += insets.left + insets.right, y += insets.top + insets.bottom);
        }
        return ret;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        Tile tile;
        if (!event.isMetaDown() && null != (tile = this.mMosaic.tileAt(event.getX(), event.getY()))) {
            this.bringToTop(tile);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void componentResized(ComponentEvent event) {
        this.setPreferredSize(null);
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void hierarchyChanged(HierarchyEvent event) {
        if (0L != (event.getChangeFlags() & 1L)) {
            Component dad = event.getChanged();
            Container parent = this.getParent();
            if (null != parent && parent.getParent() == dad) {
                dad.addComponentListener(this);
            }
        }
    }

    class Watcher
    implements ImageObserver {
        Component mTarget;
        Image mImage;
        int mX;
        int mY;
        int m_x;
        int m_y;
        public boolean drawn;

        public Watcher(Component component, Image image, int x, int y, int _x, int _y) {
            this.mTarget = component;
            this.mImage = image;
            this.mX = x;
            this.mY = y;
            this.m_x = _x;
            this.m_y = _y;
            this.drawn = false;
        }

        public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
            boolean ret;
            if (0 != (infoflags & 0x20)) {
                Graphics graphics = this.mTarget.getGraphics();
                if (null != graphics) {
                    int w = image.getWidth(null);
                    int h = image.getHeight(null);
                    graphics.drawImage(image, this.mX, this.mY, this.mX + w, this.mY + h, this.m_x, this.m_y, w, h, null);
                    this.drawn = true;
                }
                ret = false;
            } else {
                ret = true;
            }
            return ret;
        }
    }
}

