/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JViewport;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.Thumbelina;

public class Sequencer
extends Thread {
    protected static final int DEFAULT_DELAY = 500;
    protected Thumbelina mThumbelina;
    protected ArrayList<Picture> mPending;
    protected boolean mActive;
    protected int mDelay;
    protected Random mRandom;

    public Sequencer(Thumbelina thumbelina) {
        this.mThumbelina = thumbelina;
        this.mPending = new ArrayList();
        this.mActive = true;
        this.setDelay(500);
        this.mRandom = new Random();
        this.setName("Sequencer");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<Picture> arrayList = this.mPending;
        synchronized (arrayList) {
            this.mPending.clear();
            this.mThumbelina.mReadyProgress.setValue(0);
            this.mPending.notify();
        }
    }

    protected Point random(String url, int width, int height) {
        Dimension dim;
        Container parent = this.mThumbelina.getPicturePanel().getParent();
        if (parent instanceof JViewport) {
            Container grandparent = parent.getParent();
            dim = grandparent.getSize();
        } else {
            dim = this.mThumbelina.getPicturePanel().getSize();
        }
        int minx = 0;
        int miny = 0;
        int maxx = minx + dim.width;
        int maxy = miny + dim.height;
        this.mRandom.setSeed(((long)(width + height) << 32) + (long)url.hashCode());
        int rndx = (int)(this.mRandom.nextDouble() * (double)dim.width);
        int rndy = (int)(this.mRandom.nextDouble() * (double)dim.height);
        int corner = (int)(this.mRandom.nextDouble() * 4.0);
        Point ret = new Point(0, 0);
        switch (corner) {
            case 0: {
                ret.x = rndx + width >= maxx ? maxx - width : rndx;
                if (rndy + height >= maxy) {
                    ret.y = maxy - height;
                    break;
                }
                ret.y = rndy;
                break;
            }
            case 1: {
                ret.x = rndx - width < minx ? minx : rndx - width;
                if (rndy + height >= maxy) {
                    ret.y = maxy - height;
                    break;
                }
                ret.y = rndy;
                break;
            }
            case 2: {
                ret.x = rndx - width < minx ? minx : rndx - width;
                if (rndy - height < miny) {
                    ret.y = miny;
                    break;
                }
                ret.y = rndy - height;
                break;
            }
            case 3: {
                ret.x = rndx + width >= maxx ? maxx - width : rndx;
                if (rndy - height < miny) {
                    ret.y = miny;
                    break;
                }
                ret.y = rndy - height;
                break;
            }
            default: {
                throw new IllegalStateException("random corner = " + corner);
            }
        }
        if (ret.x < 0) {
            ret.x = 0;
        }
        if (ret.y < 0) {
            ret.y = 0;
        }
        return ret;
    }

    protected void place(Picture picture, boolean add) {
        if (Picture.ORIGIN == picture.getOrigin()) {
            Point p = this.random(picture.getIdentity().toString(), picture.width, picture.height);
            picture.x = p.x;
            picture.y = p.y;
            picture.setOrigin(p);
        }
        this.mThumbelina.getPicturePanel().draw(picture, add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Picture picture, boolean background) {
        if (picture.getValid()) {
            if (background) {
                ArrayList<Picture> arrayList = this.mPending;
                synchronized (arrayList) {
                    this.mPending.add(picture);
                    this.mPending.notify();
                }
            } else {
                this.place(picture, false);
            }
        } else {
            System.out.println(picture.getIdentity().toString() + " is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: while (true) {
            try {
                while (true) {
                    Picture picture = null;
                    ArrayList<Picture> arrayList = this.mPending;
                    synchronized (arrayList) {
                        if (this.mActive && !this.mPending.isEmpty()) {
                            picture = this.mPending.remove(0);
                        } else {
                            try {
                                this.mPending.wait();
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                        }
                    }
                    if (null == picture) continue;
                    this.place(picture, true);
                    if (0 == this.getDelay()) continue;
                    try {
                        Sequencer.sleep(this.getDelay());
                        continue block9;
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public int getDelay() {
        return this.mDelay;
    }

    public void setDelay(int delay) {
        this.mDelay = delay;
    }
}

